/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell.info.storage;

import com.google.common.collect.Sets;
import epicsquid.roots.Roots;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstance;
import epicsquid.roots.spell.SpellAugment;
import epicsquid.roots.spell.SpellExtension;
import epicsquid.roots.spell.SpellGrowthInfusion;
import epicsquid.roots.spell.SpellStormCloud;
import epicsquid.roots.spell.info.StaffSpellInfo;
import epicsquid.roots.spell.info.storage.AbstractSpellStorage;
import epicsquid.roots.util.SpellUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class StaffSpellStorage
extends AbstractSpellStorage<StaffSpellInfo> {
    public static int MAX_SPELL_SLOT = 5;
    public static int MIN_SPELL_SLOT = 1;
    private Int2ObjectOpenHashMap<StaffSpellInfo> spells = new Int2ObjectOpenHashMap();
    private static Set<String> REMOVED_SPELLS = Sets.newHashSet((Object[])new String[]{"spell_iced_touch", "spell_light_drifter", "spell_magnetism", "spell_rampant_growth", "spell_second_wind", "spell_sense_animals", "spell_sense_danger"});

    public StaffSpellStorage(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public boolean hasSpellInSlot() {
        return this.spells.get(this.selectedSlot) != null;
    }

    @Override
    public boolean isEmpty() {
        for (StaffSpellInfo v : this.spells.values()) {
            if (v == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid() {
        return SpellUtil.isValidStaff(this.stack);
    }

    @Override
    @Nullable
    public StaffSpellInfo getSpellInSlot(int slot) {
        if (slot < MIN_SPELL_SLOT || slot > MAX_SPELL_SLOT) {
            throw new IllegalStateException("Tried to get spell for invalid slot " + slot);
        }
        return (StaffSpellInfo)this.spells.get(slot);
    }

    public Collection<StaffSpellInfo> getSpells() {
        ArrayList<StaffSpellInfo> result = new ArrayList<StaffSpellInfo>();
        for (int i = MIN_SPELL_SLOT; i <= MAX_SPELL_SLOT; ++i) {
            StaffSpellInfo info = (StaffSpellInfo)this.spells.get(i);
            if (info == null) continue;
            result.add(info);
        }
        return result;
    }

    public void tick(long cd) {
        boolean ticked = false;
        for (StaffSpellInfo spell : this.getSpells()) {
            if (spell.tick()) {
                ticked = true;
            }
            if (!spell.validate(cd)) continue;
            ticked = true;
        }
        if (ticked) {
            this.saveToStack();
        }
    }

    @Override
    public int getCooldownLeft() {
        StaffSpellInfo info = this.getSelectedInfo();
        if (info == null) {
            return -1;
        }
        return info.cooldownLeft();
    }

    public boolean onCooldown() {
        StaffSpellInfo info = this.getSelectedInfo();
        if (info == null) {
            return false;
        }
        return info.onCooldown();
    }

    @Override
    public int getCooldown() {
        StaffSpellInfo info = this.getSelectedInfo();
        if (info == null) {
            return -1;
        }
        return info.cooldownTotal();
    }

    public void setCooldown(long cd) {
        StaffSpellInfo info = this.getSelectedInfo();
        if (info != null) {
            info.use(cd);
        }
        this.saveToStack();
    }

    @Override
    @Nullable
    public StaffSpellInfo getSelectedInfo() {
        return (StaffSpellInfo)this.spells.get(this.selectedSlot);
    }

    @Override
    public void clearSelectedSlot() {
        this.spells.put(this.selectedSlot, null);
        this.saveToStack();
    }

    @Override
    public void clearSlot(int slot) {
        if (slot > MAX_SPELL_SLOT || slot < MIN_SPELL_SLOT) {
            throw new IllegalArgumentException("Invalid argument for StaffSpellStorage::clearSlot, `slot`: " + slot + " cannot be contained within the constraints of " + MIN_SPELL_SLOT + "-" + MAX_SPELL_SLOT);
        }
        this.spells.put(slot, null);
        this.saveToStack();
    }

    @Override
    public void previousSlot() {
        int i;
        if (this.isEmpty()) {
            this.setSelectedSlot(1);
            this.saveToStack();
            return;
        }
        int originalSlot = this.selectedSlot;
        for (i = this.selectedSlot - 1; i >= MIN_SPELL_SLOT; --i) {
            if (this.spells.get(i) == null) continue;
            this.setSelectedSlot(i);
            this.saveToStack();
            return;
        }
        for (i = MAX_SPELL_SLOT; i >= originalSlot; --i) {
            if (this.spells.get(i) == null) continue;
            this.setSelectedSlot(i);
            this.saveToStack();
            return;
        }
        this.setSelectedSlot(originalSlot);
        this.saveToStack();
    }

    @Override
    public void nextSlot() {
        int i;
        if (this.isEmpty()) {
            this.setSelectedSlot(1);
            this.saveToStack();
            return;
        }
        int originalSlot = this.selectedSlot;
        if (this.selectedSlot + 1 <= MAX_SPELL_SLOT) {
            for (i = this.selectedSlot + 1; i <= MAX_SPELL_SLOT; ++i) {
                if (this.spells.get(i) == null) continue;
                this.setSelectedSlot(i);
                this.saveToStack();
                return;
            }
        }
        for (i = MIN_SPELL_SLOT; i < originalSlot; ++i) {
            if (this.spells.get(i) == null) continue;
            this.setSelectedSlot(i);
            this.saveToStack();
            return;
        }
        this.setSelectedSlot(originalSlot);
        this.saveToStack();
    }

    @Override
    public void addSpell(StaffSpellInfo spell) {
        if (this.hasFreeSlot()) {
            this.setSpellToSlot(this.getNextFreeSlot(), spell);
            this.saveToStack();
        }
    }

    @Override
    public void setSpellToSlot(int slot, StaffSpellInfo spell) {
        if (slot > MAX_SPELL_SLOT || slot < MIN_SPELL_SLOT) {
            throw new IllegalArgumentException("Invalid argument for StaffSpellStorage::setSpellToSlot, `slot`: " + slot + " cannot be contained within the constraints of " + MIN_SPELL_SLOT + "-" + MAX_SPELL_SLOT);
        }
        this.spells.put(slot, (Object)spell);
        this.saveToStack();
    }

    @Override
    public int getNextFreeSlot() {
        for (int i = MIN_SPELL_SLOT; i <= MAX_SPELL_SLOT; ++i) {
            if (this.spells.getOrDefault((Object)i, null) != null) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean hasFreeSlot() {
        return this.getNextFreeSlot() != -1;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        if (this.getSelectedInfo() == null) {
            for (int i = MIN_SPELL_SLOT; i <= MAX_SPELL_SLOT; ++i) {
                if (this.spells.get(i) == null) continue;
                this.setSelectedSlot(i);
                break;
            }
        }
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagCompound spells = new NBTTagCompound();
        for (Int2ObjectMap.Entry entry : this.spells.int2ObjectEntrySet()) {
            spells.func_74782_a(String.valueOf(entry.getIntKey()), (NBTBase)(entry.getValue() == null ? new NBTTagCompound() : ((StaffSpellInfo)entry.getValue()).serializeNBT()));
        }
        compound.func_74782_a("spells", (NBTBase)spells);
        compound.func_74768_a("selectedSlot", this.selectedSlot);
        return compound;
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_150297_b("spells", 10)) {
            NBTTagCompound spells = tag.func_74775_l("spells");
            Set keys = spells.func_150296_c();
            if (keys.size() > MAX_SPELL_SLOT) {
                Roots.logger.error("Invalid spell when deserializing storage: spells list is " + keys.size() + " which is greater than MAX_SPELL_SLOT " + MAX_SPELL_SLOT + ": " + tag.toString());
            }
            for (String key : keys) {
                int value = Integer.parseInt(key);
                StaffSpellInfo info = StaffSpellInfo.fromNBT(spells.func_74775_l(key));
                this.spells.put(value, (Object)info);
            }
            this.selectedSlot = tag.func_74762_e("selectedSlot");
        } else if (tag.func_74764_b("spell_0")) {
            for (int i = 0; i < 5; ++i) {
                if (!tag.func_74764_b("spell_" + i)) continue;
                StaffSpellInfo info = StaffSpellStorage.resolveSpell(tag.func_74779_i("spell_" + i));
                this.spells.put(i + 1, (Object)info);
            }
            this.selectedSlot = tag.func_74762_e("selectedSlot");
            this.saveToStack();
        }
    }

    @Nullable
    private static StaffSpellInfo resolveSpell(String spell_name) {
        if (!REMOVED_SPELLS.contains(spell_name)) {
            return StaffSpellInfo.fromRegistry(spell_name);
        }
        StaffSpellInfo info = null;
        switch (spell_name) {
            case "spell_iced_touch": {
                info = StaffSpellInfo.fromSpell(SpellStormCloud.instance, false);
                break;
            }
            case "spell_light_drifter": {
                info = StaffSpellInfo.fromSpell(SpellAugment.instance, false);
                for (StaffModifierInstance mod : info.getModifiers()) {
                    if (mod.getModifier() != SpellAugment.LIGHT_DRIFTER) continue;
                    mod.setApplied();
                    mod.setEnabled(true);
                }
                break;
            }
            case "spell_magnetism": {
                info = StaffSpellInfo.fromSpell(SpellAugment.instance, false);
                for (StaffModifierInstance mod : info.getModifiers()) {
                    if (mod.getModifier() != SpellAugment.MAGNETISM) continue;
                    mod.setApplied();
                    mod.setEnabled(true);
                }
                break;
            }
            case "spell_rampant_growth": {
                info = StaffSpellInfo.fromSpell(SpellGrowthInfusion.instance, false);
                for (StaffModifierInstance mod : info.getModifiers()) {
                    Modifier m = mod.getModifier();
                    if (m == SpellGrowthInfusion.RADIUS1) {
                        mod.setApplied();
                        mod.setEnabled(true);
                    }
                    if (m != SpellGrowthInfusion.RADIUS2 && m != SpellGrowthInfusion.RADIUS3) continue;
                    mod.setApplied();
                }
                break;
            }
            case "spell_second_wind": {
                info = StaffSpellInfo.fromSpell(SpellAugment.instance, false);
                for (StaffModifierInstance mod : info.getModifiers()) {
                    if (mod.getModifier() != SpellAugment.SECOND_WIND) continue;
                    mod.setApplied();
                    mod.setEnabled(true);
                }
                break;
            }
            case "spell_sense_animals": {
                info = StaffSpellInfo.fromSpell(SpellExtension.instance, false);
                for (StaffModifierInstance mod : info.getModifiers()) {
                    if (mod.getModifier() != SpellExtension.SENSE_ANIMALS) continue;
                    mod.setApplied();
                    mod.setEnabled(true);
                }
                break;
            }
            case "spell_sense_danger": {
                info = StaffSpellInfo.fromSpell(SpellExtension.instance, false);
                for (StaffModifierInstance mod : info.getModifiers()) {
                    if (mod.getModifier() != SpellExtension.SENSE_DANGER) continue;
                    mod.setApplied();
                    mod.setEnabled(true);
                }
                break;
            }
        }
        return info;
    }

    @Nullable
    public static StaffSpellStorage fromStack(ItemStack stack) {
        return StaffSpellStorage.fromStack(stack, StaffSpellStorage::new);
    }
}

