/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell.info.storage;

import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.info.AbstractSpellInfo;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractSpellStorage<V extends AbstractSpellInfo>
implements INBTSerializable<NBTTagCompound> {
    protected ItemStack stack;
    protected int selectedSlot = 1;

    public AbstractSpellStorage() {
    }

    protected AbstractSpellStorage(ItemStack stack) {
        this.stack = stack;
    }

    public abstract boolean hasSpellInSlot();

    public abstract boolean isEmpty();

    public abstract boolean isValid();

    @Nullable
    public abstract V getSpellInSlot(int var1);

    public int getCooldownLeft() {
        return -1;
    }

    public int getCooldown() {
        return -1;
    }

    @Nullable
    public V getSelectedInfo() {
        return this.getSpellInSlot(this.selectedSlot);
    }

    @SideOnly(value=Side.CLIENT)
    public String formatSelectedSpell() {
        V info = this.getSelectedInfo();
        if (info == null) {
            return "";
        }
        SpellBase spell = ((AbstractSpellInfo)info).getSpell();
        if (spell == null) {
            return "";
        }
        return "(" + spell.getTextColor() + TextFormatting.BOLD + I18n.func_135052_a((String)("roots.spell." + spell.getName() + ".name"), (Object[])new Object[0]) + TextFormatting.RESET + ")";
    }

    public abstract void clearSelectedSlot();

    public abstract void clearSlot(int var1);

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    public void setSelectedSlot(int slot) {
        this.selectedSlot = slot;
    }

    public abstract void previousSlot();

    public abstract void nextSlot();

    public abstract void addSpell(V var1);

    public abstract void setSpellToSlot(int var1, V var2);

    public int getNextFreeSlot() {
        return -1;
    }

    public boolean hasFreeSlot() {
        return this.getNextFreeSlot() != -1;
    }

    public abstract NBTTagCompound serializeNBT();

    public abstract void deserializeNBT(NBTTagCompound var1);

    @Nullable
    protected static <V extends AbstractSpellInfo, T extends AbstractSpellStorage<V>> T fromStack(ItemStack stack, Function<ItemStack, T> factory) {
        AbstractSpellStorage result = (AbstractSpellStorage)factory.apply(stack);
        if (!result.isValid()) {
            return null;
        }
        NBTTagCompound tag = ItemUtil.getOrCreateTag((ItemStack)stack);
        if (tag.func_74764_b("spell_storage")) {
            result.deserializeNBT(tag.func_74775_l("spell_storage"));
        } else if (tag.func_74764_b("spell_holder")) {
            result.deserializeNBT(tag.func_74775_l("spell_holder"));
            tag.func_82580_o("spell_holder");
            result.saveToStack();
        }
        return (T)result;
    }

    public void saveToStack() {
        NBTTagCompound tag = ItemUtil.getOrCreateTag((ItemStack)this.stack);
        tag.func_74782_a("spell_storage", (NBTBase)this.serializeNBT());
    }
}

