/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell.info;

import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.modifiers.instance.library.LibraryModifierInstanceList;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.info.AbstractSpellModifiers;
import epicsquid.roots.spell.info.StaffSpellInfo;
import epicsquid.roots.spell.info.storage.LibrarySpellStorage;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class LibrarySpellInfo
extends AbstractSpellModifiers<LibraryModifierInstanceList> {
    public static LibrarySpellInfo EMPTY = new LibrarySpellInfo();
    private boolean obtained;

    private LibrarySpellInfo() {
    }

    public LibrarySpellInfo(SpellBase spell) {
        super(spell);
        this.modifiers = new LibraryModifierInstanceList(spell);
        this.obtained = false;
    }

    @Override
    public LibraryModifierInstanceList getModifiers() {
        return (LibraryModifierInstanceList)this.modifiers;
    }

    @Override
    public void setModifiers(LibraryModifierInstanceList libraryModifierInstances) {
        this.modifiers = libraryModifierInstances;
    }

    public boolean isObtained() {
        return this.obtained;
    }

    public void setObtained() {
        this.setObtained(true);
    }

    public void setObtained(boolean value) {
        this.obtained = value;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound result = super.serializeNBT();
        result.func_74782_a("m", (NBTBase)((LibraryModifierInstanceList)this.modifiers).serializeNBT());
        result.func_74757_a("o", this.obtained);
        return result;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        SpellBase spell = this.getSpell();
        if (spell != null) {
            this.modifiers = new LibraryModifierInstanceList(spell);
            ((LibraryModifierInstanceList)this.modifiers).deserializeNBT(nbt.func_74775_l("m"));
            this.obtained = nbt.func_74767_n("o");
        }
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    public ItemStack asStack() {
        ItemStack stack = new ItemStack(ModItems.spell_icon);
        NBTTagCompound comp = ItemUtil.getOrCreateTag((ItemStack)stack);
        comp.func_74757_a("library", true);
        LibrarySpellStorage storage = LibrarySpellStorage.fromStack(stack);
        Objects.requireNonNull(storage).addSpell(this);
        return stack;
    }

    public StaffSpellInfo toStaff() {
        SpellBase spell = this.getSpell();
        if (spell != null) {
            StaffSpellInfo info = new StaffSpellInfo(spell);
            info.setModifiers(((LibraryModifierInstanceList)this.modifiers).toStaff());
            return info;
        }
        return StaffSpellInfo.EMPTY;
    }

    public static LibrarySpellInfo fromNBT(NBTTagCompound tag) {
        LibrarySpellInfo instance = new LibrarySpellInfo();
        instance.deserializeNBT(tag);
        return instance;
    }

    public static LibrarySpellInfo fromStaff(StaffSpellInfo incoming) {
        SpellBase spell = incoming.getSpell();
        if (spell != null) {
            LibrarySpellInfo instance = new LibrarySpellInfo(spell);
            instance.setObtained(true);
            instance.setModifiers(incoming.getModifiers().toLibrary());
            return instance;
        }
        return EMPTY;
    }
}

