/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.roots.entity.spell.EntityTimeStop;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessageTimeStopStartFX;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreIngredient;

public class SpellTimeStop
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(320);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.INSTANTANEOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("pereskia", 0.5));
    public static Property.PropertyCost PROP_COST_2 = new Property.PropertyCost(new SpellBase.SpellCost("moonglow_leaf", 0.5));
    public static Property.PropertyCost PROP_COST_3 = new Property.PropertyCost(new SpellBase.SpellCost("dewgonia", 0.325));
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 10).setDescription("the radius on the x axis");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 10).setDescription("the radius on the y axis");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 20).setDescription("the height of the time stop effect");
    public static Property<Integer> PROP_DURATION = new Property<Integer>("duration", 200).setDescription("the duration of the time stop effect on entities");
    public static Property<Integer> PROP_OVERTIME = new Property<Integer>("overtime", 200).setDescription("the extended duration that should apply when overtime is active");
    public static Property<Integer> PROP_UNDERTIME = new Property<Integer>("undertime", 100).setDescription("the shortened duration that is applied instead of the normal duration");
    public static Property<Integer> PROP_SLOWNESS_DURATION = new Property<Integer>("slowness_duration", 80).setDescription("duration in ticks of the slowness effect applied when the traps are triggered");
    public static Property<Integer> PROP_SLOWNESS_AMPLIFIER = new Property<Integer>("slowness_amplifier", 0).setDescription("the level of the slowness effect (0 is the first level)");
    public static Property<Integer> PROP_WEAKNESS_DURATION = new Property<Integer>("weakness_duration", 80).setDescription("duration in ticks of the weakness effect applied when the traps are triggered");
    public static Property<Integer> PROP_WEAKNESS_AMPLIFIER = new Property<Integer>("weakness_amplifier", 0).setDescription("the level of the weakness effect (0 is the first level)");
    public static Property<Integer> PROP_SPEED_DURATION = new Property<Integer>("speed_duration", 80).setDescription("duration in ticks of the speed effect applied when the traps are triggered");
    public static Property<Integer> PROP_SPEED_AMPLIFIER = new Property<Integer>("speed_amplifier", 0).setDescription("the level of the speed effect (0 is the first level)");
    public static Property<Integer> PROP_FIRE_DURATION = new Property<Integer>("fire_duration", 5).setDescription("the duration that entities should be set on fire for");
    public static Property<Float> PROP_COLD_DAMAGE = new Property<Float>("cold_damage", Float.valueOf(4.0f)).setDescription("the amount of cold damage given to entities when the effect ends");
    public static Modifier PEACEFUL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "peaceful_passage"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.125)));
    public static Modifier FAMILIARS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "freed_familiars"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.125)));
    public static Modifier LONGER = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "overtime"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.375)));
    public static Modifier SLOW = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "time_slip"), ModifierCores.TERRA_MOSS, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.TERRA_MOSS, 0.375)));
    public static Modifier WEAKNESS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "draining_stop"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.45)));
    public static Modifier SPEED = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "hasty_escape"), ModifierCores.CLOUD_BERRY, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.CLOUD_BERRY, 0.45)));
    public static Modifier FIRE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "burn_in_hell"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.45)));
    public static Modifier SHORTER = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "minor_halt"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.125)));
    public static Modifier FREEZE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "ice_age"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.345)));
    public static ResourceLocation spellName;
    public static SpellTimeStop instance;
    public int duration;
    public int slow_duration;
    public int slow_amplifier;
    public int overtime;
    public int weakness_duration;
    public int weakness_amplifier;
    public int speed_duration;
    public int speed_amplifier;
    public int fire_duration;
    public int undertime;
    public int radius_x;
    public int radius_y;
    public int radius_z;
    public float cold_damage;

    public SpellTimeStop(ResourceLocation name) {
        super(name, TextFormatting.DARK_BLUE, 0.2509804f, 0.2509804f, 0.2509804f, 0.7529412f, 0.1254902f, 1.0f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_COST_2, PROP_COST_3, PROP_RADIUS_X, PROP_RADIUS_Z, PROP_RADIUS_Y, PROP_DURATION, PROP_OVERTIME, PROP_UNDERTIME, PROP_SLOWNESS_AMPLIFIER, PROP_SLOWNESS_DURATION, PROP_WEAKNESS_AMPLIFIER, PROP_WEAKNESS_DURATION, PROP_SPEED_AMPLIFIER, PROP_SPEED_DURATION, PROP_FIRE_DURATION, PROP_COLD_DAMAGE);
        this.acceptModifiers(PEACEFUL, FAMILIARS, LONGER, SLOW, WEAKNESS, SPEED, FIRE, SHORTER, FREEZE);
    }

    @Override
    public void init() {
        this.addIngredients(new OreIngredient("enderpearl"), new ItemStack(ModItems.moonglow_leaf), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185246_r), new ItemStack(ModItems.pereskia), new ItemStack(Items.field_151113_aN));
        this.setCastSound(ModSounds.Spells.TIME_STOP);
    }

    @Override
    public boolean cast(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        if (!player.field_70170_p.field_72995_K) {
            int dur = this.duration;
            if (info.has(LONGER)) {
                dur += this.overtime;
            }
            if (info.has(SHORTER)) {
                dur = this.undertime;
            }
            EntityTimeStop timeStop = new EntityTimeStop(player.field_70170_p, dur);
            timeStop.setPlayer(player.func_110124_au());
            timeStop.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            timeStop.setModifiers(info);
            player.field_70170_p.func_72838_d((Entity)timeStop);
            PacketHandler.sendToAllTracking((IMessage)new MessageTimeStopStartFX(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v), (Entity)player);
            if (info.has(SPEED)) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, this.speed_duration, this.speed_amplifier));
            }
        }
        return true;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.duration = this.properties.get(PROP_DURATION);
        int[] radius = this.properties.getRadius();
        this.radius_x = radius[0];
        this.radius_y = radius[1];
        this.radius_z = radius[2];
        this.slow_duration = this.properties.get(PROP_SLOWNESS_DURATION);
        this.slow_amplifier = this.properties.get(PROP_SLOWNESS_AMPLIFIER);
        this.overtime = this.properties.get(PROP_OVERTIME);
        this.weakness_amplifier = this.properties.get(PROP_WEAKNESS_AMPLIFIER);
        this.weakness_duration = this.properties.get(PROP_WEAKNESS_DURATION);
        this.slow_amplifier = this.properties.get(PROP_SLOWNESS_AMPLIFIER);
        this.slow_duration = this.properties.get(PROP_SLOWNESS_DURATION);
        this.fire_duration = this.properties.get(PROP_FIRE_DURATION);
        this.undertime = this.properties.get(PROP_UNDERTIME);
        this.speed_duration = this.properties.get(PROP_SPEED_DURATION);
        this.speed_amplifier = this.properties.get(PROP_SPEED_AMPLIFIER);
        this.cold_damage = this.properties.get(PROP_COLD_DAMAGE).floatValue();
    }

    static {
        SHORTER.addConflicts(LONGER);
        spellName = new ResourceLocation("roots", "spell_time_stop");
        instance = new SpellTimeStop(spellName);
    }
}

