/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.roots.init.ModDamage;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessageRadianceBeamFX;
import epicsquid.roots.properties.Property;
import epicsquid.roots.recipe.ingredient.GoldOrSilverIngotIngredient;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreIngredient;

public class SpellRadiance
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(10);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.CONTINUOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("cloud_berry", 0.5));
    public static Property.PropertyCost PROP_COST_2 = new Property.PropertyCost(new SpellBase.SpellCost("pereskia", 0.25));
    public static Property<Float> PROP_DISTANCE = new Property<Float>("distance", Float.valueOf(32.0f)).setDescription("maximum reach of radiance beam");
    public static Property.PropertyDamage PROP_DAMAGE = new Property.PropertyDamage(Float.valueOf(5.0f)).setDescription("damage dealt each time by radiance beam");
    public static Property<Float> PROP_UNDEAD_DAMAGE = new Property<Float>("undead_damage", Float.valueOf(3.0f)).setDescription("damage dealt each time by radiance beam on undead mobs");
    public static Property<Integer> PROP_WITHER_DURATION = new Property<Integer>("wither_duration", 100).setDescription("the duration of the wither effect to apply to affected entities");
    public static Property<Integer> PROP_GLOW_DURATION = new Property<Integer>("glow_duration", 200).setDescription("the duration of the glow effect to apply to affected entities");
    public static Property<Integer> PROP_POISON_DURATION = new Property<Integer>("poison_duration", 100).setDescription("the duration of the poison effect to apply to affected entities");
    public static Property<Integer> PROP_POISON_AMPLIFIER = new Property<Integer>("poison_amplifier", 0).setDescription("the amplifier to use for the poison effect");
    public static Property<Integer> PROP_SLOW_DURATION = new Property<Integer>("slow_duration", 100).setDescription("the duration of the slow effect to apply to affected entities");
    public static Property<Integer> PROP_SLOW_AMPLIFIER = new Property<Integer>("slow_amplifier", 0).setDescription("the amplifier to use for the slow effect");
    public static Property<Integer> PROP_FIRE_DURATION = new Property<Integer>("fire_duration", 100).setDescription("the duration of the fire effect to apply to affected entities");
    public static Property<Float> PROP_WIDTH = new Property<Float>("width", Float.valueOf(0.1f)).setDescription("default width of the radiance beam");
    public static Property<Float> PROP_ADDED_WIDTH = new Property<Float>("added_width", Float.valueOf(0.3f)).setDescription("width added to the default radiance beam");
    public static Property<Float> PROP_HEALING = new Property<Float>("healing", Float.valueOf(2.0f)).setDescription("the amount of healing each strike of the beam should do");
    public static Modifier PEACEFUL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "peaceful_radiance"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.125)));
    public static Modifier MAGNETISM = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "magnetic_radiance"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.375)));
    public static Modifier WITHER = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "withering_ray"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.275)));
    public static Modifier GLOWING = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "glowing_ray"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.125)));
    public static Modifier HEALING = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "healing_ray"), ModifierCores.TERRA_MOSS, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.TERRA_MOSS, 0.475)));
    public static Modifier POISON = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "sickly_ray"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.345)));
    public static Modifier FIRE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "burning_ray"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.345)));
    public static Modifier BIGGER = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "wider_ray"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.275)));
    public static Modifier SLOW = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "slowing_ray"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.345)));
    public static ResourceLocation spellName;
    public static SpellRadiance instance;
    private int wither_duration;
    private int glow_duration;
    private int poison_duration;
    private int poison_amplifier;
    private int fire_duration;
    private int slowness_duration;
    private int slowness_amplifier;
    public float distance;
    private float damage;
    private float undeadDamage;
    private float width;
    private float added_width;
    private float healing;

    public SpellRadiance(ResourceLocation name) {
        super(name, TextFormatting.WHITE, 1.0f, 1.0f, 0.2509804f, 1.0f, 1.0f, 0.7529412f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_COST_2, PROP_DISTANCE, PROP_DAMAGE, PROP_UNDEAD_DAMAGE, PROP_WITHER_DURATION, PROP_POISON_DURATION, PROP_SLOW_AMPLIFIER, PROP_SLOW_DURATION, PROP_FIRE_DURATION, PROP_GLOW_DURATION, PROP_WIDTH, PROP_ADDED_WIDTH, PROP_HEALING, PROP_POISON_AMPLIFIER);
        this.acceptModifiers(PEACEFUL, MAGNETISM, WITHER, GLOWING, HEALING, POISON, FIRE, BIGGER, SLOW);
    }

    @Override
    public void init() {
        this.addIngredients(new Object[]{new GoldOrSilverIngotIngredient(), new OreIngredient("torch"), new OreIngredient("dyeYellow"), new ItemStack(ModItems.cloud_berry), new ItemStack(ModItems.pereskia)});
        this.setCastSound(ModSounds.Spells.RADIANCE);
    }

    @Override
    public boolean cast(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        if (!player.field_70170_p.field_72995_K && player.field_70173_aa % 2 == 0) {
            float w = this.width;
            if (info.has(BIGGER)) {
                w += this.added_width;
            }
            float distance = this.distance;
            RayTraceResult result = player.field_70170_p.func_147447_a(player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0), player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0).func_178787_e(player.func_70040_Z().func_186678_a((double)distance)), false, true, true);
            Vec3d direction = player.func_70040_Z();
            ArrayList<Vec3d> positions = new ArrayList<Vec3d>();
            float offX = 0.5f * (float)Math.sin(Math.toRadians(-90.0f - player.field_70177_z));
            float offZ = 0.5f * (float)Math.cos(Math.toRadians(-90.0f - player.field_70177_z));
            positions.add(new Vec3d(player.field_70165_t + (double)offX, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v + (double)offZ));
            if (result != null) {
                positions.add(result.field_72307_f);
                if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                    Vec3i hitSide = result.field_178784_b.func_176730_m();
                    float xCoeff = 1.0f;
                    if (hitSide.func_177958_n() != 0) {
                        xCoeff = -1.0f;
                    }
                    float yCoeff = 1.0f;
                    if (hitSide.func_177956_o() != 0) {
                        yCoeff = -1.0f;
                    }
                    float zCoeff = 1.0f;
                    if (hitSide.func_177952_p() != 0) {
                        zCoeff = -1.0f;
                    }
                    direction = new Vec3d(direction.field_72450_a * (double)xCoeff, direction.field_72448_b * (double)yCoeff, direction.field_72449_c * (double)zCoeff);
                    if ((distance = (float)((double)distance - result.field_72307_f.func_178788_d(player.func_174791_d()).func_72433_c())) > 0.0f) {
                        RayTraceResult result2 = player.field_70170_p.func_72933_a(result.field_72307_f, result.field_72307_f.func_178787_e(direction.func_186678_a((double)distance)));
                        if (result2 != null) {
                            positions.add(result2.field_72307_f);
                            if (result2.field_72313_a == RayTraceResult.Type.BLOCK) {
                                hitSide = result2.field_178784_b.func_176730_m();
                                xCoeff = 1.0f;
                                if (hitSide.func_177958_n() != 0) {
                                    xCoeff = -1.0f;
                                }
                                yCoeff = 1.0f;
                                if (hitSide.func_177956_o() != 0) {
                                    yCoeff = -1.0f;
                                }
                                zCoeff = 1.0f;
                                if (hitSide.func_177952_p() != 0) {
                                    zCoeff = -1.0f;
                                }
                                direction = new Vec3d(direction.field_72450_a * (double)xCoeff, direction.field_72448_b * (double)yCoeff, direction.field_72449_c * (double)zCoeff);
                                if ((distance = (float)((double)distance - result2.field_72307_f.func_178788_d(player.func_174791_d()).func_72433_c())) > 0.0f) {
                                    RayTraceResult result3 = player.field_70170_p.func_72933_a(result2.field_72307_f, result2.field_72307_f.func_178787_e(direction.func_186678_a((double)distance)));
                                    if (result3 != null) {
                                        positions.add(result3.field_72307_f);
                                    } else {
                                        positions.add(result2.field_72307_f.func_178787_e(direction.func_186678_a((double)distance)));
                                    }
                                }
                            }
                        } else {
                            positions.add(result.field_72307_f.func_178787_e(direction.func_186678_a((double)distance)));
                        }
                    }
                }
            } else {
                positions.add(player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0).func_178787_e(player.func_70040_Z().func_186678_a((double)distance)));
            }
            int count = 0;
            if (positions.size() > 1) {
                for (int i = 0; i < positions.size() - 1; ++i) {
                    double bx = Math.abs(((Vec3d)positions.get((int)(i + 1))).field_72450_a - ((Vec3d)positions.get((int)i)).field_72450_a) * (double)w;
                    double by = Math.abs(((Vec3d)positions.get((int)(i + 1))).field_72448_b - ((Vec3d)positions.get((int)i)).field_72448_b) * (double)w;
                    double bz = Math.abs(((Vec3d)positions.get((int)(i + 1))).field_72449_c - ((Vec3d)positions.get((int)i)).field_72449_c) * (double)w;
                    for (float j = 0.0f; j < 1.0f; j += 0.1f) {
                        double x = ((Vec3d)positions.get((int)i)).field_72450_a * (double)(1.0f - j) + ((Vec3d)positions.get((int)(i + 1))).field_72450_a * (double)j;
                        double y = ((Vec3d)positions.get((int)i)).field_72448_b * (double)(1.0f - j) + ((Vec3d)positions.get((int)(i + 1))).field_72448_b * (double)j;
                        double z = ((Vec3d)positions.get((int)i)).field_72449_c * (double)(1.0f - j) + ((Vec3d)positions.get((int)(i + 1))).field_72449_c * (double)j;
                        List entities = player.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(x - bx, y - by, z - bz, x + bx, y + by, z + bz));
                        for (EntityLivingBase e : entities) {
                            if (e == player) continue;
                            if (info.has(HEALING)) {
                                if (!EntityUtil.isFriendly((Entity)e, instance) && !(e instanceof EntityPlayer)) continue;
                                e.func_70691_i(this.healing);
                                ++count;
                                continue;
                            }
                            if (info.has(PEACEFUL) && EntityUtil.isFriendly((Entity)e, instance) || e instanceof EntityPlayer && !FMLCommonHandler.instance().getMinecraftServerInstance().func_71219_W() || e.field_70737_aN > 0 || e.field_70128_L) continue;
                            if (info.has(MAGNETISM)) {
                                e.getEntityData().func_186854_a("magnetic", player.func_110124_au());
                                e.getEntityData().func_74768_a("magnetic_ticks", e.field_70173_aa);
                            }
                            e.func_70097_a(ModDamage.radiantDamageFrom((Entity)player), this.damage);
                            if (e.func_70662_br()) {
                                e.func_70097_a(ModDamage.radiantDamageFrom((Entity)player), this.undeadDamage);
                            }
                            e.func_70604_c((EntityLivingBase)player);
                            player.func_130011_c((Entity)e);
                            if (info.has(WITHER)) {
                                e.func_70690_d(new PotionEffect(MobEffects.field_82731_v, this.wither_duration));
                            }
                            if (info.has(GLOWING)) {
                                e.func_70690_d(new PotionEffect(MobEffects.field_188423_x, this.glow_duration));
                            }
                            if (info.has(POISON)) {
                                e.func_70690_d(new PotionEffect(MobEffects.field_76436_u, this.poison_duration, this.poison_amplifier));
                            }
                            if (info.has(FIRE)) {
                                e.func_70015_d(this.fire_duration);
                            }
                            if (info.has(SLOW)) {
                                e.func_70690_d(new PotionEffect(MobEffects.field_76421_d, this.slowness_duration, this.slowness_amplifier));
                            }
                            ++count;
                        }
                    }
                }
            }
            PacketHandler.sendToAllTracking((IMessage)new MessageRadianceBeamFX(player.func_110124_au(), player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, count > 0), (Entity)player);
            return count > 0;
        }
        return false;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.distance = this.properties.get(PROP_DISTANCE).floatValue();
        this.damage = this.properties.get(PROP_DAMAGE).floatValue();
        this.undeadDamage = this.properties.get(PROP_UNDEAD_DAMAGE).floatValue();
        this.wither_duration = this.properties.get(PROP_WITHER_DURATION);
        this.glow_duration = this.properties.get(PROP_GLOW_DURATION);
        this.poison_duration = this.properties.get(PROP_POISON_DURATION);
        this.poison_amplifier = this.properties.get(PROP_POISON_AMPLIFIER);
        this.fire_duration = this.properties.get(PROP_FIRE_DURATION);
        this.slowness_duration = this.properties.get(PROP_SLOW_DURATION);
        this.slowness_amplifier = this.properties.get(PROP_SLOW_AMPLIFIER);
        this.width = this.properties.get(PROP_WIDTH).floatValue();
        this.added_width = this.properties.get(PROP_ADDED_WIDTH).floatValue();
        this.healing = this.properties.get(PROP_HEALING).floatValue();
    }

    static {
        HEALING.addConflicts(WITHER, PEACEFUL, POISON, FIRE, SLOW);
        spellName = new ResourceLocation("roots", "spell_radiance");
        instance = new SpellRadiance(spellName);
    }
}

