/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.RayCastUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModDamage;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessageLifeDrainAbsorbFX;
import epicsquid.roots.network.fx.MessageTargetedLifeDrainFX;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.EntityUtil;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SpellLifeDrain
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(0);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.CONTINUOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("moonglow_leaf", 0.325));
    public static Property.PropertyCost PROP_COST_2 = new Property.PropertyCost(new SpellBase.SpellCost("baffle_cap", 0.25));
    public static Property<Float> PROP_WITHER_DAMAGE = new Property<Float>("wither_damage", Float.valueOf(3.0f)).setDescription("wither damage dealt to the enemies (different from the damage dealt by the wither itself)");
    public static Property<Float> PROP_HEAL = new Property<Float>("heal", Float.valueOf(1.5f)).setDescription("health points restored to the player");
    public static Property<Integer> PROP_WITHER_DURATION = new Property<Integer>("wither_duration", 70).setDescription("duration in ticks of the wither effect");
    public static Property<Integer> PROP_WITHER_AMPLIFICATION = new Property<Integer>("wither_amplifier", 0).setDescription("the level of the wither effect (0 is the first level)");
    public static Property<Integer> PROP_WITHER_CHANCE = new Property<Integer>("wither_chance", 4).setDescription("chance for the enemies to be affected by a wither effect (the higher the number is the lower the chance is: 1/x) [default: 1/4]");
    public static Property<Float> PROP_ADDITIONAL_HEAL = new Property<Float>("additional_heal", Float.valueOf(1.5f)).setDescription("how much additional healing should be done");
    public static Property<Float> PROP_SPECTRAL_CHANCE = new Property<Float>("spectral_chance", Float.valueOf(0.35f)).setDescription("chance per cast of a spectral entity existing");
    public static Property<Double> PROP_DISTANCE = new Property<Double>("distance", 15.0).setDescription("the distance that the targeted beam of life drain should extend for in blocks");
    public static Property<Integer> PROP_FIRE_DURATION = new Property<Integer>("fire_duration", 4).setDescription("the duration that relevant entities should be set aflame for in seconds");
    public static Property<Float> PROP_FIRE_DAMAGE = new Property<Float>("fire_damage", Float.valueOf(2.5f)).setDescription("the additional fire damage (that does not heal)");
    public static Property<Integer> PROP_SLOW_DURATION = new Property<Integer>("slow_duration", 100).setDescription("the duration of the slow effect");
    public static Property<Integer> PROP_SLOW_AMPLIFIER = new Property<Integer>("slow_amplifier", 0).setDescription("the info.amplifier to be applied to the slow effect");
    public static Modifier RATIO = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "amplified_healing"), ModifierCores.PERESKIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.75)));
    public static Modifier PEACEFUL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "peaceful_drain"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.125)));
    public static Modifier DISTRIBUTE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "distributed_healing"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.375)));
    public static Modifier SPIRITS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "spectral_drain"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 1.5)));
    public static Modifier TARGET = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "targeted_drain"), ModifierCores.TERRA_MOSS, Cost.of(Cost.cost(CostType.ADDITIONAL_COST, ModifierCores.TERRA_MOSS, 0.125), Cost.cost(CostType.ALL_COST_MULTIPLIER, -0.275))));
    public static Modifier DAMAGE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "lightened_load"), ModifierCores.CLOUD_BERRY, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.CLOUD_BERRY, 0.25)));
    public static Modifier FIRE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "brimstone"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.375)));
    public static Modifier SLOWING = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "slowing_drain"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.345)));
    public static Modifier CHTHONIC = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "chthonic"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.345)));
    public static ResourceLocation spellName;
    public static SpellLifeDrain instance;
    private float witherDamage;
    private float heal;
    private float additionalHeal;
    private float spectralChance;
    private float fire_damage;
    private int witherDuration;
    private int witherChance;
    private int witherAmplification;
    private int fire_duration;
    private int slow_duration;
    private int slow_amplifier;
    public double distance;

    public SpellLifeDrain(ResourceLocation name) {
        super(name, TextFormatting.DARK_GRAY, 0.5647059f, 0.1254902f, 0.2509804f, 1.0f, 0.76862746f, 0.9411765f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_COST_2, PROP_WITHER_DAMAGE, PROP_HEAL, PROP_WITHER_DURATION, PROP_WITHER_AMPLIFICATION, PROP_WITHER_CHANCE, PROP_ADDITIONAL_HEAL, PROP_SPECTRAL_CHANCE, PROP_DISTANCE, PROP_FIRE_DAMAGE, PROP_FIRE_DURATION, PROP_SLOW_AMPLIFIER, PROP_SLOW_DURATION);
        this.acceptModifiers(RATIO, PEACEFUL, DISTRIBUTE, SPIRITS, TARGET, DAMAGE, FIRE, SLOWING, CHTHONIC);
    }

    @Override
    public void init() {
        this.addIngredients(new ItemStack(Item.func_150898_a((Block)ModBlocks.baffle_cap_mushroom)), new ItemStack(ModItems.moonglow_leaf), new ItemStack(ModItems.moonglow_seed), new ItemStack(Items.field_151052_q), new ItemStack(Blocks.field_150411_aY));
        this.setCastSound(ModSounds.Spells.LIFE_DRAIN);
    }

    private boolean handleEntity(EntityPlayer player, EntityLivingBase e, StaffModifierInstanceList info, List<EntityLivingBase> peacefuls, float dam, float h) {
        if (e != player && (!(e instanceof EntityPlayer) || FMLCommonHandler.instance().getMinecraftServerInstance().func_71219_W())) {
            if (info.has(PEACEFUL) && EntityUtil.isFriendly((Entity)e, instance)) {
                return false;
            }
            if (e.field_70737_aN <= 0 && !e.field_70128_L) {
                if (!player.field_70170_p.field_72995_K) {
                    if (info.has(CHTHONIC) && EntityUtil.isAquatic((Entity)e) && e.func_70090_H()) {
                        dam *= 2.0f;
                    }
                    e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)player), dam);
                    if (e.field_70146_Z.nextInt(this.witherChance) == 0) {
                        e.func_70690_d(new PotionEffect(MobEffects.field_82731_v, this.witherDuration, this.witherAmplification));
                    }
                    if (info.has(SLOWING)) {
                        e.func_70690_d(new PotionEffect(MobEffects.field_76421_d, this.slow_duration, this.slow_amplifier));
                    }
                    if (info.has(FIRE)) {
                        e.func_70015_d(this.fire_duration);
                        e.func_70097_a(ModDamage.fireDamageFrom((Entity)player), this.fire_damage);
                    }
                    e.func_70604_c((EntityLivingBase)player);
                    e.func_130011_c((Entity)player);
                    if (info.has(DISTRIBUTE)) {
                        peacefuls.forEach(o -> o.func_70691_i(h));
                    } else {
                        player.func_70691_i(h);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean cast(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        if (!player.field_70170_p.field_72995_K) {
            boolean foundTarget = false;
            float heal = this.heal;
            if (info.has(RATIO)) {
                heal += this.additionalHeal;
            }
            float dam = this.witherDamage;
            if (info.has(DAMAGE)) {
                heal /= 2.0f;
                dam *= 2.0f;
            }
            float h = heal;
            if (info.has(TARGET)) {
                List entitiesBeam = RayCastUtil.rayTraceEntities(EntityLivingBase.class, (Entity)player, (double)this.distance);
                EntityLivingBase targeted = null;
                for (EntityLivingBase target : entitiesBeam) {
                    if (!this.handleEntity(player, target, info, Collections.emptyList(), dam, h)) continue;
                    targeted = target;
                }
                if (targeted != null) {
                    foundTarget = true;
                    MessageTargetedLifeDrainFX packet = new MessageTargetedLifeDrainFX(player, (Entity)targeted);
                    PacketHandler.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)player);
                }
            } else {
                PacketHandler.sendToAllTracking((IMessage)new MessageLifeDrainAbsorbFX(player.func_110124_au(), player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v), (Entity)player);
                for (int i = 0; i < 4 && !foundTarget; ++i) {
                    double x = player.field_70165_t + player.func_70040_Z().field_72450_a * 3.0 * (double)i;
                    double y = player.field_70163_u + (double)player.func_70047_e() + player.func_70040_Z().field_72448_b * 3.0 * (double)i;
                    double z = player.field_70161_v + player.func_70040_Z().field_72449_c * 3.0 * (double)i;
                    List entities = player.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(x - 2.0, y - 2.0, z - 2.0, x + 2.0, y + 2.0, z + 2.0));
                    List<EntityLivingBase> peacefuls = entities.stream().filter(o -> EntityUtil.isFriendly((Entity)o, instance)).collect(Collectors.toList());
                    for (EntityLivingBase e : entities) {
                        if (!this.handleEntity(player, e, info, peacefuls, dam, h)) continue;
                        foundTarget = true;
                    }
                }
            }
            if (!foundTarget && info.has(SPIRITS) && Util.rand.nextFloat() < this.spectralChance) {
                player.func_70691_i(h);
            }
        }
        return true;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.witherDamage = this.properties.get(PROP_WITHER_DAMAGE).floatValue();
        this.heal = this.properties.get(PROP_HEAL).floatValue();
        this.witherDuration = this.properties.get(PROP_WITHER_DURATION);
        this.witherAmplification = this.properties.get(PROP_WITHER_AMPLIFICATION);
        this.witherChance = this.properties.get(PROP_WITHER_CHANCE);
        this.additionalHeal = this.properties.get(PROP_ADDITIONAL_HEAL).floatValue();
        this.spectralChance = this.properties.get(PROP_SPECTRAL_CHANCE).floatValue();
        this.fire_damage = this.properties.get(PROP_FIRE_DAMAGE).floatValue();
        this.fire_duration = this.properties.get(PROP_FIRE_DURATION);
        this.slow_amplifier = this.properties.get(PROP_SLOW_AMPLIFIER);
        this.slow_duration = this.properties.get(PROP_SLOW_DURATION);
        this.distance = this.properties.get(PROP_DISTANCE);
    }

    static {
        TARGET.addConflicts(SPIRITS, DISTRIBUTE);
        SPIRITS.addConflicts(DISTRIBUTE);
        spellName = new ResourceLocation("roots", "spell_life_drain");
        instance = new SpellLifeDrain(spellName);
    }
}

