/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.AABBUtil;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.init.ModPotions;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessageSenseFX;
import epicsquid.roots.network.fx.MessageSenseHomeFX;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.OreDictCache;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public class SpellExtension
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(350);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.INSTANTANEOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("wildroot", 0.45));
    public static Property<Integer> PROP_RADIUS_ANIMALS_X = new Property<Integer>("radius_animals_x", 50).setDescription("radius on the X axis within which entities are affected by the spell");
    public static Property<Integer> PROP_RADIUS_ANIMALS_Y = new Property<Integer>("radius_animals_y", 25).setDescription("radius on the Y axis within which entities are affected by the spell");
    public static Property<Integer> PROP_RADIUS_ANIMALS_Z = new Property<Integer>("radius_animals_z", 50).setDescription("radius on the Z axis within which entities are affected by the spell");
    public static Property<Integer> PROP_RADIUS_HOSTILES_X = new Property<Integer>("radius_hostiles_x", 50).setDescription("radius on the X axis within which entities are affected by the spell");
    public static Property<Integer> PROP_RADIUS_HOSTILES_Y = new Property<Integer>("radius_hostiles_y", 25).setDescription("radius on the Y axis within which entities are affected by the spell");
    public static Property<Integer> PROP_RADIUS_HOSTILES_Z = new Property<Integer>("radius_hostiles_z", 50).setDescription("radius on the Z axis within which entities are affected by the spell");
    public static Property<Integer> PROP_RADIUS_PLANTS_X = new Property<Integer>("radius_plants_x", 50).setDescription("radius on the X axis within which entities are affected by the spell");
    public static Property<Integer> PROP_RADIUS_PLANTS_Y = new Property<Integer>("radius_plants_y", 25).setDescription("radius on the Y axis within which entities are affected by the spell");
    public static Property<Integer> PROP_RADIUS_PLANTS_Z = new Property<Integer>("radius_plants_z", 50).setDescription("radius on the Z axis within which entities are affected by the spell");
    public static Property<Integer> PROP_ANIMAL_DURATION = new Property<Integer>("animal_glow_duration", 800).setDescription("the duration of the glow effect when applied to passive entities");
    public static Property<Integer> PROP_ENEMY_DURATION = new Property<Integer>("enemy_glow_duration", 800).setDescription("the duration of the glow effect when applied to hostile entities");
    public static Property<Integer> PROP_NIGHT_VISION = new Property<Integer>("night_vision", 800).setDescription("how long the danger sense effect is applied to the player");
    public static Property<Integer> PROP_RADIUS_ORE_X = new Property<Integer>("radius_ore_x", 15).setDescription("radius on the X axis within which ores are searched for");
    public static Property<Integer> PROP_RADIUS_ORE_Y = new Property<Integer>("radius_ore_y", 15).setDescription("radius on the Y axis within which ores are searched for");
    public static Property<Integer> PROP_RADIUS_ORE_Z = new Property<Integer>("radius_ore_z", 15).setDescription("radius on the Z axis within which ores are searched for");
    public static Property<Integer> PROP_RADIUS_ORE_SPECIFIC_X = new Property<Integer>("radius_ore_specific_x", 30).setDescription("radius on the X axis within which specific ores are searched for");
    public static Property<Integer> PROP_RADIUS_ORE_SPECIFIC_Y = new Property<Integer>("radius_ore_specific_y", 30).setDescription("radius on the Y axis within which specific ores are searched for");
    public static Property<Integer> PROP_RADIUS_ORE_SPECIFIC_Z = new Property<Integer>("radius_ore_specific_z", 30).setDescription("radius on the Z axis within which specific ores are searched for");
    public static Property<Integer> PROP_RADIUS_LIQUID_X = new Property<Integer>("radius_liquid_x", 30).setDescription("radius on the X axis within which liquids are searched for");
    public static Property<Integer> PROP_RADIUS_LIQUID_Y = new Property<Integer>("radius_liquid_y", 30).setDescription("radius on the Y axis within which liquids are searched for");
    public static Property<Integer> PROP_RADIUS_LIQUID_Z = new Property<Integer>("radius_liquid_z", 30).setDescription("radius on the Z axis within which liquids are searched for");
    public static Property<Integer> PROP_RADIUS_CONTAINER_X = new Property<Integer>("radius_container_x", 30).setDescription("radius on the X axis within which containers are searched for");
    public static Property<Integer> PROP_RADIUS_CONTAINER_Y = new Property<Integer>("radius_container_y", 30).setDescription("radius on the Y axis within which containers are searched for");
    public static Property<Integer> PROP_RADIUS_CONTAINER_Z = new Property<Integer>("radius_container_z", 30).setDescription("radius on the Z axis within which containers are searched for");
    public static Property<Integer> PROP_RADIUS_SPAWNER_X = new Property<Integer>("radius_spawner_x", 30).setDescription("radius on the X axis within which spawners are searched for");
    public static Property<Integer> PROP_RADIUS_SPAWNER_Y = new Property<Integer>("radius_spawner_y", 30).setDescription("radius on the Y axis within which spawners are searched for");
    public static Property<Integer> PROP_RADIUS_SPAWNER_Z = new Property<Integer>("radius_spawner_z", 30).setDescription("radius on the Z axis within which spawners are searched for");
    public static Modifier SENSE_HOME = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "sense_home"), ModifierCores.PERESKIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.125)));
    public static Modifier SENSE_ANIMALS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "sense_animals"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.125)));
    public static Modifier NONDETECTION = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "nondetection"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.6)));
    public static Modifier SENSE_TIME = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "sense_time"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.05)));
    public static Modifier SENSE_DANGER = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "sense_hostiles"), ModifierCores.TERRA_MOSS, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.TERRA_MOSS, 0.375)));
    public static Modifier SENSE_PLANTS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "sense_plants"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.25)));
    public static Modifier SENSE_CONTAINERS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "sense_containers"), ModifierCores.CLOUD_BERRY, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.CLOUD_BERRY, 0.25)));
    public static Modifier SENSE_SPAWNERS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "sense_spawners"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.25)));
    public static Modifier SENSE_ORES = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "sense_ores"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.475)));
    public static Modifier SENSE_LIQUIDS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "sense_liquids"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.125)));
    public static ResourceLocation spellName = new ResourceLocation("roots", "spell_extension");
    public static SpellExtension instance = new SpellExtension(spellName);
    private AxisAlignedBB ore;
    private AxisAlignedBB ore_specific;
    private AxisAlignedBB liquid;
    private AxisAlignedBB container;
    private AxisAlignedBB spawner;
    private AxisAlignedBB plants;
    private int radius_animals_x;
    private int radius_animals_y;
    private int radius_animals_z;
    private int animal_duration;
    private int enemy_duration;
    private int night_vision;
    private int radius_ore_x;
    private int radius_ore_y;
    private int radius_ore_z;
    private int radius_ore_specific_x;
    private int radius_ore_specific_y;
    private int radius_ore_specific_z;
    private int radius_liquid_x;
    private int radius_liquid_y;
    private int radius_liquid_z;
    private int radius_container_x;
    private int radius_container_y;
    private int radius_container_z;
    private int radius_spawner_x;
    private int radius_spawner_y;
    private int radius_spawner_z;
    private int radius_hostiles_x;
    private int radius_hostiles_y;
    private int radius_hostiles_z;
    private int radius_plants_x;
    private int radius_plants_y;
    private int radius_plants_z;
    private final IntArraySet ores = new IntArraySet();
    private Map<SearchType, AxisAlignedBB> typeToBox = new HashMap<SearchType, AxisAlignedBB>();

    private SpellExtension(ResourceLocation name) {
        super(name, TextFormatting.WHITE, 0.8039216f, 0.9019608f, 0.27058825f, 0.72156864f, 0.44705883f, 0.69411767f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_ANIMAL_DURATION, PROP_ENEMY_DURATION, PROP_NIGHT_VISION, PROP_RADIUS_ORE_X, PROP_RADIUS_ORE_Y, PROP_RADIUS_ORE_Z, PROP_RADIUS_ORE_SPECIFIC_X, PROP_RADIUS_ORE_SPECIFIC_Y, PROP_RADIUS_ORE_SPECIFIC_Z, PROP_RADIUS_LIQUID_X, PROP_RADIUS_LIQUID_Y, PROP_RADIUS_LIQUID_Z, PROP_RADIUS_CONTAINER_X, PROP_RADIUS_CONTAINER_Y, PROP_RADIUS_CONTAINER_Z, PROP_RADIUS_SPAWNER_X, PROP_RADIUS_SPAWNER_Y, PROP_RADIUS_SPAWNER_Z, PROP_RADIUS_ANIMALS_X, PROP_RADIUS_ANIMALS_Y, PROP_RADIUS_ANIMALS_Z, PROP_RADIUS_HOSTILES_X, PROP_RADIUS_HOSTILES_Y, PROP_RADIUS_HOSTILES_Z, PROP_RADIUS_PLANTS_X, PROP_RADIUS_PLANTS_Z, PROP_RADIUS_PLANTS_Y);
        this.acceptModifiers(SENSE_HOME, SENSE_ANIMALS, NONDETECTION, SENSE_TIME, SENSE_DANGER, SENSE_PLANTS, SENSE_CONTAINERS, SENSE_SPAWNERS, SENSE_ORES, SENSE_LIQUIDS);
    }

    @Override
    public void init() {
        this.addIngredients(new OreIngredient("chestWood"), new ItemStack(Items.field_151050_s), new OreIngredient("eye"), new ItemStack(Items.field_151111_aL), new ItemStack(Items.field_151150_bK));
        this.setCastSound(ModSounds.Spells.EXTENSION);
    }

    @Nullable
    private IntArraySet getHeldIds(ItemStack stack) {
        int[] ids;
        if (stack.func_190926_b()) {
            return null;
        }
        IntArraySet heldIds = new IntArraySet();
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            if (this.ores.contains(id)) {
                heldIds.add(id);
                continue;
            }
            if (!OreDictionary.getOreName((int)id).startsWith("ore")) continue;
            this.ores.add(id);
            heldIds.add(id);
        }
        return heldIds;
    }

    private boolean oresMatch(ItemStack block, IntArraySet heldIds) {
        if (block.func_190926_b()) {
            return false;
        }
        IntArraySet setBlock = new IntArraySet(OreDictionary.getOreIDs((ItemStack)block));
        setBlock.retainAll((IntCollection)heldIds);
        return !setBlock.isEmpty();
    }

    @Override
    public boolean cast(EntityPlayer caster, StaffModifierInstanceList info, int ticks) {
        boolean specific;
        caster.func_70690_d(new PotionEffect(MobEffects.field_76439_r, this.night_vision, 0, false, false));
        if (info.has(NONDETECTION)) {
            caster.func_70690_d(new PotionEffect(ModPotions.nondetection, this.night_vision, 0, false, false));
        }
        if (info.has(SENSE_ANIMALS)) {
            caster.func_70690_d(new PotionEffect(ModPotions.animal_sense, this.animal_duration, 0, false, false));
            caster.getEntityData().func_74783_a(this.getCachedName(), info.toArray());
        }
        if (info.has(SENSE_DANGER)) {
            caster.func_70690_d(new PotionEffect(ModPotions.danger_sense, this.enemy_duration, 0, false, false));
            caster.getEntityData().func_74783_a(this.getCachedName(), info.toArray());
        }
        if (info.has(SENSE_HOME) && !caster.field_70170_p.field_72995_K) {
            if (caster.field_70170_p.field_73011_w.func_76567_e()) {
                BlockPos home = caster.func_180470_cg();
                if (home == null) {
                    home = caster.field_70170_p.field_73011_w.getSpawnPoint();
                }
                MessageSenseHomeFX packet = new MessageSenseHomeFX(home);
                PacketHandler.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)caster);
            } else {
                caster.func_145747_a(new TextComponentTranslation("roots.message.respawn.cant_respawn_dimension", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        }
        if (info.has(SENSE_TIME) && !caster.field_70170_p.field_72995_K) {
            long total = 6000L + caster.field_70170_p.func_72820_D();
            int day = (int)(total / 24000L) + 1;
            int hours = (int)(total % 24000L / 1000L);
            int minutes = (int)((double)(total % 24000L % 1000L) / 1000.0 * 60.0);
            int moon = (int)(caster.field_70170_p.func_72820_D() / 24000L % 8L + 8L) % 8;
            ITextComponent moonComp = new TextComponentTranslation("roots.message.sense_time.moon." + moon, new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD));
            caster.func_145747_a(new TextComponentTranslation("roots.message.sense_time", new Object[]{new TextComponentTranslation("roots.message.sense_time.format", new Object[]{String.format("%02d", hours), String.format("%02d", minutes)}).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)), day, hours < 18 && hours > 6 ? new TextComponentTranslation("roots.message.sense_time.moon.will", new Object[]{moonComp}) : new TextComponentTranslation("roots.message.sense_time.moon.is", new Object[]{moonComp})}).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        }
        boolean c = info.has(SENSE_CONTAINERS);
        boolean s = info.has(SENSE_SPAWNERS);
        boolean l = info.has(SENSE_LIQUIDS);
        boolean p = info.has(SENSE_PLANTS);
        boolean o = info.has(SENSE_ORES);
        IntArraySet held = this.getHeldIds(caster.func_184592_cb());
        boolean bl = specific = o && held != null && !held.isEmpty();
        if ((c || s || l || o || p) && !caster.field_70170_p.field_72995_K) {
            HashMap<SenseType, List<BlockPos>> positions = new HashMap<SenseType, List<BlockPos>>();
            BlockPos playerPos = caster.func_180425_c();
            AxisAlignedBB ores = this.ore.func_186670_a(playerPos);
            AxisAlignedBB ores_specific = this.ore_specific.func_186670_a(playerPos);
            AxisAlignedBB liquids = this.liquid.func_186670_a(playerPos);
            AxisAlignedBB containers = this.container.func_186670_a(playerPos);
            AxisAlignedBB spawners = this.spawner.func_186670_a(playerPos);
            AxisAlignedBB plant = this.plants.func_186670_a(playerPos);
            AxisAlignedBB offset = this.getBiggestBoundingBox(o, specific, l, c, s, p);
            if (offset == null) {
                return true;
            }
            AxisAlignedBB box = offset.func_186670_a(playerPos);
            int count = 3;
            for (BlockPos pos : AABBUtil.unique((AxisAlignedBB)box)) {
                ItemStack stack;
                if (!caster.field_70170_p.func_175648_a(pos, 1, false) || caster.field_70170_p.func_175623_d(pos)) continue;
                Vec3d vec = new Vec3d((Vec3i)pos);
                IBlockState state = caster.field_70170_p.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (c && containers.func_72318_a(vec) && block instanceof BlockContainer && block.getClass() != BlockMobSpawner.class) {
                    positions.computeIfAbsent(SenseType.CONTAINER, q -> new ArrayList()).add(pos);
                }
                if (s && spawners.func_72318_a(vec) && block instanceof BlockMobSpawner) {
                    positions.computeIfAbsent(SenseType.SPAWNER, q -> new ArrayList()).add(pos);
                }
                if (l && liquids.func_72318_a(vec) && (block instanceof BlockLiquid || block instanceof IFluidHandler)) {
                    List liquidPositions = positions.computeIfAbsent(SenseType.LIQUID, q -> new ArrayList());
                    boolean skip = false;
                    int t2 = MathHelper.func_76125_a((int)(count * count), (int)1, (int)10);
                    for (BlockPos q2 : liquidPositions) {
                        double dist = q2.func_177951_i((Vec3i)pos);
                        if (!(dist < (double)t2)) continue;
                        skip = true;
                        break;
                    }
                    if (!skip) {
                        count = 3;
                        liquidPositions.add(pos);
                    } else {
                        ++count;
                    }
                }
                if (p && plant.func_72318_a(vec) && block instanceof IGrowable) {
                    positions.computeIfAbsent(SenseType.PLANTS, q -> new ArrayList()).add(pos);
                }
                if ((!o || !ores.func_72318_a(vec)) && (!specific || !ores_specific.func_72318_a(vec)) || !OreDictCache.matchesPrefix("ore", stack = ItemUtil.stackFromState((IBlockState)state))) continue;
                if (specific) {
                    if (!this.oresMatch(stack, held)) continue;
                    positions.computeIfAbsent(SenseType.ORE, q -> new ArrayList()).add(pos);
                    continue;
                }
                positions.computeIfAbsent(SenseType.ORE, q -> new ArrayList()).add(pos);
            }
            if (positions.values().stream().anyMatch(t -> !t.isEmpty())) {
                MessageSenseFX message = new MessageSenseFX(positions);
                PacketHandler.INSTANCE.sendTo((IMessage)message, (EntityPlayerMP)caster);
            }
        }
        return true;
    }

    public int[] getRadiusHostiles() {
        return new int[]{this.radius_hostiles_x, this.radius_hostiles_y, this.radius_hostiles_z};
    }

    public int[] getRadiusAnimals() {
        return new int[]{this.radius_animals_x, this.radius_animals_y, this.radius_animals_z};
    }

    public int[] getRadiusPlants() {
        return new int[]{this.radius_plants_x, this.radius_plants_y, this.radius_plants_z};
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.radius_hostiles_x = this.properties.get(PROP_RADIUS_HOSTILES_X);
        this.radius_hostiles_y = this.properties.get(PROP_RADIUS_HOSTILES_Y);
        this.radius_hostiles_z = this.properties.get(PROP_RADIUS_HOSTILES_Z);
        this.radius_animals_x = this.properties.get(PROP_RADIUS_ANIMALS_X);
        this.radius_animals_y = this.properties.get(PROP_RADIUS_ANIMALS_Y);
        this.radius_animals_z = this.properties.get(PROP_RADIUS_ANIMALS_Z);
        this.animal_duration = this.properties.get(PROP_ANIMAL_DURATION);
        this.enemy_duration = this.properties.get(PROP_ENEMY_DURATION);
        this.night_vision = this.properties.get(PROP_NIGHT_VISION);
        this.radius_ore_x = this.properties.get(PROP_RADIUS_ORE_X);
        this.radius_ore_y = this.properties.get(PROP_RADIUS_ORE_Y);
        this.radius_ore_z = this.properties.get(PROP_RADIUS_ORE_Z);
        this.radius_ore_specific_x = this.properties.get(PROP_RADIUS_ORE_SPECIFIC_X);
        this.radius_ore_specific_y = this.properties.get(PROP_RADIUS_ORE_SPECIFIC_Y);
        this.radius_ore_specific_z = this.properties.get(PROP_RADIUS_ORE_SPECIFIC_Z);
        this.radius_liquid_x = this.properties.get(PROP_RADIUS_LIQUID_X);
        this.radius_liquid_y = this.properties.get(PROP_RADIUS_LIQUID_Y);
        this.radius_liquid_z = this.properties.get(PROP_RADIUS_LIQUID_Z);
        this.radius_container_x = this.properties.get(PROP_RADIUS_CONTAINER_X);
        this.radius_container_y = this.properties.get(PROP_RADIUS_CONTAINER_Y);
        this.radius_container_z = this.properties.get(PROP_RADIUS_CONTAINER_Z);
        this.radius_spawner_x = this.properties.get(PROP_RADIUS_SPAWNER_X);
        this.radius_spawner_y = this.properties.get(PROP_RADIUS_SPAWNER_Y);
        this.radius_spawner_z = this.properties.get(PROP_RADIUS_SPAWNER_Z);
        this.radius_plants_x = this.properties.get(PROP_RADIUS_PLANTS_X);
        this.radius_plants_y = this.properties.get(PROP_RADIUS_PLANTS_Y);
        this.radius_plants_z = this.properties.get(PROP_RADIUS_PLANTS_Z);
        this.ore = new AxisAlignedBB((double)(-this.radius_ore_x), (double)(-this.radius_ore_y), (double)(-this.radius_ore_z), (double)(this.radius_ore_x + 1), (double)(this.radius_ore_y + 1), (double)(this.radius_ore_z + 1));
        this.ore_specific = new AxisAlignedBB((double)(-this.radius_ore_specific_x), (double)(-this.radius_ore_specific_y), (double)(-this.radius_ore_specific_z), (double)(this.radius_ore_specific_x + 1), (double)(this.radius_ore_specific_y + 1), (double)(this.radius_ore_specific_z + 1));
        this.liquid = new AxisAlignedBB((double)(-this.radius_liquid_x), (double)(-this.radius_liquid_y), (double)(-this.radius_liquid_z), (double)(this.radius_liquid_x + 1), (double)(this.radius_liquid_y + 1), (double)(this.radius_liquid_z + 1));
        this.container = new AxisAlignedBB((double)(-this.radius_ore_x), (double)(-this.radius_ore_y), (double)(-this.radius_ore_z), (double)(this.radius_ore_x + 1), (double)(this.radius_ore_y + 1), (double)(this.radius_ore_z + 1));
        this.spawner = new AxisAlignedBB((double)(-this.radius_spawner_x), (double)(-this.radius_spawner_y), (double)(-this.radius_spawner_z), (double)(this.radius_spawner_x + 1), (double)(this.radius_spawner_y + 1), (double)(this.radius_spawner_z + 1));
        this.plants = new AxisAlignedBB((double)(-this.radius_plants_x), (double)(-this.radius_plants_y), (double)(-this.radius_plants_z), (double)(this.radius_plants_x + 1), (double)(this.radius_plants_y + 1), (double)(this.radius_plants_z + 1));
        this.typeToBox.put(SearchType.ORE, this.ore);
        this.typeToBox.put(SearchType.ORE_SPECIFIC, this.ore_specific);
        this.typeToBox.put(SearchType.CONTAINER, this.container);
        this.typeToBox.put(SearchType.LIQUID, this.liquid);
        this.typeToBox.put(SearchType.SPAWNER, this.spawner);
        this.typeToBox.put(SearchType.PLANTS, this.plants);
    }

    @Nullable
    public AxisAlignedBB getBiggestBoundingBox(boolean ore, boolean ore_specific, boolean liquid, boolean container, boolean spawner, boolean plants) {
        ArrayList<BoxSize> boxes = new ArrayList<BoxSize>();
        if (ore) {
            boxes.add(new BoxSize(SearchType.ORE, this.radius_ore_x * this.radius_ore_y * this.radius_ore_z));
        }
        if (ore_specific) {
            boxes.add(new BoxSize(SearchType.ORE_SPECIFIC, this.radius_ore_specific_x * this.radius_ore_specific_y * this.radius_ore_specific_z));
        }
        if (liquid) {
            boxes.add(new BoxSize(SearchType.LIQUID, this.radius_liquid_x * this.radius_liquid_y * this.radius_liquid_z));
        }
        if (container) {
            boxes.add(new BoxSize(SearchType.CONTAINER, this.radius_container_x * this.radius_container_y * this.radius_container_z));
        }
        if (spawner) {
            boxes.add(new BoxSize(SearchType.SPAWNER, this.radius_spawner_x * this.radius_spawner_y * this.radius_spawner_z));
        }
        if (plants) {
            boxes.add(new BoxSize(SearchType.PLANTS, this.radius_plants_x * this.radius_plants_y * this.radius_plants_z));
        }
        if (boxes.isEmpty()) {
            return null;
        }
        boxes.sort((o1, o2) -> Integer.compare(((BoxSize)o2).size, ((BoxSize)o1).size));
        return this.typeToBox.get((Object)((BoxSize)boxes.get(0)).type);
    }

    private class BoxSize {
        private SearchType type;
        private int size;

        private BoxSize(SearchType type, int size) {
            this.type = type;
            this.size = size;
        }
    }

    private static enum SearchType {
        ORE,
        ORE_SPECIFIC,
        LIQUID,
        CONTAINER,
        SPAWNER,
        PLANTS;

    }

    public static enum SenseType {
        CONTAINER(new float[]{0.8784314f, 0.827451f, 0.11372549f, 0.5f}),
        SPAWNER(new float[]{0.18039216f, 0.52156866f, 0.81960785f, 0.5f}),
        LIQUID(new float[]{0.8117647f, 0.25882354f, 0.07450981f, 0.5f}),
        ORE(new float[]{0.5411765f, 0.44705883f, 0.3529412f, 0.5f}),
        PLANTS(new float[]{0.011764706f, 0.9882353f, 0.043137256f, 0.5f});

        private final float[] color;

        private SenseType(float[] color) {
            this.color = color;
        }

        public float[] getColor() {
            return this.color;
        }

        @Nullable
        public static SenseType fromOrdinal(int ordinal) {
            for (SenseType type : SenseType.values()) {
                if (type.ordinal() != ordinal) continue;
                return type;
            }
            return null;
        }
    }
}

