/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.AABBUtil;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModPotions;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessageDandelionCastFX;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.EntityUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreIngredient;

public class SpellDandelionWinds
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(20);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.INSTANTANEOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("cloud_berry", 0.125));
    public static Property<Float> PROP_DISTANCE = new Property<Float>("distance", Float.valueOf(0.75f)).setDescription("the vertical component of the vector that determines the direction of the entity");
    public static Property<Double> PROP_RANGE_1 = new Property<Double>("range_1", 4.0).setDescription("the first range increment for calculating the bounding box");
    public static Property<Double> PROP_RANGE_2 = new Property<Double>("range_2", 5.0).setDescription("the second range increment for calculating the bounding box");
    public static Property<Float> PROP_ADDITIONAL_DISTANCE = new Property<Float>("additional_distance", Float.valueOf(0.25f)).setDescription("the additional vertical component of the vector that determines the direction of the entity");
    public static Property<Float> PROP_ADDITIONAL_FALL = new Property<Float>("additional_fall", Float.valueOf(1.75f)).setDescription("the fall distance modifier");
    public static Property<Integer> PROP_SLOW_DURATION = new Property<Integer>("slow_duration", 60).setDescription("the duration of the slow fall effect");
    public static Property<Integer> PROP_POISON_DURATION = new Property<Integer>("poison_duration", 100).setDescription("the duration of the poison effect to apply");
    public static Property<Integer> PROP_POISON_AMPLIFIER = new Property<Integer>("poison_amplifier", 0).setDescription("the amplifier to apply to the poison effect");
    public static Property<Integer> PROP_FIRE_DURATION = new Property<Integer>("fire_duration", 4).setDescription("the duration (in seconds) that entities should be set on fire for");
    public static Modifier STRONGER = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "strong_gusts"), ModifierCores.PERESKIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.45)));
    public static Modifier PEACEFUL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "peaceful_winds"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.125)));
    public static Modifier GROUNDED = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "grounded_wind"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.345)));
    public static Modifier SLOW_FALL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "slow_falling"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.125)));
    public static Modifier CIRCLE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "circle_of_winds"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.475)));
    public static Modifier ITEMS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "item_updraft"), ModifierCores.TERRA_MOSS, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.TERRA_MOSS, 0.125)));
    public static Modifier POISON = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "poisonous_breeze"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.375)));
    public static Modifier FIRE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "flaming_wind"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.275)));
    public static Modifier SUCTION = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "suction"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.375)));
    public static Modifier EXTINGUISH = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "extinguisher"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.275)));
    public static ResourceLocation spellName;
    public static SpellDandelionWinds instance;
    private int slow_duration;
    private int poison_amplifier;
    private int poison_duration;
    private int fire_duration;
    private double r1;
    private double r2;
    private float distance;
    private float additional_distance;
    private float additional_fall;

    public SpellDandelionWinds(ResourceLocation name) {
        super(name, TextFormatting.YELLOW, 1.0f, 1.0f, 0.1254902f, 1.0f, 0.6901961f, 0.1254902f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_DISTANCE, PROP_RANGE_1, PROP_RANGE_2, PROP_ADDITIONAL_DISTANCE, PROP_ADDITIONAL_FALL, PROP_SLOW_DURATION, PROP_POISON_AMPLIFIER, PROP_POISON_DURATION, PROP_FIRE_DURATION);
        this.acceptModifiers(STRONGER, PEACEFUL, GROUNDED, SLOW_FALL, CIRCLE, ITEMS, POISON, FIRE, SUCTION, EXTINGUISH);
    }

    @Override
    public void init() {
        this.addIngredients(new ItemStack((Block)Blocks.field_150327_N), new OreIngredient("treeLeaves"), new ItemStack(ModItems.runic_dust), new ItemStack(ModItems.cloud_berry), new ItemStack(ModItems.terra_spores));
        this.setCastSound(ModSounds.Spells.DANDELION_WINDS);
    }

    @Override
    public boolean cast(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        Vec3d lookVec = player.func_70040_Z();
        float d = info.has(STRONGER) ? this.distance + this.additional_distance : this.distance;
        float motion = d * d + d;
        Vec3d playVec = player.func_174791_d();
        int count = 0;
        int extinguish = 0;
        if (!info.has(CIRCLE)) {
            AxisAlignedBB bounding = new AxisAlignedBB(player.field_70165_t + lookVec.field_72450_a * this.r1 - this.r1, player.field_70163_u + lookVec.field_72448_b * this.r1 - this.r1, player.field_70161_v + lookVec.field_72449_c * this.r1 - this.r2, player.field_70165_t + lookVec.field_72450_a * this.r1 + this.r1, player.field_70163_u + lookVec.field_72448_b * this.r1 + this.r1, player.field_70161_v + lookVec.field_72449_c * this.r1 + this.r1);
            List entities = player.field_70170_p.func_72872_a(EntityLivingBase.class, bounding);
            count = entities.size() - 1;
            if (!player.field_70170_p.field_72995_K) {
                entities.forEach(o -> {
                    if (o != player) {
                        BlockPos pos = o.func_180425_c();
                        Vec3d vec = lookVec;
                        if (info.has(SUCTION)) {
                            vec = playVec.func_178788_d(o.func_174791_d()).func_72432_b();
                        }
                        this.flingLivingEntity((EntityLivingBase)o, vec, motion, info);
                        if (info.has(FIRE)) {
                            this.trySetFire(player.field_70170_p, pos);
                        }
                    }
                });
            }
            if (info.has(ITEMS)) {
                List items = player.field_70170_p.func_72872_a(EntityItem.class, bounding);
                count += items.size();
                if (!player.field_70170_p.field_72995_K) {
                    items.forEach(o -> {
                        BlockPos pos = o.func_180425_c();
                        Vec3d vec = lookVec;
                        if (info.has(SUCTION)) {
                            vec = playVec.func_178788_d(o.func_174791_d()).func_72432_b();
                        }
                        this.flingEntity((Entity)o, vec, motion, info);
                        if (info.has(FIRE)) {
                            this.trySetFire(player.field_70170_p, pos);
                        }
                    });
                }
            }
            if (info.has(EXTINGUISH)) {
                for (BlockPos pos : AABBUtil.unique((AxisAlignedBB)bounding)) {
                    IBlockState state = player.field_70170_p.func_180495_p(pos);
                    if (state.func_177230_c() != Blocks.field_150480_ab) continue;
                    ++extinguish;
                    if (player.field_70170_p.field_72995_K) continue;
                    player.field_70170_p.func_175698_g(pos);
                }
            }
        } else {
            double val = (this.r1 + this.r2) / 2.0;
            AxisAlignedBB bounding = new AxisAlignedBB(val, val, val, -val - 0.5, -val - 0.5, -val - 0.5).func_186670_a(player.func_180425_c());
            List entities = player.field_70170_p.func_72872_a(EntityLivingBase.class, bounding);
            if (!player.field_70170_p.field_72995_K) {
                entities.forEach(o -> {
                    if (o != player) {
                        BlockPos pos = o.func_180425_c();
                        Vec3d vec = info.has(SUCTION) ? playVec.func_178788_d(o.func_174791_d()).func_72432_b() : o.func_174791_d().func_178788_d(playVec).func_72432_b();
                        this.flingLivingEntity((EntityLivingBase)o, vec, motion, info);
                        if (info.has(FIRE)) {
                            this.trySetFire(player.field_70170_p, pos);
                        }
                    }
                });
                if (info.has(ITEMS)) {
                    List items = player.field_70170_p.func_72872_a(EntityItem.class, bounding);
                    count += items.size();
                    if (!player.field_70170_p.field_72995_K) {
                        items.forEach(o -> {
                            BlockPos pos = o.func_180425_c();
                            Vec3d vec = info.has(SUCTION) ? playVec.func_178788_d(o.func_174791_d()).func_72432_b() : o.func_174791_d().func_178788_d(playVec).func_72432_b();
                            this.flingEntity((Entity)o, vec, motion, info);
                            if (info.has(FIRE)) {
                                this.trySetFire(player.field_70170_p, pos);
                            }
                        });
                    }
                }
            }
            if (info.has(EXTINGUISH)) {
                for (BlockPos pos : AABBUtil.unique((AxisAlignedBB)bounding)) {
                    IBlockState state = player.field_70170_p.func_180495_p(pos);
                    if (state.func_177230_c() != Blocks.field_150480_ab) continue;
                    ++extinguish;
                    if (player.field_70170_p.field_72995_K) continue;
                    player.field_70170_p.func_175698_g(pos);
                }
            }
        }
        if (count > 0 || extinguish > 0) {
            if (!player.field_70170_p.field_72995_K) {
                PacketHandler.sendToAllTracking((IMessage)new MessageDandelionCastFX(player.func_110124_au(), player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v), (Entity)player);
            }
            return true;
        }
        return false;
    }

    private void trySetFire(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        if (world.func_175623_d(pos) && Blocks.field_150480_ab.func_176196_c(world, pos)) {
            world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        }
    }

    private void flingEntity(Entity e, Vec3d lookVec, double motion, StaffModifierInstanceList info) {
        e.field_70159_w += lookVec.field_72450_a;
        e.field_70181_x += motion * 0.7;
        e.field_70179_y += lookVec.field_72449_c;
        if (info.has(GROUNDED)) {
            e.field_70143_R *= this.additional_fall;
        }
        e.field_70133_I = true;
    }

    private void flingLivingEntity(EntityLivingBase e, Vec3d lookVec, double motion, StaffModifierInstanceList info) {
        if (info.has(PEACEFUL) && EntityUtil.isFriendly((Entity)e, instance)) {
            return;
        }
        this.flingEntity((Entity)e, lookVec, motion, info);
        if (info.has(SLOW_FALL)) {
            e.func_70690_d(new PotionEffect((Potion)ModPotions.slow_fall, this.slow_duration, 0, false, false));
        }
        if (info.has(POISON)) {
            e.func_70690_d(new PotionEffect(MobEffects.field_76436_u, this.poison_duration, this.poison_amplifier));
        }
        if (info.has(FIRE)) {
            e.func_70015_d(this.fire_duration);
        }
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.distance = this.properties.get(PROP_DISTANCE).floatValue();
        this.additional_distance = this.properties.get(PROP_ADDITIONAL_DISTANCE).floatValue();
        this.additional_fall = this.properties.get(PROP_ADDITIONAL_FALL).floatValue();
        this.slow_duration = this.properties.get(PROP_SLOW_DURATION);
        this.poison_amplifier = this.properties.get(PROP_POISON_AMPLIFIER);
        this.poison_duration = this.properties.get(PROP_POISON_DURATION);
        this.fire_duration = this.properties.get(PROP_FIRE_DURATION);
        this.r1 = this.properties.get(PROP_RANGE_1);
        this.r2 = this.properties.get(PROP_RANGE_2);
    }

    static {
        GROUNDED.addConflict(SLOW_FALL);
        CIRCLE.addConflict(EXTINGUISH);
        EXTINGUISH.addConflict(FIRE);
        spellName = new ResourceLocation("roots", "spell_dandelion_winds");
        instance = new SpellDandelionWinds(spellName);
    }
}

