/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import com.google.common.collect.ImmutableList;
import epicsquid.mysticallib.util.ListUtil;
import epicsquid.roots.Roots;
import epicsquid.roots.api.Herb;
import epicsquid.roots.config.SpellConfig;
import epicsquid.roots.entity.EntityLifetimeBase;
import epicsquid.roots.entity.spell.EntitySpellBase;
import epicsquid.roots.init.HerbRegistry;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.IModifierCost;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.instance.base.BaseModifierInstance;
import epicsquid.roots.modifiers.instance.base.BaseModifierInstanceList;
import epicsquid.roots.modifiers.instance.library.LibraryModifierInstance;
import epicsquid.roots.modifiers.instance.library.LibraryModifierInstanceList;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstance;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.properties.Property;
import epicsquid.roots.properties.PropertyTable;
import epicsquid.roots.recipe.IRootsRecipe;
import epicsquid.roots.spell.info.StaffSpellInfo;
import epicsquid.roots.spell.info.storage.DustSpellStorage;
import epicsquid.roots.spell.info.storage.StaffSpellStorage;
import epicsquid.roots.tileentity.TileEntityMortar;
import epicsquid.roots.util.ClientHerbUtil;
import epicsquid.roots.util.ServerHerbUtil;
import epicsquid.roots.util.types.RegistryItem;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SpellBase
extends RegistryItem {
    protected PropertyTable properties = new PropertyTable();
    private boolean finalised = false;
    private float red1;
    private float green1;
    private float blue1;
    private float red2;
    private float green2;
    private float blue2;
    private String name;
    protected int cooldown = 20;
    protected boolean disabled = false;
    protected SpellConfig.SpellSoundsCategory.SpellSound sound = null;
    private TextFormatting textColor;
    protected EnumCastType castType = EnumCastType.INSTANTANEOUS;
    private Object2DoubleOpenHashMap<Herb> costs = new Object2DoubleOpenHashMap();
    private Set<Modifier> acceptedModifiers = new HashSet<Modifier>();
    public SpellRecipe recipe = SpellRecipe.EMPTY;
    protected SoundEvent cast_sound;
    private ItemStack result = null;
    private ItemStack icon = null;
    private ItemStack staff = null;
    private List<ItemStack> costItemCache = null;

    public SpellBase(ResourceLocation name, TextFormatting textColor, float r1, float g1, float b1, float r2, float g2, float b2) {
        this.setRegistryName(name);
        this.name = name.func_110623_a();
        this.red1 = r1;
        this.green1 = g1;
        this.blue1 = b1;
        this.red2 = r2;
        this.green2 = g2;
        this.blue2 = b2;
        this.textColor = textColor;
    }

    public float[] getFirstColours() {
        return this.getFirstColours(1.0f);
    }

    public float[] getFirstColours(float alpha) {
        return new float[]{this.red1, this.green1, this.blue1, alpha};
    }

    public float[] modifyFirstColours(float value) {
        return this.modifyFirstColours(value, 1.0f);
    }

    public float[] modifyFirstColours(float value, float alpha) {
        return new float[]{this.red1 * value, this.green1 * value, this.blue1 * value, alpha};
    }

    public float[] modifySecondColours(float value) {
        return this.modifySecondColours(value, 1.0f);
    }

    public float[] modifySecondColours(float value, float alpha) {
        return new float[]{this.red2 * value, this.green2 * value, this.blue2 * value, alpha};
    }

    public float[] getSecondColours(float alpha) {
        return new float[]{this.red2, this.green2, this.blue2, alpha};
    }

    public abstract void init();

    public SpellConfig.SpellSoundsCategory.SpellSound getSound() {
        return this.sound;
    }

    public void setSound(SpellConfig.SpellSoundsCategory.SpellSound sound) {
        this.sound = sound;
    }

    public boolean shouldPlaySound() {
        if (this.sound == null) {
            return true;
        }
        return this.sound.enabled;
    }

    public float getSoundVolume() {
        if (this.sound == null) {
            return 1.0f;
        }
        return (float)this.sound.volume;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public PropertyTable getProperties() {
        return this.properties;
    }

    public SpellBase acceptModifiers(Modifier ... modules) {
        this.acceptedModifiers.addAll(Arrays.asList(modules));
        for (Modifier mod : modules) {
            for (Property<ModifierCost> prop : mod.asProperties()) {
                this.properties.add(prop);
            }
        }
        return this;
    }

    public Set<Modifier> getModifiers() {
        return this.acceptedModifiers;
    }

    public boolean acceptsModifiers(Modifier ... modules) {
        for (Modifier mod : modules) {
            if (this.acceptedModifiers.contains(mod)) continue;
            return false;
        }
        return true;
    }

    public void setCastSound(@Nullable SoundEvent event) {
        this.cast_sound = event;
    }

    @Nullable
    public SoundEvent getCastSound() {
        return this.cast_sound;
    }

    public void setRecipe(SpellRecipe recipe) {
        this.recipe = recipe;
    }

    public SpellBase addIngredients(Object ... stacks) {
        this.recipe = new SpellRecipe(stacks);
        return this;
    }

    public boolean costsMet(EntityPlayer player, StaffModifierInstanceList modifiers) {
        boolean matches = true;
        for (Map.Entry entry : modifiers.apply(this.costs).entrySet()) {
            double r;
            Herb herb = (Herb)entry.getKey();
            double d = (Double)entry.getValue();
            if (!matches || (matches = (r = !player.field_70170_p.field_72995_K ? ServerHerbUtil.getHerbAmount(player, herb) : ClientHerbUtil.getHerbAmount(herb)) >= d) || player.func_184812_l_()) continue;
            if (r == -1.0) {
                if (player.field_70170_p.field_72995_K) continue;
                player.func_146105_b(new TextComponentTranslation("roots.info.pouch.no_pouch", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                continue;
            }
            if (player.field_70170_p.field_72995_K) continue;
            player.func_146105_b((ITextComponent)new TextComponentTranslation("roots.info.pouch.no_herbs", new Object[]{new TextComponentTranslation(String.format("item.%s.name", herb.getName()), new Object[0])}), true);
        }
        return matches && this.costs.size() > 0 || player.field_71075_bZ.field_75098_d;
    }

    public void enactCosts(EntityPlayer player, StaffModifierInstanceList modifiers) {
        for (Map.Entry entry : modifiers.apply(this.costs).entrySet()) {
            Herb herb = (Herb)entry.getKey();
            double d = (Double)entry.getValue();
            ServerHerbUtil.removePowder(player, herb, d);
        }
    }

    public void enactTickCosts(EntityPlayer player, StaffModifierInstanceList modifiers) {
        for (Map.Entry entry : modifiers.apply(this.costs).entrySet()) {
            Herb herb = (Herb)entry.getKey();
            double d = (Double)entry.getValue();
            ServerHerbUtil.removePowder(player, herb, d / 20.0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addToolTipBase(List<String> tooltip, @Nullable BaseModifierInstanceList<?> list) {
        Object2DoubleOpenHashMap<Herb> costs = this.costs;
        if (list != null) {
            costs = list.apply(costs);
        }
        String prefix = this.getTranslationKey();
        tooltip.add("" + this.textColor + TextFormatting.BOLD + I18n.func_135052_a((String)(prefix + ".name"), (Object[])new Object[0]) + TextFormatting.RESET);
        if (this.finalised()) {
            for (Map.Entry entry : costs.entrySet()) {
                Herb herb = (Herb)entry.getKey();
                String d = String.format("%.4f", entry.getValue());
                tooltip.add(I18n.func_135052_a((String)(herb.getItem().func_77658_a() + ".name"), (Object[])new Object[0]) + I18n.func_135052_a((String)"roots.tooltip.pouch_divider", (Object[])new Object[0]) + d);
            }
        }
    }

    public String getTranslationKey() {
        return "roots.spell." + this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public void addToolTip(List<String> tooltip, @Nullable LibraryModifierInstanceList list) {
        this.addToolTipBase(tooltip, list);
        if (list != null) {
            if (!list.isEmpty()) {
                tooltip.add("");
            }
            for (LibraryModifierInstance modifier : list) {
                if (!modifier.isApplied()) continue;
                tooltip.add(modifier.describeName());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addToolTip(List<String> tooltip, @Nullable StaffModifierInstanceList list) {
        this.addToolTipBase(tooltip, list);
        this.addToolTipInfo(tooltip, list);
    }

    @SideOnly(value=Side.CLIENT)
    public void addToolTipInfo(List<String> tooltip, @Nullable StaffModifierInstanceList list) {
        if (list != null) {
            double addition = 0.0;
            double subtraction = 0.0;
            if (!GuiScreen.func_146272_n()) {
                StringJoiner joiner = new StringJoiner(", ");
                for (Object m : list) {
                    if (((BaseModifierInstance)m).getModifier() == null || !((BaseModifierInstance)m).isApplied() || !((StaffModifierInstance)m).isEnabled()) continue;
                    for (IModifierCost c : ((LibraryModifierInstance)m).getCosts().values()) {
                        if (c.getCost() != CostType.ALL_COST_MULTIPLIER) continue;
                        if (c.getValue() < 0.0) {
                            subtraction += Math.abs(c.getValue());
                            continue;
                        }
                        addition += Math.abs(c.getValue());
                    }
                    joiner.add(((BaseModifierInstance)m).describe());
                }
                String result = joiner.toString();
                if (!result.isEmpty()) {
                    tooltip.add(result);
                }
                if (GuiScreen.func_146272_n() && !result.isEmpty()) {
                    tooltip.add(result);
                }
            } else {
                for (StaffModifierInstance m : list) {
                    if (m.getModifier() == null || !m.isApplied() || !m.isEnabled()) continue;
                    for (IModifierCost c : m.getCosts().values()) {
                        if (c.getCost() != CostType.ALL_COST_MULTIPLIER) continue;
                        if (c.getValue() < 0.0) {
                            subtraction += Math.abs(c.getValue());
                            continue;
                        }
                        addition += Math.abs(c.getValue());
                    }
                    tooltip.add(m.describe());
                }
            }
            double actualSub = subtraction - addition;
            double actualAdd = addition - subtraction;
            if (actualSub > 0.0) {
                tooltip.add(I18n.func_135052_a((String)"roots.tooltip.reduced_by", (Object[])new Object[]{Math.floor(actualSub * 100.0) + "%"}));
            }
            if (actualAdd > 0.0) {
                tooltip.add(I18n.func_135052_a((String)"roots.tooltip.increased_by", (Object[])new Object[]{Math.floor(actualAdd * 100.0) + "%"}));
            }
        }
    }

    private SpellBase addCost(SpellCost cost) {
        return this.addCost(cost.getHerb(), cost.getCost());
    }

    private SpellBase addCost(Herb herb, double amount) {
        if (herb == null) {
            Roots.logger.error("Spell - " + this.getClass().getName() + " - added a null herb ingredient. This is a bug.");
            return this;
        }
        this.costs.put((Object)herb, amount);
        return this;
    }

    public boolean matchesIngredients(List<ItemStack> ingredients) {
        return ListUtil.matchesIngredients(ingredients, this.getIngredients());
    }

    public CastResult cast(EntityPlayer caster, StaffSpellInfo info, int ticks) {
        SoundEvent event;
        StaffModifierInstanceList mods = info.getModifiers();
        CastResult result = CastResult.FAIL;
        if (this.cast(caster, info.getModifiers(), ticks)) {
            result = CastResult.SUCCESS;
        }
        if (result != CastResult.FAIL && !caster.field_70170_p.field_72995_K && (ticks == 0 || ticks == 72000) && (event = this.getCastSound()) != null && this.shouldPlaySound()) {
            caster.field_70170_p.func_184133_a(null, caster.func_180425_c(), event, SoundCategory.PLAYERS, this.getSoundVolume(), 1.0f);
        }
        return result;
    }

    protected abstract boolean cast(EntityPlayer var1, StaffModifierInstanceList var2, int var3);

    public float getRed1() {
        return this.red1;
    }

    public float getGreen1() {
        return this.green1;
    }

    public float getBlue1() {
        return this.blue1;
    }

    public float getRed2() {
        return this.red2;
    }

    public float getGreen2() {
        return this.green2;
    }

    public float getBlue2() {
        return this.blue2;
    }

    public String getName() {
        return this.name;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public TextFormatting getTextColor() {
        return this.textColor;
    }

    public EnumCastType getCastType() {
        return this.castType;
    }

    public Object2DoubleOpenHashMap<Herb> getCosts() {
        return this.costs;
    }

    public List<Ingredient> getIngredients() {
        return this.recipe.getIngredients();
    }

    public ItemStack getResult() {
        if (this.result == null) {
            this.result = new ItemStack(ModItems.spell_dust);
            DustSpellStorage.fromStack(this.result).setSpellToSlot(this);
        }
        return this.result;
    }

    public ItemStack getStaff() {
        if (this.staff == null) {
            this.staff = new ItemStack(ModItems.staff);
            StaffSpellStorage.fromStack(this.staff).setSpellToSlot(1, StaffSpellInfo.fromSpell(this, false));
        }
        return this.staff;
    }

    public ItemStack getIcon() {
        if (this.icon == null) {
            this.icon = new ItemStack(ModItems.spell_icon);
            DustSpellStorage.fromStack(this.icon).setSpellToSlot(this);
        }
        return this.icon;
    }

    public List<ItemStack> getCostItems() {
        if (this.costItemCache == null) {
            ArrayList<ItemStack> costList = new ArrayList<ItemStack>();
            for (Herb cost : this.costs.keySet()) {
                costList.add(new ItemStack(cost.getItem()));
            }
            this.costItemCache = ImmutableList.copyOf(costList);
        }
        return this.costItemCache;
    }

    public abstract void doFinalise();

    public void finaliseCosts() {
        for (Map.Entry<String, Property<?>> entry : this.getProperties()) {
            Property<?> prop;
            SpellCost cost;
            if (!entry.getKey().startsWith("cost_") || (cost = (SpellCost)this.properties.get(prop = entry.getValue())) == null) continue;
            this.addCost(cost);
        }
        for (Modifier mod : this.getModifiers()) {
            ArrayList<ModifierCost> costs = new ArrayList<ModifierCost>();
            for (Property<ModifierCost> prop : mod.asProperties()) {
                costs.add(this.properties.get(prop));
            }
            mod.replaceCosts(costs);
        }
        this.finalised = true;
    }

    public void finalise() {
        this.doFinalise();
        this.finaliseCosts();
        this.validateProperties();
    }

    public void validateProperties() {
        List<String> values = this.properties.finalise();
        if (!values.isEmpty()) {
            StringJoiner join = new StringJoiner(",");
            values.forEach(join::add);
            Roots.logger.error("Spell '" + this.name + "' property table has the following keys inserted but not fetched: |" + join.toString() + "|");
        }
    }

    public boolean finalised() {
        return this.finalised;
    }

    @Nullable
    protected EntitySpellBase spawnEntity(World world, BlockPos pos, Class<? extends EntitySpellBase> entity, @Nullable EntityPlayer player, double amplifier, double speedy) {
        return this.spawnEntity(world, new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), entity, player, amplifier, speedy);
    }

    @Nullable
    protected EntitySpellBase spawnEntity(World world, Vec3d pos, Class<? extends EntitySpellBase> entity, @Nullable EntityPlayer player, double amplifier, double speedy) {
        List pastRituals = world.func_175647_a(entity, new AxisAlignedBB(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c - 100.0, pos.field_72450_a + 2.0, pos.field_72448_b + 100.0, pos.field_72449_c + 1.0), o -> o != null && o.getClass().equals(entity));
        if (pastRituals.isEmpty() && !world.field_72995_K) {
            EntityLifetimeBase spell = null;
            try {
                Constructor<? extends EntitySpellBase> cons = entity.getDeclaredConstructor(World.class);
                spell = cons.newInstance(world);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            if (spell == null) {
                return null;
            }
            spell.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            if (player != null) {
                spell.setPlayer(player.func_110124_au());
            }
            world.func_72838_d((Entity)spell);
            return spell;
        }
        return null;
    }

    public static class SpellRecipe
    implements IRootsRecipe<TileEntityMortar> {
        public static SpellRecipe EMPTY = new SpellRecipe(new Object[0]);
        private List<Ingredient> ingredients = new ArrayList<Ingredient>();

        public SpellRecipe(Object ... stacks) {
            for (Object stack : stacks) {
                if (stack instanceof Ingredient) {
                    this.ingredients.add((Ingredient)stack);
                    continue;
                }
                if (!(stack instanceof ItemStack)) continue;
                this.ingredients.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)stack}));
            }
        }

        @Override
        public List<Ingredient> getIngredients() {
            return this.ingredients;
        }
    }

    public static class SpellCost {
        public static SpellCost EMPTY = new SpellCost(null, 0.0);
        private String herb;
        private double cost;

        public SpellCost(String herb, double cost) {
            this.herb = herb;
            this.cost = cost;
        }

        public Herb getHerb() {
            return HerbRegistry.getHerbByName(this.herb);
        }

        public double getCost() {
            return this.cost;
        }

        public String getHerbName() {
            return this.herb;
        }

        public String toString() {
            return "SpellCost{herb='" + this.herb + '\'' + ", cost=" + this.cost + '}';
        }
    }

    public static class ModifierCost {
        private Herb herb;
        private CostType type;
        private double cost;

        public ModifierCost(IModifierCost cost) {
            this(cost.getHerb(), cost.getCost(), cost.getValue());
        }

        public ModifierCost(Herb herb, CostType type, double cost) {
            this.herb = herb;
            this.type = type;
            this.cost = cost;
        }

        public Herb getHerb() {
            return this.herb;
        }

        public CostType getType() {
            return this.type;
        }

        public double getCost() {
            return this.cost;
        }

        public IModifierCost asCost() {
            return new Cost(this.getType(), this.getCost(), ModifierCores.fromHerb(this.getHerb()));
        }

        public String toString() {
            return "ModifierCost{herb=" + (this.herb == null ? "none" : this.herb.getName()) + ", type=" + (Object)((Object)this.type) + ", cost=" + this.cost + '}';
        }
    }

    public static enum CastResult {
        FAIL,
        SUCCESS,
        SUCCESS_SPEEDY,
        SUCCESS_GREATER_SPEEDY;


        public boolean isSuccess() {
            return this != FAIL;
        }

        public long modifyCooldown(long cooldown) {
            switch (this) {
                default: {
                    return 0L;
                }
                case SUCCESS_SPEEDY: {
                    return Math.round((double)cooldown * 0.1);
                }
                case SUCCESS_GREATER_SPEEDY: 
            }
            return Math.round((double)cooldown * 0.3);
        }
    }

    public static enum EnumCastType {
        INSTANTANEOUS,
        CONTINUOUS;

    }
}

