/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.roots.client.SpectatorHandler;
import epicsquid.roots.config.SpellConfig;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModPotions;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.mechanics.Magnetize;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.MessageLightDrifterSync;
import epicsquid.roots.network.fx.MessageLightDrifterFX;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SpellAugment
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(350);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.INSTANTANEOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("wildroot", 0.7));
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 15).setDescription("radius on the X axis of the area in which dropped items are magnetized to the player");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 15).setDescription("radius on the Y axis of the area in which dropped items are magnetized to the player");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 15).setDescription("radius on the Z axis of the area in which dropped items are magnetized to the player");
    public static Property<Integer> PROP_REACH_DURATION = new Property<Integer>("reach_duration", 600).setDescription("duration for the reach potion effect");
    public static Property<Double> PROP_REACH = new Property<Double>("reach", 5.0).setDescription("the extended reach applied to the player during the effect of the spell");
    public static Property<Integer> PROP_SPEED_DURATION = new Property<Integer>("speed_duration", 300).setDescription("duration for the speed potion effect");
    public static Property<Integer> PROP_SPEED_AMPLIFIER = new Property<Integer>("speed_amplifier", 0).setDescription("amplifier for the speed potion effect");
    public static Property<Integer> PROP_SLOW_FALL_DURATION = new Property<Integer>("slow_fall_duration", 360).setDescription("duration for the slow fall potion effect");
    public static Property<Integer> PROP_DRIFTER_DURATION = new Property<Integer>("drifter_duration", 200).setDescription("the duration in ticks of the spell effect on the player");
    public static Property<Integer> PROP_LUCK_DURATION = new Property<Integer>("luck_duration", 300).setDescription("duration for the luck potion effect");
    public static Property<Integer> PROP_LUCK_AMPLIFIER = new Property<Integer>("luck_amplifier", 0).setDescription("amplifier for the luck potion effect");
    public static Property<Integer> PROP_STRENGTH_DURATION = new Property<Integer>("strength_duration", 300).setDescription("duration for the strength potion effect");
    public static Property<Integer> PROP_STRENGTH_AMPLIFIER = new Property<Integer>("strength_amplifier", 0).setDescription("amplifier for the strength potion effect");
    public static Property<Integer> PROP_HASTE_DURATION = new Property<Integer>("haste_duration", 300).setDescription("duration for the haste potion effect");
    public static Property<Integer> PROP_HASTE_AMPLIFIER = new Property<Integer>("haste_amplifier", 0).setDescription("amplifier for the haste potion effect");
    public static Property<Integer> PROP_ABSORPTION_DURATION = new Property<Integer>("absorption_duration", 300).setDescription("duration for the absorption potion effect");
    public static Property<Integer> PROP_ABSORPTION_AMPLIFIER = new Property<Integer>("absorption_amplifier", 0).setDescription("amplifier for the absorption potion effect");
    public static Property<Integer> PROP_AIR_AMOUNT = new Property<Integer>("air_amount", 300).setDescription("the value to add to a user's air with the second wind effect [30 air = 1 bubble]");
    public static Modifier REACH = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "reach"), ModifierCores.PERESKIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.5)));
    public static Modifier SPEED = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "speed"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.5)));
    public static Modifier SLOW_FALL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "augment_slow_fall"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.275)));
    public static Modifier LIGHT_DRIFTER = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "light_drifter"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.5)));
    public static Modifier MAGNETISM = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "magnetism"), ModifierCores.TERRA_MOSS, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.TERRA_MOSS, 0.125)));
    public static Modifier LUCK = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "bitter_luck"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.125)));
    public static Modifier ABSORPTION = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "absorption"), ModifierCores.CLOUD_BERRY, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.CLOUD_BERRY, 0.75)));
    public static Modifier STRENGTH = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "strength_of_flame"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.85)));
    public static Modifier HASTE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "haste"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.85)));
    public static Modifier SECOND_WIND = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "second_wind"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.125)));
    public static final String LIGHT_DRIFTER_TAG = "roots:light_drifter";
    public static final String LIGHT_DRIFTER_X = "roots:light_drifter_x";
    public static final String LIGHT_DRIFTER_Y = "roots:light_drifter_y";
    public static final String LIGHT_DRIFTER_Z = "roots:light_drifter_z";
    public static final String LIGHT_DRIFTER_DIMENSION_ID = "roots:light_drifter_dim";
    public static final String LIGHT_DRIFTER_MODE = "roots:light_drifter_mode";
    public static ResourceLocation spellName;
    public static SpellAugment instance;
    private int radius_x;
    private int radius_y;
    private int radius_z;
    private int reach_duration;
    private int speed_amplifier;
    private int speed_duration;
    private int slow_fall;
    private int drifter_duration;
    private int luck_amplifier;
    private int luck_duration;
    private int strength_amplifier;
    private int strength_duration;
    private int haste_amplifier;
    private int haste_duration;
    private int air_amount;
    private int absorption_duration;
    private int absorption_amplifier;
    private double reach;

    private SpellAugment(ResourceLocation name) {
        super(name, TextFormatting.AQUA, 0.27058825f, 0.81960785f, 0.49803922f, 0.10980392f, 0.10980392f, 0.5803922f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_REACH, PROP_REACH_DURATION, PROP_SPEED_AMPLIFIER, PROP_SPEED_DURATION, PROP_SLOW_FALL_DURATION, PROP_DRIFTER_DURATION, PROP_LUCK_AMPLIFIER, PROP_LUCK_DURATION, PROP_AIR_AMOUNT, PROP_STRENGTH_AMPLIFIER, PROP_STRENGTH_DURATION, PROP_HASTE_AMPLIFIER, PROP_HASTE_DURATION, PROP_ABSORPTION_AMPLIFIER, PROP_ABSORPTION_DURATION);
        this.acceptModifiers(REACH, SPEED, SLOW_FALL, LIGHT_DRIFTER, MAGNETISM, LUCK, ABSORPTION, STRENGTH, HASTE, SECOND_WIND);
    }

    @Override
    public void init() {
        this.addIngredients(new ItemStack(Blocks.field_150467_bQ), new ItemStack((Item)Items.field_151112_aM), new ItemStack(Items.field_185159_cQ), new ItemStack(ModItems.petals), new ItemStack(Items.field_151122_aG));
        this.setCastSound(ModSounds.Spells.AUGMENT);
    }

    @Override
    public boolean cast(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        int air;
        boolean acted = false;
        if (info.has(REACH)) {
            acted = true;
            player.func_70690_d(new PotionEffect((Potion)ModPotions.reach, this.reach_duration, 0, false, false));
        }
        if (info.has(SPEED)) {
            acted = true;
            player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, this.speed_duration, this.speed_amplifier, false, false));
        }
        if (info.has(SLOW_FALL)) {
            acted = true;
            player.func_70690_d(new PotionEffect((Potion)ModPotions.slow_fall, this.slow_fall, 0, false, false));
        }
        if (info.has(LIGHT_DRIFTER)) {
            acted = true;
            if (!player.field_70170_p.field_72995_K) {
                player.field_71075_bZ.field_75102_a = true;
                player.field_71075_bZ.field_75101_c = true;
                player.field_70145_X = true;
                player.getEntityData().func_74768_a(LIGHT_DRIFTER_TAG, this.drifter_duration);
                player.getEntityData().func_74780_a(LIGHT_DRIFTER_X, player.field_70165_t);
                player.getEntityData().func_74780_a(LIGHT_DRIFTER_Y, player.field_70163_u + 0.5);
                player.getEntityData().func_74780_a(LIGHT_DRIFTER_Z, player.field_70161_v);
                player.getEntityData().func_74768_a(LIGHT_DRIFTER_DIMENSION_ID, player.field_71093_bK);
                if (player.field_71075_bZ.field_75098_d) {
                    player.getEntityData().func_74768_a(LIGHT_DRIFTER_MODE, GameType.CREATIVE.func_77148_a());
                } else {
                    player.getEntityData().func_74768_a(LIGHT_DRIFTER_MODE, GameType.SURVIVAL.func_77148_a());
                }
                player.func_71033_a(GameType.SPECTATOR);
                PacketHandler.sendToAllTracking((IMessage)new MessageLightDrifterSync(player.func_110124_au(), player.field_70165_t, player.field_70163_u, player.field_70161_v, true, GameType.SPECTATOR.func_77148_a(), player.field_71093_bK), (Entity)player);
                PacketHandler.sendToAllTracking((IMessage)new MessageLightDrifterFX(player.field_70165_t, player.field_70163_u, player.field_70161_v), (Entity)player);
            } else {
                SpectatorHandler.setFake();
            }
        }
        if (info.has(MAGNETISM)) {
            int count = 0;
            count += Magnetize.pull(EntityItem.class, player.field_70170_p, player.func_180425_c(), this.radius_x, this.radius_y, this.radius_z);
            if (SpellConfig.spellFeaturesCategory.shouldMagnetismAttractXP) {
                count += Magnetize.pull(EntityXPOrb.class, player.field_70170_p, player.func_180425_c(), this.radius_x, this.radius_y, this.radius_z);
            }
            if (!acted) {
                boolean bl = acted = count != 0;
            }
        }
        if (info.has(LUCK)) {
            acted = true;
            player.func_70690_d(new PotionEffect(MobEffects.field_188425_z, this.luck_duration, this.luck_amplifier, false, false));
        }
        if (info.has(STRENGTH)) {
            acted = true;
            player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, this.strength_duration, this.strength_amplifier, false, false));
        }
        if (info.has(ABSORPTION)) {
            acted = true;
            player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, this.absorption_duration, this.absorption_amplifier, false, false));
        }
        if (info.has(SECOND_WIND) && (air = player.func_70086_ai()) < 300) {
            acted = true;
            player.func_70050_g(Math.min(300, air + this.air_amount));
            if (player.field_70170_p.field_72995_K) {
                player.func_184185_a(SoundEvents.field_193779_I, 1.0f, 1.0f);
            }
        }
        if (info.has(HASTE)) {
            acted = true;
            player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, this.haste_duration, this.haste_amplifier, false, false));
        }
        if (!acted) {
            player.func_145747_a(new TextComponentTranslation("roots.message.augment.no_modifier", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        }
        return acted;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.radius_x = this.properties.get(PROP_RADIUS_X);
        this.radius_y = this.properties.get(PROP_RADIUS_Y);
        this.radius_z = this.properties.get(PROP_RADIUS_Z);
        this.reach = this.properties.get(PROP_REACH);
        this.reach_duration = this.properties.get(PROP_REACH_DURATION);
        this.speed_duration = this.properties.get(PROP_SPEED_DURATION);
        this.speed_amplifier = this.properties.get(PROP_SPEED_AMPLIFIER);
        this.slow_fall = this.properties.get(PROP_SLOW_FALL_DURATION);
        this.drifter_duration = this.properties.get(PROP_DRIFTER_DURATION);
        this.luck_amplifier = this.properties.get(PROP_LUCK_AMPLIFIER);
        this.luck_duration = this.properties.get(PROP_LUCK_DURATION);
        this.strength_amplifier = this.properties.get(PROP_STRENGTH_AMPLIFIER);
        this.strength_duration = this.properties.get(PROP_STRENGTH_DURATION);
        this.haste_amplifier = this.properties.get(PROP_HASTE_AMPLIFIER);
        this.haste_duration = this.properties.get(PROP_HASTE_DURATION);
        this.air_amount = this.properties.get(PROP_AIR_AMOUNT);
        this.absorption_amplifier = this.properties.get(PROP_ABSORPTION_AMPLIFIER);
        this.absorption_duration = this.properties.get(PROP_ABSORPTION_DURATION);
        ModPotions.reach.loadComplete(this.reach);
    }

    static {
        LIGHT_DRIFTER.addConflicts(SLOW_FALL, MAGNETISM);
        spellName = new ResourceLocation("roots", "spell_augment");
        instance = new SpellAugment(spellName);
    }
}

