/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.roots.entity.ritual.EntityRitualWindwall;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.properties.Property;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.conditions.ConditionRunedPillars;
import epicsquid.roots.ritual.conditions.ConditionStandingStones;
import epicsquid.roots.util.RitualUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreIngredient;

public class RitualWindwall
extends RitualBase {
    public static Property.PropertyDuration PROP_DURATION = new Property.PropertyDuration(3000);
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 51).setDescription("Radius on the X Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 31).setDescription("Radius on the X Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 51).setDescription("Radius on the X Axis of the cube in which the ritual takes place");
    public static Property.PropertyInterval PROP_INTERVAL = new Property.PropertyInterval(10).setDescription("interval in ticks between each ritual knockback boost");
    public static Property<Integer> PROP_DISTANCE = new Property<Integer>("distance", 51).setDescription("the distance at which hostile mobs are kept from the center of the ritual area");
    public static Property<Float> PROP_KNOCKBACK = new Property<Float>("knockback", Float.valueOf(2.0f)).setDescription("the knockback rate at which hostile mobs are pushed away from the center of the ritual");
    public double radius_x;
    public double radius_y;
    public double radius_z;
    public int interval;
    public int distance;
    public float knockback;

    public RitualWindwall(String name, boolean disabled) {
        super(name, disabled);
        this.properties.add(PROP_DURATION, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_INTERVAL, PROP_DISTANCE, PROP_KNOCKBACK);
        this.setEntityClass(EntityRitualWindwall.class);
    }

    @Override
    public void init() {
        this.recipe = new RitualBase.RitualRecipe((RitualBase)this, new ItemStack(ModItems.moonglow_leaf), new OreIngredient("stonebrick"), new OreIngredient("rootsBark"), new OreIngredient("rootsBark"), new OreIngredient("allFlowers"));
        this.setIcon(ModItems.ritual_windwall);
        this.setColor(TextFormatting.DARK_AQUA);
        this.addCondition(new ConditionRunedPillars(RitualUtil.RunedWoodType.SPRUCE, 4, 1));
        this.addCondition(new ConditionStandingStones(4, 1));
    }

    @Override
    public void doFinalise() {
        this.duration = this.properties.get(PROP_DURATION);
        int[] radius = this.properties.getRadius();
        this.radius_x = (double)radius[0] + 0.5;
        this.radius_y = (double)radius[1] + 0.5;
        this.radius_z = (double)radius[2] + 0.5;
        this.interval = this.properties.get(PROP_INTERVAL);
        this.distance = (int)Math.pow(this.properties.get(PROP_DISTANCE).intValue(), 2.0);
        this.knockback = this.properties.get(PROP_KNOCKBACK).floatValue();
    }
}

