/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.recipe;

import epicsquid.mysticallib.types.OneTimeSupplier;
import epicsquid.mysticallib.util.Util;
import epicsquid.mysticalworld.init.ModItems;
import epicsquid.mysticalworld.materials.Materials;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.oredict.OreIngredient;

public class SpiritDrops {
    private static final List<SpiritItem> reliquary = new ArrayList<SpiritItem>();
    private static final List<SpiritItem> pouch = new ArrayList<SpiritItem>();

    public static void clearReliquary() {
        reliquary.clear();
    }

    public static void clearPouch() {
        pouch.clear();
    }

    public static void clear() {
        SpiritDrops.clearReliquary();
        SpiritDrops.clearPouch();
    }

    public static void addReliquary(SpiritItem item) {
        reliquary.add(item);
    }

    public static void addPouch(SpiritItem item) {
        pouch.add(item);
    }

    public static List<SpiritItem> getReliquary() {
        return reliquary;
    }

    public static List<SpiritItem> getPouch() {
        return pouch;
    }

    public static ItemStack getRandomReliquary() {
        if (reliquary.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        SpiritItem item = (SpiritItem)WeightedRandom.func_76271_a((Random)Util.rand, reliquary);
        return item.getItem();
    }

    public static ItemStack getRandomPouch() {
        if (pouch.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        SpiritItem item = (SpiritItem)WeightedRandom.func_76271_a((Random)Util.rand, pouch);
        return item.getItem();
    }

    static {
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151034_e, 3)), 31));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Blocks.field_150321_G, 2)), 22));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151008_G, 6)), 29));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151044_h, 7, 1)), 45));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151122_aG)), 26));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151099_bA)), 23));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151074_bl, 4)), 17));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_191525_da, 4)), 21));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151115_aP, 4, ItemFishFood.FishType.PUFFERFISH.func_150976_a())), 14));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151115_aP, 4, ItemFishFood.FishType.CLOWNFISH.func_150976_a())), 13));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151016_H, 3)), 7));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151123_aH, 2)), 5));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.BLUE.func_176765_a())), 9));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151043_k)), 11));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151042_j)), 13));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151137_ax, 6)), 10));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151057_cb, 2)), 8));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151111_aL)), 6));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151113_aN)), 5));
        SpiritDrops.addPouch(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(ModItems.unripe_pearl, 4)), 4));
        SpiritDrops.addPouch(new OreSpiritItem("nugget" + Materials.copper.getOredictNameSuffix(), 21));
        SpiritDrops.addPouch(new OreSpiritItem("nugget" + Materials.silver.getOredictNameSuffix(), 16));
        SpiritDrops.addPouch(new OreSpiritItem("ingot" + Materials.copper.getOredictNameSuffix(), 11));
        SpiritDrops.addPouch(new OreSpiritItem("ingot" + Materials.silver.getOredictNameSuffix(), 13));
        SpiritDrops.addReliquary(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151062_by)), 35));
        SpiritDrops.addReliquary(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151075_bm, 3)), 29));
        SpiritDrops.addReliquary(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151070_bp, 2)), 32));
        SpiritDrops.addReliquary(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151114_aO, 5)), 14));
        SpiritDrops.addReliquary(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151045_i)), 12));
        SpiritDrops.addReliquary(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151079_bi, 2)), 14));
        SpiritDrops.addReliquary(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151072_bj, 2)), 12));
        SpiritDrops.addReliquary(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151166_bC, 2)), 13));
        SpiritDrops.addReliquary(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Items.field_151073_bk, 3)), 13));
        SpiritDrops.addReliquary(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(Objects.requireNonNull(Materials.amethyst.getItem()))), 15));
        SpiritDrops.addReliquary(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(ModItems.pearl, 6)), 15));
        SpiritDrops.addReliquary(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(ModItems.beetle_mask)), 5));
        SpiritDrops.addReliquary(new StackItem((Supplier<ItemStack>)new OneTimeSupplier(() -> new ItemStack(ModItems.antler_hat)), 6));
    }

    public static abstract class SpiritItem
    extends WeightedRandom.Item {
        protected SpiritItem(int itemWeightIn) {
            super(itemWeightIn);
        }

        public abstract ItemStack getItem();

        public int hashCode() {
            return this.getItem().hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof SpiritItem && ((SpiritItem)((Object)o)).getItem().equals(this.getItem());
        }
    }

    public static class OreSpiritItem
    extends SpiritItem {
        private final Supplier<Ingredient> item = new OneTimeSupplier(() -> new OreIngredient(ore));
        private final String name;

        public OreSpiritItem(String ore, int itemWeightIn) {
            super(itemWeightIn);
            this.name = ore;
        }

        @Override
        public ItemStack getItem() {
            return this.item.get().func_193365_a()[0].func_77946_l();
        }
    }

    public static class StackItem
    extends SpiritItem {
        private final Supplier<ItemStack> stack;

        public StackItem(Supplier<ItemStack> stack, int itemWeightIn) {
            super(itemWeightIn);
            this.stack = stack;
        }

        @Override
        public ItemStack getItem() {
            return this.stack.get().func_77946_l();
        }
    }
}

