/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.potion;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.modifiers.instance.staff.ModifierSnapshot;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessageAquaBubbleFX;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.spell.SpellAquaBubble;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PotionAquaBubble
extends Potion {
    private ResourceLocation texture = new ResourceLocation("roots", "textures/gui/potions.png");
    private float absorb_amount = 0.0f;
    private float amplifier = 0.0f;

    public PotionAquaBubble() {
        super(false, 4104685);
        this.func_76390_b("Aqua Bubble");
        this.func_188413_j();
        this.func_76399_b(8, 0);
    }

    public void finalise(SpellAquaBubble spell) {
        this.absorb_amount = (float)spell.absorption;
        this.amplifier = spell.amplifier;
    }

    public static void doEffect(World world, double posX, double posY, double posZ) {
        for (float i = 0.0f; i < 360.0f; i += (float)Util.rand.nextInt(40)) {
            float x = (float)posX + 1.2f * Util.rand.nextFloat() * (float)Math.sin(Math.toRadians(i));
            float y = (float)posY + (Util.rand.nextFloat() + 0.25f);
            float z = (float)posZ + 1.2f * Util.rand.nextFloat() * (float)Math.cos(Math.toRadians(i));
            float vx = 0.0625f * (float)Math.cos(Math.toRadians(i));
            float vz = 0.025f * (float)Math.sin(Math.toRadians(i));
            if (Util.rand.nextBoolean()) {
                vx *= -1.0f;
                vz *= -1.0f;
            }
            if (Util.rand.nextBoolean()) {
                ParticleUtil.spawnParticleSmoke(world, x, y, z, vx, 0.125f * (Util.rand.nextFloat() - 0.5f), vz, SpellAquaBubble.instance.getFirstColours(0.125f), 4.0f + Util.rand.nextFloat() * 6.0f, 120, false);
                continue;
            }
            ParticleUtil.spawnParticleSmoke(world, x, y, z, vx, 0.125f * (Util.rand.nextFloat() - 0.5f), vz, SpellAquaBubble.instance.getSecondColours(0.125f), 4.0f + Util.rand.nextFloat() * 6.0f, 120, false);
        }
    }

    public void func_76394_a(EntityLivingBase entity, int amplifier) {
        if (!entity.field_70170_p.field_72995_K) {
            ModifierSnapshot mods = StaffModifierInstanceList.fromSnapshot(entity.getEntityData(), SpellAquaBubble.instance);
            if (mods.has(SpellAquaBubble.POISON_RESIST)) {
                entity.func_184589_d(MobEffects.field_76436_u);
            }
            if (!(entity instanceof EntityPlayer) && Util.rand.nextInt(10) == 0) {
                PacketHandler.sendToAllTracking((IMessage)new MessageAquaBubbleFX(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v), (Entity)entity);
            }
        } else if (Util.rand.nextInt(10) == 0) {
            PotionAquaBubble.doEffect(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }

    public boolean shouldRender(PotionEffect effect) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76392_e() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        return super.func_76392_e();
    }

    public void func_111187_a(EntityLivingBase entityLivingBaseIn, AbstractAttributeMap attributeMapIn, int amplifier) {
        ModifierSnapshot mods = StaffModifierInstanceList.fromSnapshot(entityLivingBaseIn.getEntityData(), SpellAquaBubble.instance);
        float absorb = this.absorb_amount;
        if (mods.has(SpellAquaBubble.AMPLIFIED)) {
            absorb += this.absorb_amount * this.amplifier;
        }
        entityLivingBaseIn.func_110149_m(entityLivingBaseIn.func_110139_bj() - absorb);
        super.func_111187_a(entityLivingBaseIn, attributeMapIn, amplifier);
    }

    public void func_111185_a(EntityLivingBase entityLivingBaseIn, AbstractAttributeMap attributeMapIn, int amplifier) {
        ModifierSnapshot mods = StaffModifierInstanceList.fromSnapshot(entityLivingBaseIn.getEntityData(), SpellAquaBubble.instance);
        float absorb = this.absorb_amount;
        if (mods.has(SpellAquaBubble.AMPLIFIED)) {
            absorb += this.absorb_amount * this.amplifier;
        }
        entityLivingBaseIn.func_110149_m(entityLivingBaseIn.func_110139_bj() + absorb);
        super.func_111185_a(entityLivingBaseIn, attributeMapIn, amplifier);
    }
}

