/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.network.fx;

import epicsquid.mysticallib.util.Util;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.ClientMessageHandler;
import epicsquid.roots.network.fx.ModifierPacket;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.spell.SpellSanctuary;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageSanctuaryRingFX
extends ModifierPacket
implements IMessage {
    private double posX = 0.0;
    private double posY = 0.0;
    private double posZ = 0.0;

    public MessageSanctuaryRingFX() {
    }

    public MessageSanctuaryRingFX(double x, double y, double z, StaffModifierInstanceList mods) {
        super(mods);
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public static float getColorCycle(float ticks) {
        return (MathHelper.func_76126_a((float)((float)Math.toRadians(ticks))) + 1.0f) / 2.0f;
    }

    public static class MessageHolder
    extends ClientMessageHandler<MessageSanctuaryRingFX> {
        @Override
        @SideOnly(value=Side.CLIENT)
        protected void handleMessage(MessageSanctuaryRingFX message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            float c = message.modifiers.has(SpellSanctuary.RADIUS) ? MathHelper.func_76129_c((float)(1 + SpellSanctuary.instance.radius_x + SpellSanctuary.instance.radius_z + 2 * SpellSanctuary.instance.radius_boost)) : MathHelper.func_76129_c((float)(1 + SpellSanctuary.instance.radius_x + SpellSanctuary.instance.radius_z));
            for (float k = 0.0f; k < 360.0f; k += (float)Util.rand.nextInt(42)) {
                if (!Util.rand.nextBoolean()) continue;
                if (Util.rand.nextBoolean()) {
                    ParticleUtil.spawnParticlePetal((World)world, (float)message.posX + c * (float)Math.sin(Math.toRadians(k)), (float)message.posY, (float)message.posZ + c * (float)Math.cos(Math.toRadians(k)), 0.0f, 0.0f, 0.0f, SpellSanctuary.instance.getFirstColours(0.5f), 1.25f + 5.0f * Util.rand.nextFloat(), 40);
                    continue;
                }
                ParticleUtil.spawnParticlePetal((World)world, (float)message.posX + c * (float)Math.sin(Math.toRadians(k)), (float)message.posY, (float)message.posZ + c * (float)Math.cos(Math.toRadians(k)), 0.0f, 0.0f, 0.0f, SpellSanctuary.instance.getSecondColours(0.5f), 1.25f + 5.0f * Util.rand.nextFloat(), 40);
            }
        }
    }
}

