/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.network.fx;

import epicsquid.mysticallib.util.Util;
import epicsquid.roots.network.ClientMessageHandler;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.spell.FakeSpell;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellRegistry;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageImbueCompleteFX
implements IMessage {
    private double posX = 0.0;
    private double posY = 0.0;
    private double posZ = 0.0;
    private String spellName = "null";

    public MessageImbueCompleteFX() {
    }

    public MessageImbueCompleteFX(String name, double x, double y, double z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.spellName = name;
    }

    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.spellName = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.spellName);
    }

    public static float getColorCycle(float ticks) {
        return (MathHelper.func_76126_a((float)((float)Math.toRadians(ticks))) + 1.0f) / 2.0f;
    }

    public static class MessageHolder
    extends ClientMessageHandler<MessageImbueCompleteFX> {
        @Override
        @SideOnly(value=Side.CLIENT)
        protected void handleMessage(MessageImbueCompleteFX message, MessageContext ctx) {
            SpellBase spell;
            SpellBase spellBase = spell = message.spellName.equals("fake_spell") ? new FakeSpell() : SpellRegistry.getSpell(message.spellName);
            if (spell != null) {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                for (int k = 0; k < 40; ++k) {
                    if (Util.rand.nextBoolean()) {
                        ParticleUtil.spawnParticleGlow((World)world, (float)message.posX, (float)message.posY, (float)message.posZ, 0.125f * (Util.rand.nextFloat() - 0.5f), 0.125f * (Util.rand.nextFloat() - 0.5f), 0.125f * (Util.rand.nextFloat() - 0.5f), spell.getFirstColours(0.5f), 2.5f, 48);
                        continue;
                    }
                    ParticleUtil.spawnParticleGlow((World)world, (float)message.posX, (float)message.posY, (float)message.posZ, 0.125f * (Util.rand.nextFloat() - 0.5f), 0.125f * (Util.rand.nextFloat() - 0.5f), 0.125f * (Util.rand.nextFloat() - 0.5f), spell.getSecondColours(0.5f), 2.5f, 48);
                }
            }
        }
    }
}

