/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.network;

import epicsquid.roots.client.SpectatorHandler;
import epicsquid.roots.network.ClientMessageHandler;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageLightDrifterSync
implements IMessage {
    private UUID id = null;
    private boolean enable = false;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private int dimension = 0;
    private int mode = 0;

    public MessageLightDrifterSync() {
    }

    public MessageLightDrifterSync(UUID id, double x, double y, double z, boolean enable, int mode, int dimension) {
        this.id = id;
        this.enable = enable;
        this.x = x;
        this.y = y;
        this.z = z;
        this.mode = mode;
        this.dimension = dimension;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.enable = buf.readBoolean();
        this.id = new UUID(buf.readLong(), buf.readLong());
        this.mode = buf.readInt();
        this.dimension = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeBoolean(this.enable);
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
        buf.writeInt(this.mode);
        buf.writeInt(this.dimension);
    }

    public static float getColorCycle(float ticks) {
        return (MathHelper.func_76126_a((float)((float)Math.toRadians(ticks))) + 1.0f) / 2.0f;
    }

    public static class MessageHolder
    extends ClientMessageHandler<MessageLightDrifterSync> {
        @Override
        @SideOnly(value=Side.CLIENT)
        protected void handleMessage(MessageLightDrifterSync message, MessageContext ctx) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc == null || mc.field_71439_g == null) {
                return;
            }
            WorldClient world = mc.field_71441_e;
            EntityPlayer player = world.func_152378_a(message.id);
            if (player != null) {
                if (!message.enable) {
                    player.func_70634_a(message.x, message.y, message.z);
                    if (player == mc.field_71439_g) {
                        SpectatorHandler.setReal();
                    }
                    player.field_70145_X = message.enable;
                } else {
                    player.field_70145_X = true;
                    player.func_70634_a(message.x, message.y, message.z);
                }
                player.field_71075_bZ.field_75100_b = message.enable;
                GameType type = GameType.func_77146_a((int)message.mode);
                if (type == null) {
                    type = GameType.SURVIVAL;
                }
                player.func_71033_a(type);
                player.field_71075_bZ.field_75102_a = message.enable;
                player.field_71075_bZ.field_75101_c = message.enable;
            }
        }
    }
}

