/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.item.terrastone;

import com.google.common.collect.Sets;
import epicsquid.mysticalworld.events.LeafHandler;
import epicsquid.roots.config.ToolConfig;
import epicsquid.roots.init.ModItems;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="roots")
public class ToolEvents {
    private static final Set<Block> SILK_TOUCH_BLOCKS = Sets.newHashSet((Object[])new Block[]{Blocks.field_150391_bh, Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150321_G});
    private static final Item DIRT_ITEM = Item.func_150898_a((Block)Blocks.field_150346_d);

    @SubscribeEvent
    public static void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        ItemStack output;
        if (!ToolConfig.ShovelSilkTouch && !ToolConfig.SwordSilkTouch) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        IBlockState state = event.getState();
        if (player == null || state == null) {
            return;
        }
        Item heldItem = player.func_184614_ca().func_77973_b();
        if (heldItem != ModItems.terrastone_sword && heldItem != ModItems.terrastone_shovel) {
            return;
        }
        if (heldItem == ModItems.terrastone_shovel && !ToolConfig.ShovelSilkTouch) {
            return;
        }
        if (heldItem == ModItems.terrastone_sword && !ToolConfig.SwordSilkTouch) {
            return;
        }
        if (!SILK_TOUCH_BLOCKS.contains(state.func_177230_c())) {
            return;
        }
        if (state.func_177230_c() == Blocks.field_150346_d) {
            if (state.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.PODZOL) {
                return;
            }
            output = new ItemStack(Blocks.field_150346_d, 1, Blocks.field_150346_d.func_176201_c(state));
        } else {
            output = new ItemStack(state.func_177230_c(), 1);
        }
        List drops = event.getDrops();
        Iterator iterator = drops.iterator();
        if (player.func_184614_ca().func_77973_b() == ModItems.terrastone_shovel) {
            boolean foundDirt = false;
            while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                if (stack.func_77973_b() != DIRT_ITEM) continue;
                foundDirt = true;
                iterator.remove();
                break;
            }
            if (!foundDirt) {
                return;
            }
        } else if (player.func_184614_ca().func_77973_b() == ModItems.terrastone_sword) {
            boolean foundString = false;
            while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                if (stack.func_77973_b() != Items.field_151007_F) continue;
                foundString = true;
                iterator.remove();
                break;
            }
            if (!foundString) {
                return;
            }
        }
        drops.add(output);
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        BlockPos pos = event.getPos();
        if (pos.func_177956_o() == -1) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        Item heldItem = player.func_184614_ca().func_77973_b();
        if (heldItem != ModItems.terrastone_pickaxe && heldItem != ModItems.terrastone_sword && heldItem != ModItems.terrastone_axe && heldItem != ModItems.terrastone_hoe) {
            return;
        }
        IBlockState state = event.getState();
        if (heldItem == ModItems.terrastone_sword && state.func_177230_c() != Blocks.field_150321_G) {
            return;
        }
        if (heldItem == ModItems.terrastone_sword) {
            if (ToolConfig.SwordCobwebBreak) {
                event.setNewSpeed(100.0f);
            }
            return;
        }
        if ((heldItem == ModItems.terrastone_axe && ToolConfig.AxeLeaves || heldItem == ModItems.terrastone_hoe && ToolConfig.HoeSilkTouch) && LeafHandler.isLeafBlock((Block)state.func_177230_c())) {
            event.setNewSpeed(100.0f);
            return;
        }
        float speed = event.getNewSpeed();
        float hardness = state.func_185887_b(player.field_70170_p, pos);
        Material mat = state.func_185904_a();
        if (hardness < 2.0f || hardness == 2.0f && mat == Material.field_151576_e) {
            event.setNewSpeed((float)((double)speed * ToolConfig.PickaxeSoftModifier));
        } else if (hardness >= 50.0f) {
            event.setNewSpeed((float)((double)speed * ToolConfig.PickaxeHardModifier));
        }
    }
}

