/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.item.dispenser;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.capability.runic_shears.RunicShearsCapability;
import epicsquid.roots.capability.runic_shears.RunicShearsCapabilityProvider;
import epicsquid.roots.config.GeneralConfig;
import epicsquid.roots.config.MossConfig;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.item.ItemRunicShears;
import epicsquid.roots.network.fx.MessageRunicShearsAOEFX;
import epicsquid.roots.network.fx.MessageRunicShearsBlockFX;
import epicsquid.roots.network.fx.MessageRunicShearsFX;
import epicsquid.roots.recipe.RunicShearEntityRecipe;
import epicsquid.roots.recipe.RunicShearRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DispenseRunicShears
implements IBehaviorDispenseItem {
    private static final DispenseRunicShears INSTANCE = new DispenseRunicShears();

    public static DispenseRunicShears getInstance() {
        return INSTANCE;
    }

    private DispenseRunicShears() {
    }

    public ItemStack func_82482_a(IBlockSource source, ItemStack stack) {
        World world = source.func_82618_k();
        if (MossConfig.getBlacklistDimensions().contains(world.field_73011_w.getDimension())) {
            return stack;
        }
        boolean successful = false;
        if (!world.field_72995_K) {
            List closeEntities;
            Entity entity;
            List entities;
            RunicShearRecipe recipe;
            EnumFacing facing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
            BlockPos pos = source.func_180699_d().func_177972_a(facing);
            IBlockState targetState = world.func_180495_p(pos);
            IBlockState moss = MossConfig.scrapeResult(targetState);
            IBlockState moss2 = MossConfig.mossConversion(targetState);
            Block block = targetState.func_177230_c();
            if (moss != null || moss2 != null) {
                AxisAlignedBB bounds = ItemRunicShears.bounding.func_186670_a(pos);
                BlockPos start = new BlockPos(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c);
                BlockPos stop = new BlockPos(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f);
                ArrayList<BlockPos> affectedBlocks = new ArrayList<BlockPos>();
                for (BlockPos.MutableBlockPos p : BlockPos.func_177975_b((BlockPos)start, (BlockPos)stop)) {
                    IBlockState pState = world.func_180495_p((BlockPos)p);
                    IBlockState m = MossConfig.scrapeResult(pState);
                    if (m == null) continue;
                    affectedBlocks.add(p.func_185334_h());
                    world.func_175656_a((BlockPos)p, m);
                    world.func_180497_b((BlockPos)p, m.func_177230_c(), 1, m.func_177230_c().func_149738_a(world));
                    ItemUtil.spawnItem((World)world, (BlockPos)pos.func_177984_a(), (ItemStack)new ItemStack(ModItems.terra_moss));
                }
                if (!affectedBlocks.isEmpty()) {
                    if (stack.func_96631_a(1 + Math.min(6, world.field_73012_v.nextInt(affectedBlocks.size())), world.field_73012_v, (EntityPlayerMP)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)))) {
                        stack.func_190920_e(0);
                    }
                    MessageRunicShearsAOEFX message = new MessageRunicShearsAOEFX(affectedBlocks);
                    PacketHandler.sendToAllTracking((IMessage)message, (int)world.field_73011_w.getDimension(), (BlockPos)pos);
                    successful = true;
                }
            }
            if (!successful && (recipe = ModRecipes.getRunicShearRecipe(targetState)) != null) {
                if (block instanceof BlockCrops) {
                    BlockCrops crop = (BlockCrops)block;
                    if (crop.func_185525_y(world.func_180495_p(pos))) {
                        world.func_175656_a(pos, crop.func_185528_e(0));
                        successful = true;
                    }
                } else {
                    world.func_175656_a(pos, recipe.getReplacementState());
                    successful = true;
                }
                if (successful) {
                    ItemUtil.spawnItem((World)world, (BlockPos)pos.func_177984_a(), (ItemStack)recipe.getDrop().func_77946_l());
                    if (stack.func_96631_a(1, world.field_73012_v, (EntityPlayerMP)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)))) {
                        stack.func_190920_e(0);
                    }
                    MessageRunicShearsBlockFX message = new MessageRunicShearsBlockFX(pos);
                    PacketHandler.sendToAllTracking((IMessage)message, (int)world.field_73011_w.getDimension(), (BlockPos)pos);
                }
            }
            if (!successful && !(entities = world.func_175674_a(null, new AxisAlignedBB(pos), e -> !(e instanceof EntityPlayer) && e instanceof EntityLivingBase)).isEmpty()) {
                entity = null;
                RunicShearEntityRecipe recipe2 = null;
                RunicShearsCapability cap = null;
                while (!entities.isEmpty()) {
                    entity = (Entity)entities.remove(world.field_73012_v.nextInt(entities.size()));
                    recipe2 = ModRecipes.getRunicShearRecipe((EntityLivingBase)entity);
                    if (recipe2 == null || (cap = (RunicShearsCapability)((Object)entity.getCapability(RunicShearsCapabilityProvider.RUNIC_SHEARS_CAPABILITY, null))) == null) continue;
                    if (cap.canHarvest()) break;
                    recipe2 = null;
                    cap = null;
                }
                if (entity != null && recipe2 != null && cap != null) {
                    cap.setCooldown(recipe2.getCooldown());
                    EntityItem ent = entity.func_70099_a(recipe2.getDrop((EntityLivingBase)entity).func_77946_l(), 1.0f);
                    ent.field_70181_x += (double)(Util.rand.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((Util.rand.nextFloat() - Util.rand.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((Util.rand.nextFloat() - Util.rand.nextFloat()) * 0.1f);
                    if (stack.func_96631_a(1, world.field_73012_v, (EntityPlayerMP)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)))) {
                        stack.func_190920_e(0);
                    }
                    MessageRunicShearsFX packet = new MessageRunicShearsFX(entity);
                    PacketHandler.sendToAllTracking((IMessage)packet, (Entity)entity);
                    successful = true;
                }
            }
            if (!successful && !(closeEntities = world.func_175674_a(null, new AxisAlignedBB(pos), e -> e instanceof IShearable)).isEmpty()) {
                entity = (Entity)closeEntities.get(world.field_73012_v.nextInt(closeEntities.size()));
                successful = true;
                Items.field_151097_aZ.func_111207_a(stack, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)), (EntityLivingBase)entity, EnumHand.MAIN_HAND);
                ArrayList<BlockPos> affectedSpots = new ArrayList<BlockPos>();
                affectedSpots.add(entity.func_180425_c());
                float radius = GeneralConfig.RunicShearsRadius;
                List entities2 = Util.getEntitiesWithinRadius((World)entity.field_70170_p, e -> e instanceof IShearable, (BlockPos)entity.func_180425_c(), (float)radius, (float)(radius / 2.0f), (float)radius);
                for (EntityLiving e2 : entities2) {
                    e2.captureDrops = true;
                    if (Items.field_151097_aZ.func_111207_a(stack, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)), (EntityLivingBase)e2, EnumHand.MAIN_HAND)) {
                        affectedSpots.add(e2.func_180425_c());
                    }
                    e2.captureDrops = false;
                    for (EntityItem ent : e2.capturedDrops) {
                        ent.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                        ent.field_70181_x = 0.0;
                        ent.field_70159_w = 0.0;
                        ent.field_70179_y = 0.0;
                        ent.field_70170_p.func_72838_d((Entity)ent);
                    }
                }
                MessageRunicShearsAOEFX message = new MessageRunicShearsAOEFX(affectedSpots);
                PacketHandler.sendToAllTracking((IMessage)message, (int)world.field_73011_w.getDimension(), (BlockPos)pos);
            }
            if (successful) {
                source.func_82618_k().func_184133_a(null, source.func_180699_d(), SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        return stack;
    }
}

