/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.item;

import epicsquid.mysticallib.item.ItemBase;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.network.NetworkHandler;
import vazkii.patchouli.common.network.message.MessageOpenBookGui;

public class ItemGuide
extends ItemBase {
    public static ResourceLocation BOOK_LOCATION = new ResourceLocation("roots", "roots_guide");

    public ItemGuide(@Nonnull String name) {
        super(name);
    }

    public static Book getBook(ItemStack stack) {
        return (Book)BookRegistry.INSTANCE.books.get(BOOK_LOCATION);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Book book = ItemGuide.getBook(stack);
        if (book != null && book.contents != null) {
            tooltip.add(book.contents.getSubtitle());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        Book book = ItemGuide.getBook(stack);
        if (book == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (playerIn instanceof EntityPlayerMP) {
            NetworkHandler.INSTANCE.sendTo((IMessage)new MessageOpenBookGui(book.resourceLoc.toString()), (EntityPlayerMP)playerIn);
            SoundEvent sfx = PatchouliSounds.getSound((String)book.openSound, (SoundEvent)PatchouliSounds.book_open);
            worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, sfx, SoundCategory.PLAYERS, 1.0f, (float)(0.7 + Math.random() * 0.4));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

