/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.jei;

import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.config.GeneralConfig;
import epicsquid.roots.config.MossConfig;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.integration.jei.FeyCrafterTransfer;
import epicsquid.roots.integration.jei.carving.BarkRecipeCategory;
import epicsquid.roots.integration.jei.carving.BarkRecipeWrapper;
import epicsquid.roots.integration.jei.carving.MossRecipeCategory;
import epicsquid.roots.integration.jei.carving.MossRecipeWrapper;
import epicsquid.roots.integration.jei.carving.RunedWoodCategory;
import epicsquid.roots.integration.jei.carving.RunedWoodWrapper;
import epicsquid.roots.integration.jei.chrysopoeia.ChrysopoeiaCategory;
import epicsquid.roots.integration.jei.chrysopoeia.ChrysopoeiaWrapper;
import epicsquid.roots.integration.jei.fey.FeyCategory;
import epicsquid.roots.integration.jei.fey.FeyWrapper;
import epicsquid.roots.integration.jei.interact.BlockBreakCategory;
import epicsquid.roots.integration.jei.interact.BlockBreakRecipe;
import epicsquid.roots.integration.jei.interact.BlockBreakWrapper;
import epicsquid.roots.integration.jei.interact.BlockRightClickCategory;
import epicsquid.roots.integration.jei.interact.BlockRightClickRecipe;
import epicsquid.roots.integration.jei.interact.BlockRightClickWrapper;
import epicsquid.roots.integration.jei.interact.ImbuingCategory;
import epicsquid.roots.integration.jei.interact.ImbuingWrapper;
import epicsquid.roots.integration.jei.interact.ImposingCategory;
import epicsquid.roots.integration.jei.interact.ImposingWrapper;
import epicsquid.roots.integration.jei.interact.PyreLightCategory;
import epicsquid.roots.integration.jei.interact.PyreLightWrapper;
import epicsquid.roots.integration.jei.interact.RitualVisualiseCategory;
import epicsquid.roots.integration.jei.interact.RitualVisualiseWrapper;
import epicsquid.roots.integration.jei.loot.LootCategory;
import epicsquid.roots.integration.jei.loot.LootWrapper;
import epicsquid.roots.integration.jei.mortar.MortarCategory;
import epicsquid.roots.integration.jei.mortar.MortarWrapper;
import epicsquid.roots.integration.jei.ritual.RitualCategory;
import epicsquid.roots.integration.jei.ritual.RitualCraftingCategory;
import epicsquid.roots.integration.jei.ritual.RitualCraftingWrapper;
import epicsquid.roots.integration.jei.ritual.RitualWrapper;
import epicsquid.roots.integration.jei.shears.RunicShearsCategory;
import epicsquid.roots.integration.jei.shears.RunicShearsEntityCategory;
import epicsquid.roots.integration.jei.shears.RunicShearsEntityWrapper;
import epicsquid.roots.integration.jei.shears.RunicShearsSummonEntityCategory;
import epicsquid.roots.integration.jei.shears.RunicShearsSummonEntityWrapper;
import epicsquid.roots.integration.jei.shears.RunicShearsWrapper;
import epicsquid.roots.integration.jei.soil.SoilCategory;
import epicsquid.roots.integration.jei.soil.SoilRecipe;
import epicsquid.roots.integration.jei.soil.SoilWrapper;
import epicsquid.roots.integration.jei.spell.SpellCostCategory;
import epicsquid.roots.integration.jei.spell.SpellCostWrapper;
import epicsquid.roots.integration.jei.summon.SummonCreaturesCategory;
import epicsquid.roots.integration.jei.summon.SummonCreaturesWrapper;
import epicsquid.roots.integration.jei.transmutation.TransmutationCategory;
import epicsquid.roots.integration.jei.transmutation.TransmutationWrapper;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.recipe.BarkRecipe;
import epicsquid.roots.recipe.ChrysopoeiaRecipe;
import epicsquid.roots.recipe.FeyCraftingRecipe;
import epicsquid.roots.recipe.MortarRecipe;
import epicsquid.roots.recipe.MossRecipe;
import epicsquid.roots.recipe.PyreCraftingRecipe;
import epicsquid.roots.recipe.RunicShearEntityRecipe;
import epicsquid.roots.recipe.RunicShearRecipe;
import epicsquid.roots.recipe.SpiritDrops;
import epicsquid.roots.recipe.SummonCreatureIntermediate;
import epicsquid.roots.recipe.SummonCreatureRecipe;
import epicsquid.roots.recipe.TransmutationRecipe;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.RitualRegistry;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellChrysopoeia;
import epicsquid.roots.spell.SpellRegistry;
import epicsquid.roots.spell.info.SpellDustInfo;
import epicsquid.roots.spell.info.StaffSpellInfo;
import epicsquid.roots.spell.info.storage.DustSpellStorage;
import epicsquid.roots.spell.info.storage.StaffSpellStorage;
import epicsquid.roots.tileentity.TileEntityPyre;
import epicsquid.roots.util.RitualUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IVanillaRecipeFactory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreIngredient;

@JEIPlugin
public class JEIRootsPlugin
implements IModPlugin {
    public static final String RUNIC_SHEARS = "roots.runic_shears";
    public static final String RUNIC_SHEARS_ENTITY = "roots.runic_shears_entity";
    public static final String RUNIC_SHEARS_SUMMON_ENTITY = "roots.runic_shears_summon_entity";
    public static final String BARK_CARVING = "roots.bark_carving";
    public static final String RITUAL_CRAFTING = "roots.ritual_crafting";
    public static final String MORTAR_AND_PESTLE = "roots.mortar_and_pestle";
    public static final String RITUAL = "roots.ritual";
    public static final String FEY_CRAFTING = "roots.fey_crafting";
    public static final String SOIL = "roots.soil";
    public static final String SPELL_COSTS = "roots.spell_costs";
    public static final String TERRA_MOSS = "roots.terra_moss";
    public static final String SUMMON_CREATURES = "roots.summon_creatures";
    public static final String CHRYSOPOEIA = "roots.chrysopoeia";
    public static final String TRANSMUTATION = "roots.transmutation";
    public static final String RUNED_WOOD = "roots.runed_wood";
    public static final String LOOT = "roots.loot";
    public static final String BLOCK_BREAK = "roots.block_break";
    public static final String RIGHT_CLICK_BLOCK = "roots.right_click_block";
    public static final String PYRE_LIGHT = "roots.pyre_light";
    public static final String RITUAL_VISUALISE = "roots.ritual_visualise";
    public static final String SPELL_IMBUING = "roots.spell_imbuing";
    public static final String SPELL_IMPOSING = "roots.spell_imposing";
    public static IJeiRuntime runtime = null;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new RunicShearsCategory(helper), new RitualCraftingCategory(helper), new ChrysopoeiaCategory(helper), new RitualCategory(helper), new FeyCategory(helper), new SpellCostCategory(helper), new BarkRecipeCategory(helper), new MossRecipeCategory(helper), new RunicShearsEntityCategory(helper), new SummonCreaturesCategory(helper), new MortarCategory(helper), new TransmutationCategory(helper), new RunedWoodCategory(helper), new LootCategory(helper), new RunicShearsSummonEntityCategory(helper), new BlockBreakCategory(helper), new BlockRightClickCategory(helper), new SoilCategory(helper), new PyreLightCategory(helper), new RitualVisualiseCategory(helper), new ImbuingCategory(helper), new ImposingCategory(helper)});
    }

    private List<IRecipeWrapper> generateRepairRecipes(Ingredient repairItem, List<ItemStack> itemsToRepair, IVanillaRecipeFactory vanillaFactory) {
        ArrayList<IRecipeWrapper> result = new ArrayList<IRecipeWrapper>();
        boolean first = true;
        for (ItemStack repairMat : repairItem.func_193365_a()) {
            for (ItemStack toRepair : itemsToRepair) {
                ItemStack damaged1 = toRepair.func_77946_l();
                damaged1.func_77964_b(damaged1.func_77958_k());
                ItemStack damaged2 = toRepair.func_77946_l();
                damaged2.func_77964_b(damaged2.func_77958_k() * 3 / 4);
                ItemStack damaged3 = toRepair.func_77946_l();
                damaged3.func_77964_b(damaged3.func_77958_k() * 2 / 4);
                if (first) {
                    IRecipeWrapper repairWithSame = vanillaFactory.createAnvilRecipe(damaged2, Collections.singletonList(damaged2), Collections.singletonList(damaged3));
                    result.add(repairWithSame);
                    first = false;
                }
                IRecipeWrapper repairWithMaterial = vanillaFactory.createAnvilRecipe(damaged1, Collections.singletonList(repairMat), Collections.singletonList(damaged2));
                result.add(repairWithMaterial);
            }
        }
        return result;
    }

    public void register(IModRegistry registry) {
        IVanillaRecipeFactory vanillaFactory = registry.getJeiHelpers().getVanillaRecipeFactory();
        registry.addRecipes(this.generateRepairRecipes((Ingredient)new OreIngredient("runestone"), Collections.singletonList(new ItemStack(ModItems.runic_shears)), vanillaFactory), "minecraft.anvil");
        registry.addRecipes(this.generateRepairRecipes((Ingredient)new OreIngredient("plankWood"), Collections.singletonList(new ItemStack(ModItems.wooden_shears)), vanillaFactory), "minecraft.anvil");
        registry.addRecipes(this.generateRepairRecipes((Ingredient)new OreIngredient("rootsBarkWildwood"), Arrays.asList(new ItemStack(ModItems.wildwood_quiver), new ItemStack(ModItems.wildwood_boots), new ItemStack(ModItems.wildwood_bow), new ItemStack(ModItems.wildwood_chestplate), new ItemStack(ModItems.wildwood_helmet), new ItemStack(ModItems.wildwood_leggings)), vanillaFactory), "minecraft.anvil");
        registry.addRecipes(this.generateRepairRecipes((Ingredient)new OreIngredient("rootsBark"), Arrays.asList(new ItemStack(ModItems.living_axe), new ItemStack(ModItems.living_hoe), new ItemStack(ModItems.living_pickaxe), new ItemStack(ModItems.living_pickaxe), new ItemStack(ModItems.living_shovel), new ItemStack(ModItems.living_sword)), vanillaFactory), "minecraft.anvil");
        registry.addRecipes(this.generateRepairRecipes((Ingredient)new OreIngredient("feyLeather"), Arrays.asList(new ItemStack(ModItems.sylvan_boots), new ItemStack(ModItems.sylvan_leggings), new ItemStack(ModItems.sylvan_chestplate), new ItemStack(ModItems.sylvan_helmet)), vanillaFactory), "minecraft.anvil");
        registry.handleRecipes(RunicShearRecipe.class, RunicShearsWrapper::new, RUNIC_SHEARS);
        registry.handleRecipes(RunicShearEntityRecipe.class, RunicShearsEntityWrapper::new, RUNIC_SHEARS_ENTITY);
        registry.handleRecipes(PyreCraftingRecipe.class, RitualCraftingWrapper::new, RITUAL_CRAFTING);
        registry.handleRecipes(MortarRecipe.class, MortarWrapper::new, MORTAR_AND_PESTLE);
        registry.handleRecipes(SpellBase.class, MortarWrapper::new, MORTAR_AND_PESTLE);
        registry.handleRecipes(RitualBase.class, RitualWrapper::new, RITUAL);
        registry.handleRecipes(FeyCraftingRecipe.class, FeyWrapper::new, FEY_CRAFTING);
        registry.handleRecipes(SpellBase.class, SpellCostWrapper::new, SPELL_COSTS);
        registry.handleRecipes(BarkRecipe.class, BarkRecipeWrapper::new, BARK_CARVING);
        registry.handleRecipes(MossRecipe.class, MossRecipeWrapper::new, TERRA_MOSS);
        registry.handleRecipes(SummonCreatureRecipe.class, SummonCreaturesWrapper::new, SUMMON_CREATURES);
        registry.handleRecipes(SummonCreatureIntermediate.class, SummonCreaturesWrapper::new, SUMMON_CREATURES);
        registry.handleRecipes(SummonCreatureIntermediate.class, RunicShearsSummonEntityWrapper::new, RUNIC_SHEARS_SUMMON_ENTITY);
        registry.handleRecipes(ChrysopoeiaRecipe.class, ChrysopoeiaWrapper::new, CHRYSOPOEIA);
        registry.handleRecipes(TransmutationRecipe.class, TransmutationWrapper::new, TRANSMUTATION);
        registry.handleRecipes(RitualUtil.RunedWoodType.class, RunedWoodWrapper::new, RUNED_WOOD);
        registry.handleRecipes(LootWrapper.LootRecipe.class, LootWrapper::new, LOOT);
        registry.handleRecipes(BlockBreakRecipe.class, BlockBreakWrapper::new, BLOCK_BREAK);
        registry.handleRecipes(BlockRightClickRecipe.class, BlockRightClickWrapper::new, RIGHT_CLICK_BLOCK);
        registry.handleRecipes(SoilRecipe.class, SoilWrapper::new, SOIL);
        registry.handleRecipes(PyreLightWrapper.PyreLightRecipe.class, PyreLightWrapper::new, PYRE_LIGHT);
        registry.handleRecipes(RitualVisualiseWrapper.KnifeRecipe.class, RitualVisualiseWrapper::new, RITUAL_VISUALISE);
        registry.handleRecipes(SpellBase.class, ImbuingWrapper::new, SPELL_IMBUING);
        registry.handleRecipes(SpellBase.class, ImposingWrapper::new, SPELL_IMPOSING);
        registry.addRecipes(SoilRecipe.recipes, SOIL);
        registry.addRecipes(Collections.singletonList(new RitualVisualiseWrapper.KnifeRecipe()), RITUAL_VISUALISE);
        Collection spells = SpellRegistry.spellRegistry.values().stream().filter(o -> !o.isDisabled()).collect(Collectors.toList());
        ArrayList<BlockBreakRecipe> blockBreakRecipes = new ArrayList<BlockBreakRecipe>();
        blockBreakRecipes.add(new BlockBreakRecipe((Ingredient)new OreIngredient("tallgrass"), new ItemStack(ModItems.terra_spores)));
        blockBreakRecipes.add(new BlockBreakRecipe((Ingredient)new OreIngredient("tallgrass"), new ItemStack(ModItems.wildroot)));
        registry.addRecipes(blockBreakRecipes, BLOCK_BREAK);
        ArrayList<BlockRightClickRecipe> blockRightClickRecipes = new ArrayList<BlockRightClickRecipe>();
        ArrayList<ItemStack> source = new ArrayList<ItemStack>();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, ItemStack> entry : MossConfig.getMossyCobblestones().entrySet()) {
            source.add(entry.getKey());
            result.add(entry.getValue());
        }
        blockRightClickRecipes.add(new BlockRightClickRecipe(new ItemStack(ModItems.terra_spores), result, source));
        registry.addRecipes(blockRightClickRecipes, RIGHT_CLICK_BLOCK);
        registry.addRecipes(Arrays.asList(new LootWrapper.LootRecipe(ModItems.spirit_bag, SpiritDrops.getPouch()), new LootWrapper.LootRecipe(ModItems.reliquary, SpiritDrops.getReliquary())), LOOT);
        registry.addRecipes(ModRecipes.getRunicShearRecipes().values(), RUNIC_SHEARS);
        registry.addRecipes(ModRecipes.getRunicShearEntityRecipes().values(), RUNIC_SHEARS_ENTITY);
        registry.addRecipes(ModRecipes.getPyreCraftingRecipes().values(), RITUAL_CRAFTING);
        registry.addRecipes(ModRecipes.getMortarRecipes(), MORTAR_AND_PESTLE);
        registry.addRecipes(spells, MORTAR_AND_PESTLE);
        registry.addRecipes(spells, SPELL_COSTS);
        registry.addRecipes(RitualRegistry.ritualRegistry.values(), RITUAL);
        registry.addRecipes(ModRecipes.getFeyCraftingRecipes().values(), FEY_CRAFTING);
        registry.addRecipes(spells, SPELL_IMBUING);
        registry.addRecipes(spells, SPELL_IMPOSING);
        registry.addRecipes(ModRecipes.getBarkRecipes(), BARK_CARVING);
        registry.addRecipes(MossRecipe.getRecipeList(), TERRA_MOSS);
        registry.addRecipes(ModRecipes.getSummonCreatureEntries(), SUMMON_CREATURES);
        registry.addRecipes(ModRecipes.getChrysopoeiaRecipes(), CHRYSOPOEIA);
        registry.addRecipes(ModRecipes.getTransmutationRecipes(), TRANSMUTATION);
        registry.addRecipes(Arrays.asList(RitualUtil.RunedWoodType.values()), RUNED_WOOD);
        ArrayList<PyreLightWrapper.PyreLightRecipe> pyreLightRecipes = new ArrayList<PyreLightWrapper.PyreLightRecipe>();
        if (GeneralConfig.injectFirestarter) {
            pyreLightRecipes.add(new PyreLightWrapper.PyreLightRecipe(new ItemStack(ModItems.firestarter)));
        }
        for (ItemStack item : TileEntityPyre.getFireStarters().func_193365_a()) {
            pyreLightRecipes.add(new PyreLightWrapper.PyreLightRecipe(item));
        }
        registry.addRecipes(pyreLightRecipes, PYRE_LIGHT);
        ModRecipes.generateLifeEssence();
        List list = ModRecipes.getLifeEssenceList().stream().map(SummonCreatureIntermediate::create).collect(Collectors.toList());
        registry.addRecipes(list, SUMMON_CREATURES);
        registry.addRecipes(list, RUNIC_SHEARS_SUMMON_ENTITY);
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.runic_shears), new String[]{RUNIC_SHEARS});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.runic_shears), new String[]{RUNIC_SHEARS_ENTITY});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.runic_shears), new String[]{RUNIC_SHEARS_SUMMON_ENTITY});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.ritual_summon_creatures), new String[]{SUMMON_CREATURES});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.ritual_transmutation), new String[]{TRANSMUTATION});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)Blocks.field_150329_H, 1, BlockTallGrass.EnumType.GRASS.func_177044_a()), new String[]{BLOCK_BREAK});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.terra_spores), new String[]{RIGHT_CLICK_BLOCK});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.elemental_soil), new String[]{SOIL});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.gramary), new String[]{SPELL_IMBUING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.imbuer), new String[]{SPELL_IMBUING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.staff), new String[]{SPELL_IMPOSING});
        for (Item knife : ModItems.knives) {
            ItemStack k = new ItemStack(knife);
            registry.addRecipeCatalyst((Object)k, new String[]{BARK_CARVING});
            registry.addRecipeCatalyst((Object)k, new String[]{TERRA_MOSS});
            registry.addRecipeCatalyst((Object)k, new String[]{RUNED_WOOD});
            registry.addRecipeCatalyst((Object)k, new String[]{RITUAL_VISUALISE});
        }
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.pyre), new String[]{RITUAL_CRAFTING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.reinforced_pyre), new String[]{RITUAL_CRAFTING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.mortar), new String[]{MORTAR_AND_PESTLE});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.pestle), new String[]{MORTAR_AND_PESTLE});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.pyre), new String[]{RITUAL});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.reinforced_pyre), new String[]{RITUAL});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.fey_crafter), new String[]{FEY_CRAFTING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.runic_crafter), new String[]{FEY_CRAFTING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.staff), new String[]{SPELL_COSTS});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.reliquary), new String[]{LOOT});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.imposer), new String[]{SPELL_IMPOSING});
        ItemStack spellDust = new ItemStack(ModItems.spell_dust);
        DustSpellStorage.fromStack(spellDust).setSpellToSlot(SpellChrysopoeia.instance);
        registry.addRecipeCatalyst((Object)spellDust, new String[]{CHRYSOPOEIA});
        ItemStack spellIcon = new ItemStack(ModItems.spell_icon);
        DustSpellStorage.fromStack(spellIcon).setSpellToSlot(SpellChrysopoeia.instance);
        registry.addRecipeCatalyst((Object)spellIcon, new String[]{CHRYSOPOEIA});
        for (ItemStack item : TileEntityPyre.getFireStarters().func_193365_a()) {
            registry.addRecipeCatalyst((Object)item, new String[]{PYRE_LIGHT});
        }
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.firestarter), new String[]{PYRE_LIGHT});
        registry.addIngredientInfo((Object)new ItemStack(ModBlocks.wildwood_log), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"jei.roots.wildwood.desc", (Object[])new Object[0])});
        registry.addIngredientInfo((Object)new ItemStack(ModBlocks.wildwood_sapling), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"jei.roots.wildwood_sapling.desc", (Object[])new Object[0])});
        registry.addIngredientInfo((Object)new ItemStack(ModBlocks.wildwood_leaves), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"jei.roots.wildwood_leaves.desc", (Object[])new Object[0])});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferInfo)new FeyCrafterTransfer());
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        ISubtypeRegistry.ISubtypeInterpreter spellInterpreter = itemStack -> {
            SpellBase spell;
            Item stackItem = itemStack.func_77973_b();
            if (stackItem != ModItems.spell_dust && stackItem != ModItems.spell_icon && stackItem != ModItems.staff) {
                return "";
            }
            if (stackItem == ModItems.staff) {
                StaffSpellInfo info = StaffSpellStorage.fromStack(itemStack).getSelectedInfo();
                spell = info == null ? null : info.getSpell();
            } else {
                SpellDustInfo info = (SpellDustInfo)DustSpellStorage.fromStack(itemStack).getSelectedInfo();
                SpellBase spellBase = spell = info == null ? null : info.getSpell();
            }
            if (spell != null) {
                return spell.getName();
            }
            return "";
        };
        ISubtypeRegistry.ISubtypeInterpreter modifierInterpreter = itemStack -> {
            Modifier mod;
            Item stackItem = itemStack.func_77973_b();
            if (stackItem != ModItems.spell_modifier) {
                return "";
            }
            NBTTagCompound tag = ItemUtil.getOrCreateTag((ItemStack)itemStack);
            if (tag.func_74764_b("modifier") && (mod = ModifierRegistry.get(new ResourceLocation(tag.func_74779_i("modifier")))) != null) {
                return mod.getIdentifier();
            }
            return "";
        };
        subtypeRegistry.registerSubtypeInterpreter(ModItems.spell_dust, spellInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(ModItems.spell_icon, spellInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(ModItems.staff, spellInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(ModItems.spell_modifier, modifierInterpreter);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
    }
}

