/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker.recipes;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeHooks;

public class CTTransformer {
    public static <T extends TileEntity> List<ItemStack> transformIngredients(List<IIngredient> ingredients, List<ItemStack> items, T entity) {
        ArrayList<IIngredient> postCopy = new ArrayList<IIngredient>(ingredients);
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack orig : items) {
            ItemStack item;
            IItemStack inSlot = CraftTweakerMC.getIItemStack((ItemStack)orig);
            IIngredient match = null;
            for (IIngredient ingredient : postCopy) {
                if (!ingredient.matches(inSlot)) continue;
                match = ingredient;
                break;
            }
            if (match == null || !postCopy.remove(match)) continue;
            boolean container = true;
            if (match.hasNewTransformers()) {
                IItemStack transformed;
                try {
                    transformed = match.applyNewTransform(inSlot);
                }
                catch (Throwable e) {
                    CraftTweakerAPI.logError((String)("Could not execute recipe transformer on " + match.toCommandString()), (Throwable)e);
                    continue;
                }
                result.add(CraftTweakerMC.getItemStack((IItemStack)transformed));
                container = false;
            }
            if (!container || (item = ForgeHooks.getContainerItem((ItemStack)orig)).func_190926_b()) continue;
            result.add(item);
        }
        return result;
    }

    public static <T extends TileEntity> ItemStack transformIngredient(IIngredient ingredient, ItemStack item, T entity) {
        IItemStack inSlot = CraftTweakerMC.getIItemStack((ItemStack)item);
        if (ingredient.hasNewTransformers()) {
            try {
                return CraftTweakerMC.getItemStack((IItemStack)ingredient.applyNewTransform(inSlot));
            }
            catch (Throwable e) {
                CraftTweakerAPI.logError((String)("Could not execute recipe transformer on " + ingredient.toCommandString()), (Throwable)e);
            }
        }
        return ForgeHooks.getContainerItem((ItemStack)item);
    }
}

