/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker.commands;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.recipe.AnimalHarvestFishRecipe;
import epicsquid.roots.recipe.AnimalHarvestRecipe;
import epicsquid.roots.recipe.BarkRecipe;
import epicsquid.roots.recipe.FeyCraftingRecipe;
import epicsquid.roots.recipe.FlowerRecipe;
import epicsquid.roots.recipe.MortarRecipe;
import epicsquid.roots.recipe.PacifistEntry;
import epicsquid.roots.recipe.PyreCraftingRecipe;
import epicsquid.roots.recipe.RunicShearEntityRecipe;
import epicsquid.roots.recipe.RunicShearRecipe;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandRecipes
extends CraftTweakerCommand {
    public CommandRecipes() {
        super("roots_recipes");
    }

    public List<String> getSubSubCommand(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Arrays.stream(SubCommand.values()).map(Enum::toString).collect(Collectors.toList());
    }

    protected void init() {
        this.setDescription(new ITextComponent[]{new TextComponentTranslation("roots.commands.dump_recipes.desc", new Object[0])});
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("roots.commands.dump_recipes.usage", new Object[0]));
            return;
        }
        Optional command = Enums.getIfPresent(SubCommand.class, (String)args[0]);
        if (command.isPresent()) {
            switch ((SubCommand)((Object)command.get())) {
                case all: 
                case animal_harvest: {
                    CraftTweakerAPI.logCommand((String)"Animal Harvest recipes:");
                    for (Map.Entry entry : ModRecipes.getAnimalHarvestRecipes().entrySet()) {
                        CraftTweakerAPI.logCommand((String)("  Key: " + ((ResourceLocation)entry.getKey()).toString() + " for class: " + ((AnimalHarvestRecipe)entry.getValue()).getHarvestClass().getSimpleName()));
                    }
                    CraftTweakerAPI.logCommand((String)"Animal Harvest Fish recipes:");
                    for (Map.Entry entry : ModRecipes.getAnimalHarvestFishRecipes().entrySet()) {
                        CraftTweakerAPI.logCommand((String)("  Key: " + ((ResourceLocation)entry.getKey()).toString() + " for item: " + ((AnimalHarvestFishRecipe)entry.getValue()).getItemStack().toString() + " with weight: " + ((AnimalHarvestFishRecipe)entry.getValue()).getWeight()));
                    }
                    if (command.get() == SubCommand.animal_harvest) break;
                }
                case bark: {
                    Object recipe;
                    CraftTweakerAPI.logCommand((String)"Bark recipes:");
                    for (Map.Entry entry : ModRecipes.getBarkRecipeMap().entrySet()) {
                        recipe = (BarkRecipe)entry.getValue();
                        if (((BarkRecipe)recipe).getType() == null) {
                            CraftTweakerAPI.logCommand((String)("  Modded Bark Recipe: " + ((ResourceLocation)entry.getKey()).toString() + " converting " + ((BarkRecipe)recipe).getBlockStack() + " into " + ((BarkRecipe)recipe).getBarkStack(1)));
                            continue;
                        }
                        CraftTweakerAPI.logCommand((String)("  Vanilla Bark Recipe: " + ((ResourceLocation)entry.getKey()).toString() + " converting " + ((BarkRecipe)recipe).getType().func_176610_l() + " into " + ((BarkRecipe)recipe).getBarkStack(1)));
                    }
                    if (command.get() == SubCommand.bark) break;
                }
                case fey_crafting: {
                    Object recipe;
                    CraftTweakerAPI.logCommand((String)"Fey Crafting recipes:");
                    for (Map.Entry entry : ModRecipes.getFeyCraftingRecipes().entrySet()) {
                        recipe = (FeyCraftingRecipe)entry.getValue();
                        CraftTweakerAPI.logCommand((String)("  Key: " + ((ResourceLocation)entry.getKey()).toString() + " produces " + ((FeyCraftingRecipe)recipe).getResult().toString()));
                    }
                    if (command.get() == SubCommand.fey_crafting) break;
                }
                case flower_growth: {
                    Object recipe;
                    CraftTweakerAPI.logCommand((String)"Flower Growth recipes:");
                    for (Map.Entry entry : ModRecipes.getFlowerRecipes().entrySet()) {
                        recipe = (FlowerRecipe)entry.getValue();
                        CraftTweakerAPI.logCommand((String)("  Key: " + ((ResourceLocation)entry.getKey()).toString() + " linked to: " + ((FlowerRecipe)recipe).getFlower().toString()));
                    }
                    if (command.get() == SubCommand.flower_growth) break;
                }
                case mortar: {
                    CraftTweakerAPI.logCommand((String)"Mortar recipes: ");
                    for (MortarRecipe mortarRecipe : ModRecipes.getMortarRecipes()) {
                        CraftTweakerAPI.logCommand((String)("  Result: " + mortarRecipe.getResult().toString()));
                    }
                    if (command.get() == SubCommand.mortar) break;
                }
                case pacifist: {
                    CraftTweakerAPI.logCommand((String)"Pacifist recipes:");
                    for (Map.Entry entry : ModRecipes.getPacifistEntities().entrySet()) {
                        CraftTweakerAPI.logCommand((String)("  Key: " + ((ResourceLocation)entry.getKey()).toString() + " for class: " + ((PacifistEntry)entry.getValue()).getEntityClass().getSimpleName()));
                    }
                    if (command.get() == SubCommand.pacifist) break;
                }
                case pyre_crafting: {
                    CraftTweakerAPI.logCommand((String)"Pyre Crafting recipes:");
                    for (Map.Entry entry : ModRecipes.getPyreCraftingRecipes().entrySet()) {
                        CraftTweakerAPI.logCommand((String)("  Key: roots:" + entry.getKey() + " with output: " + ((PyreCraftingRecipe)entry.getValue()).getResult().toString()));
                    }
                    if (command.get() == SubCommand.pyre_crafting) break;
                }
                case runic_shears: {
                    CraftTweakerAPI.logCommand((String)"Runic Shears recipes:");
                    for (Map.Entry entry : ModRecipes.getRunicShearRecipes().entrySet()) {
                        CraftTweakerAPI.logCommand((String)("  Key: " + ((ResourceLocation)entry.getKey()).toString() + " with the result of " + ((RunicShearRecipe)entry.getValue()).getDrop().toString()));
                    }
                    CraftTweakerAPI.logCommand((String)"Runic Shears Entity recipes:");
                    for (Map.Entry entry : ModRecipes.getRunicShearEntityRecipes().entrySet()) {
                        CraftTweakerAPI.logCommand((String)("  Key: " + ((ResourceLocation)entry.getKey()).toString() + " with the result of " + ((RunicShearEntityRecipe)entry.getValue()).getDrop().toString() + " for entity with class: " + ((RunicShearEntityRecipe)entry.getValue()).getClazz().getSimpleName()));
                    }
                    if (command.get() == SubCommand.runic_shears) break;
                }
                case life_essence: {
                    CraftTweakerAPI.logCommand((String)"Life Essence reipes:");
                    for (Class clazz : ModRecipes.getLifeEssenceList()) {
                        CraftTweakerAPI.logCommand((String)("  Entity: " + clazz.getSimpleName()));
                    }
                    if (command.get() != SubCommand.life_essence) break;
                }
            }
            sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog((String)"Dumped to CraftTweaker log.", (ICommandSender)sender));
        }
    }

    private static enum SubCommand {
        all,
        animal_harvest,
        bark,
        fey_crafting,
        flower_growth,
        mortar,
        pacifist,
        pyre_crafting,
        runic_shears,
        life_essence;

    }
}

