/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker.commands;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import epicsquid.roots.properties.Property;
import epicsquid.roots.properties.PropertyTable;
import epicsquid.roots.recipe.SpiritDrops;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.RitualRegistry;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandProperties
extends CraftTweakerCommand {
    public CommandProperties() {
        super("roots_properties");
    }

    protected void init() {
        this.setDescription(new ITextComponent[]{new TextComponentTranslation("roots.commands.dump.desc", new Object[0])});
    }

    public List<String> getSubSubCommand(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Arrays.stream(SubCommand.values()).map(Enum::toString).collect(Collectors.toList());
    }

    private void logProperty(Map.Entry<String, Property<?>> entry) {
        String propName = entry.getKey();
        Property<?> property = entry.getValue();
        String propType = property.getType().toString();
        String desc = property.getDescription();
        switch (propName) {
            case "duration": {
                desc = "duration of ritual or spell";
                break;
            }
            case "radius_x": {
                desc = "X-axis radius of ritual or spell";
                break;
            }
            case "radius_y": {
                desc = "Y-axis radius of ritual or spell";
                break;
            }
            case "radius_z": {
                desc = "Z-axis radius of ritual or spell";
                break;
            }
            case "interval": {
                desc = "frequency (in ticks) that ritual activates";
                break;
            }
            case "cast_type": {
                return;
            }
            case "cooldown": {
                desc = "cooldown(in ticks) before spell can be used again";
                break;
            }
            case "cost_0": {
                desc = "first spell herb cost";
                break;
            }
            case "cost_1": {
                desc = "second herb spell cost";
                break;
            }
            case "damage": {
                desc = "the amount of damage done by ritual or spell";
                break;
            }
        }
        CraftTweakerAPI.logCommand((String)("  - Property: " + propName + " (type: " + propType + "), default value: " + property.getDefaultValue() + ": " + desc));
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("roots.commands.dump.usage", new Object[0]));
            return;
        }
        Optional command = Enums.getIfPresent(SubCommand.class, (String)args[0]);
        if (command.isPresent()) {
            switch ((SubCommand)((Object)command.get())) {
                case all: 
                case ritual: {
                    PropertyTable props;
                    String name;
                    for (Map.Entry<String, Object> entry : RitualRegistry.ritualRegistry.entrySet()) {
                        name = entry.getKey();
                        RitualBase ritual = (RitualBase)entry.getValue();
                        props = ritual.getProperties();
                        CraftTweakerAPI.logCommand((String)("Ritual: " + name));
                        props.forEach(this::logProperty);
                        CraftTweakerAPI.logCommand((String)"----------");
                    }
                    if (command.get() == SubCommand.ritual) break;
                }
                case spell: {
                    PropertyTable props;
                    String name;
                    for (Map.Entry<String, Object> entry : SpellRegistry.spellRegistry.entrySet()) {
                        name = ((ResourceLocation)entry.getKey()).func_110623_a();
                        SpellBase spell = (SpellBase)entry.getValue();
                        props = spell.getProperties();
                        CraftTweakerAPI.logCommand((String)("Spell: " + name));
                        props.forEach(this::logProperty);
                        CraftTweakerAPI.logCommand((String)"----------");
                    }
                    if (command.get() == SubCommand.spell) break;
                }
                case spirit_drops: {
                    CraftTweakerAPI.logCommand((String)"Pouch:");
                    SpiritDrops.getPouch().forEach(el -> CraftTweakerAPI.logCommand((String)("\t-" + el.getItem().func_82833_r())));
                    CraftTweakerAPI.logCommand((String)"----------");
                    CraftTweakerAPI.logCommand((String)"Reliquary:");
                    SpiritDrops.getReliquary().forEach(el -> CraftTweakerAPI.logCommand((String)("\t-" + el.getItem().func_82833_r())));
                    CraftTweakerAPI.logCommand((String)"----------");
                    if (command.get() != SubCommand.spirit_drops) break;
                }
            }
            sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog((String)"Dumped to CraftTweaker log.", (ICommandSender)sender));
        }
    }

    private static enum SubCommand {
        all,
        ritual,
        spell,
        spirit_drops;

    }
}

