/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import epicsquid.roots.integration.crafttweaker.Costs;
import epicsquid.roots.integration.crafttweaker.Herbs;
import epicsquid.roots.properties.Property;
import epicsquid.roots.properties.PropertyTable;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.zen.ZenDocAppend;
import epicsquid.roots.util.zen.ZenDocArg;
import epicsquid.roots.util.zen.ZenDocClass;
import epicsquid.roots.util.zen.ZenDocMethod;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.roots.Spell")
@ZenDocAppend(value={"docs/include/spell.example.md"})
@ZenDocClass(value="mods.roots.Spell")
public class Spell {
    private final SpellBase original;

    public Spell(SpellBase original) {
        this.original = original;
    }

    public SpellBase getOriginal() {
        return this.original;
    }

    public <T> Spell set(String propertyName, T value) {
        PropertyTable table = this.original.getProperties();
        try {
            Property<T> prop = table.get(propertyName, value);
            table.set(prop, value);
        }
        catch (ClassCastException error) {
            CraftTweakerAPI.logError((String)("Invalid type for property '" + propertyName + "' for Spell " + this.original.getName()), (Throwable)error);
        }
        return this;
    }

    @ZenMethod
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="propertyName", info="the name of the property (must be a double)"), @ZenDocArg(arg="value", info="the value to be inserted for this property (must be a double)")}, description={"If the property is not of the double type, an error will occur."})
    public Spell setDouble(String propertyName, double value) {
        return this.set(propertyName, value);
    }

    @ZenMethod
    @ZenDocMethod(order=2, args={@ZenDocArg(arg="propertyName", info="the name of the property (must be a float)"), @ZenDocArg(arg="value", info="the value to be inserted for this property (must be a float)")}, description={"If the property is not of the float type, an error will occur."})
    public Spell setFloat(String propertyName, float value) {
        return this.set(propertyName, Float.valueOf(value));
    }

    @ZenMethod
    @ZenDocMethod(order=3, args={@ZenDocArg(arg="propertyName", info="the name of the property (must be a integer)"), @ZenDocArg(arg="value", info="the value to be inserted for this property (must be a integer)")}, description={"If the property is not of the integer type, an error will occur."})
    public Spell setInteger(String propertyName, int value) {
        return this.set(propertyName, value);
    }

    @ZenMethod
    @ZenDocMethod(order=4, args={@ZenDocArg(arg="propertyName", info="the name of the property (must be a string)"), @ZenDocArg(arg="value", info="the value to be inserted for this property (must be a string)")}, description={"If the property is not of the string type, an error will occur."})
    public Spell setString(String propertyName, String value) {
        return this.set(propertyName, value);
    }

    @ZenMethod
    @ZenDocMethod(order=5, args={@ZenDocArg(arg="value", info="the new spell cooldown (as an integer in ticks)")})
    public Spell setCooldown(int value) {
        return this.set("cooldown", value);
    }

    @ZenMethod
    @ZenDocMethod(order=6, args={@ZenDocArg(arg="value", info="the new damage of the spell")}, description={"If the spell does not have a damage property, an error will occur. Consult /roots spells."})
    public Spell setDamage(float value) {
        return this.set("damage", Float.valueOf(value));
    }

    @ZenMethod
    @ZenDocMethod(order=7, args={@ZenDocArg(arg="herb", info="the static herb reference found in Herbs (must be an existing cost)"), @ZenDocArg(arg="amount", info="the double value of the new cost for this herb")}, description={"This cannot be used to add a new cost to a spell, only to modify an existing cost."})
    public Spell setCost(Herbs.Herb herb, double amount) {
        PropertyTable props = this.original.getProperties();
        try {
            Property prop = props.get("cost_" + herb.getHerbName());
            if (prop == null) {
                CraftTweakerAPI.logError((String)("Invalid spell cost " + herb.getHerbName() + " for Spell " + this.original.getName() + ": this is not an existing cost."));
                return this;
            }
            SpellBase.SpellCost newCost = new SpellBase.SpellCost(herb.getHerbName(), amount);
            props.set(prop, newCost);
        }
        catch (ClassCastException error) {
            CraftTweakerAPI.logError((String)("Invalid spell cost " + herb.getHerbName() + " for Spell " + this.original.getName() + ". Additional costs cannot be added at this time."), (Throwable)error);
        }
        return this;
    }

    @ZenMethod
    @ZenDocMethod(order=8, args={@ZenDocArg(arg="cost", info="the static cost type found in Costs (must be an existing cost)"), @ZenDocArg(arg="herb", info="the static herb reference found in Herbs (must be an existing modifier cost)"), @ZenDocArg(arg="amount", info="the double value of the new cost for this combination of cost type and herb")}, description={"This cannot be used to add a new cost to a spell's modifier, only to modify an existing cost."})
    public Spell setModifierCost(Costs.Cost cost, Herbs.Herb herb, double value) {
        PropertyTable props = this.original.getProperties();
        try {
            Property prop = props.get(herb.getHerbName() + "_" + cost.getCostName());
            if (prop == null) {
                CraftTweakerAPI.logError((String)("Invalid modifier cost " + herb.getHerbName() + " with cost type " + cost.getCostName() + ": there is no existing cost for this combination of herb and cost."));
                return this;
            }
            SpellBase.ModifierCost newCost = new SpellBase.ModifierCost(herb.getOriginal(), cost.getOriginal(), value);
            props.set(prop, newCost);
        }
        catch (ClassCastException error) {
            CraftTweakerAPI.logError((String)("Invalid modifier cost " + herb.getHerbName() + " with cost type " + cost.getCostName() + ": there is no existing cost for this combination of herb and cost. Resulted in error: "), (Throwable)error);
        }
        return this;
    }
}

