/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.entity.spell;

import epicsquid.mysticallib.util.Util;
import epicsquid.roots.entity.spell.EntityIcicle;
import epicsquid.roots.entity.spell.EntitySpellModifiable;
import epicsquid.roots.init.ModDamage;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.spell.SpellWildfire;
import epicsquid.roots.util.EntityUtil;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class EntityFireJet
extends EntitySpellModifiable<SpellWildfire> {
    protected static final DataParameter<Integer> color = EntityDataManager.func_187226_a(EntityFireJet.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final float[] redColor = new float[]{1.0f, 0.3764706f, 0.1254902f, 0.5f};
    private static final float[] purpleColor = new float[]{0.83137256f, 0.043137256f, 0.2901961f, 0.5f};
    private static final float[] greenColor = new float[]{0.5803922f, 0.83137256f, 0.043137256f, 0.5f};

    public EntityFireJet(World worldIn) {
        super(worldIn, SpellWildfire.instance, SpellWildfire.instance.lifetime);
        this.func_184212_Q().func_187214_a(color, (Object)0);
    }

    @Override
    public void setModifiers(StaffModifierInstanceList modifiers) {
        super.setModifiers(modifiers);
        int color = 0;
        if (modifiers.has(SpellWildfire.PURPLE)) {
            color = 1;
        } else if (modifiers.has(SpellWildfire.GREEN)) {
            color = 2;
        }
        this.func_184212_Q().func_187227_b(EntityFireJet.color, (Object)color);
        this.func_184212_Q().func_187217_b(EntityFireJet.color);
    }

    @Override
    public void func_70071_h_() {
        EntityPlayer player;
        super.func_70071_h_();
        if (this.field_70122_E && this.modifiers != null && this.modifiers.has(SpellWildfire.WILDFIRE) && !this.field_70170_p.field_72995_K) {
            this.wildFire(this.func_180425_c());
        }
        if (this.field_70170_p.field_72995_K) {
            float[] color;
            switch ((Integer)this.func_184212_Q().func_187225_a(EntityFireJet.color)) {
                default: {
                    color = redColor;
                    break;
                }
                case 1: {
                    color = purpleColor;
                    break;
                }
                case 2: {
                    color = greenColor;
                }
            }
            float offX = 0.5f * (float)Math.sin(Math.toRadians(this.field_70177_z));
            float offZ = 0.5f * (float)Math.cos(Math.toRadians(this.field_70177_z));
            ParticleUtil.spawnParticleFiery(this.field_70170_p, (float)this.field_70165_t + (float)this.field_70159_w * 2.5f + offX, (float)this.field_70163_u + 1.62f + (float)this.field_70181_x * 2.5f, (float)this.field_70161_v + (float)this.field_70179_y * 2.5f + offZ, (float)this.field_70159_w + 0.125f * (this.field_70146_Z.nextFloat() - 0.5f), (float)this.field_70181_x + 0.125f * (this.field_70146_Z.nextFloat() - 0.5f), (float)this.field_70179_y + 0.125f * (this.field_70146_Z.nextFloat() - 0.5f), color, 7.5f, 24);
        } else if (this.playerId != null && (player = this.field_70170_p.func_152378_a(this.playerId)) != null) {
            Vec3d lookVec = player.func_70040_Z();
            this.field_70165_t = player.field_70165_t;
            this.field_70163_u = player.field_70163_u;
            this.field_70161_v = player.field_70161_v;
            this.field_70159_w = (float)lookVec.field_72450_a * 0.5f;
            this.field_70181_x = (float)lookVec.field_72448_b * 0.5f;
            this.field_70179_y = (float)lookVec.field_72449_c * 0.5f;
            this.field_70177_z = -90.0f - player.field_70177_z;
            for (float i = 0.0f; i < 3.0f; i += 1.0f) {
                float vx = (float)lookVec.field_72450_a * 3.0f;
                float vy = (float)lookVec.field_72448_b * 3.0f;
                float vz = (float)lookVec.field_72449_c * 3.0f;
                List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t + (double)(vx * i) - 1.5, this.field_70163_u + (double)(vy * i) - 1.5, this.field_70161_v + (double)(vz * i) - 1.5, this.field_70165_t + (double)(vx * i) + 1.5, this.field_70163_u + (double)(vy * i) + 1.5, this.field_70161_v + (double)(vz * i) + 1.5));
                boolean hit = false;
                for (EntityLivingBase entity : entities) {
                    if (entity == player || entity instanceof EntityPlayer && !FMLCommonHandler.instance().getMinecraftServerInstance().func_71219_W() || this.modifiers == null || this.modifiers.has(SpellWildfire.PEACEFUL) && EntityUtil.isFriendly((Entity)entity, SpellWildfire.instance)) continue;
                    hit = true;
                    entity.func_70015_d(((SpellWildfire)this.instance).fire_duration);
                    entity.func_70097_a(ModDamage.fireDamageFrom((Entity)player), ((SpellWildfire)this.instance).damage);
                    if (this.modifiers.has(SpellWildfire.WEAKNESS)) {
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, ((SpellWildfire)this.instance).weakness_duration, ((SpellWildfire)this.instance).weakness_amplifier));
                    }
                    if (this.modifiers.has(SpellWildfire.SLOW)) {
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, ((SpellWildfire)this.instance).slow_duration, ((SpellWildfire)this.instance).slow_amplifier));
                    }
                    if (this.modifiers.has(SpellWildfire.LEVITATE)) {
                        entity.func_70690_d(new PotionEffect(MobEffects.field_188424_y, ((SpellWildfire)this.instance).levitate_duration, 0));
                    }
                    if (this.modifiers.has(SpellWildfire.POISON)) {
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, ((SpellWildfire)this.instance).poison_duration, ((SpellWildfire)this.instance).poison_amplifier));
                    }
                    if (this.modifiers.has(SpellWildfire.ICICLES)) {
                        int count = ((SpellWildfire)this.instance).icicle_count;
                        Vec3d pos = entity.func_174791_d();
                        Vec3d playerPos = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
                        Vec3d accel = pos.func_178788_d(playerPos);
                        for (int k = 0; k < count; ++k) {
                            EntityIcicle icicle = new EntityIcicle(this.field_70170_p, (EntityLivingBase)player, accel.field_72450_a, accel.field_72448_b, accel.field_72449_c, EntityIcicle.SpellType.WILDFIRE);
                            icicle.field_70165_t = playerPos.field_72450_a;
                            icicle.field_70163_u = playerPos.field_72448_b + Util.rand.nextDouble() - 0.5;
                            icicle.field_70161_v = playerPos.field_72449_c;
                            icicle.setModifiers(this.modifiers);
                            this.field_70170_p.func_72838_d((Entity)icicle);
                        }
                    }
                    if (!this.modifiers.has(SpellWildfire.WILDFIRE)) continue;
                    this.wildFire(entity.func_180425_c());
                }
            }
        }
    }

    private void wildFire(BlockPos center) {
        IBlockState state = this.field_70170_p.func_180495_p(center);
        if (this.field_70170_p.func_175623_d(center) || state.func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, center)) {
            for (int x = 4; (this.field_70170_p.func_175623_d(center.func_177977_b()) || state.func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, center)) && x >= 0; --x) {
                center = center.func_177977_b();
                state = this.field_70170_p.func_180495_p(center);
            }
            if (this.field_70170_p.func_175623_d(center) || state.func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, center)) {
                this.field_70170_p.func_175656_a(center.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
            }
        }
    }
}

