/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.entity.ritual;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.roots.entity.ritual.EntityRitualBase;
import epicsquid.roots.mechanics.Growth;
import epicsquid.roots.network.fx.MessageRampantLifeInfusionFX;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.ritual.RitualGermination;
import epicsquid.roots.ritual.RitualRegistry;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityRitualGermination
extends EntityRitualBase {
    private RitualGermination ritual;

    public EntityRitualGermination(World worldIn) {
        super(worldIn);
        this.func_184212_Q().func_187214_a(lifetime, (Object)(RitualRegistry.ritual_germination.getDuration() + 20));
        this.ritual = (RitualGermination)RitualRegistry.ritual_germination;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        float alpha = (float)Math.min(40, RitualRegistry.ritual_healing_aura.getDuration() + 20 - (Integer)this.func_184212_Q().func_187225_a(lifetime)) / 40.0f;
        if (this.field_70170_p.field_72995_K && (Integer)this.func_184212_Q().func_187225_a(lifetime) > 0) {
            ParticleUtil.spawnParticleStar(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 0.0f, 0.0f, 0.0f, 100.0f, 255.0f, 100.0f, 0.5f * alpha, 20.0f, 40);
            if (this.field_70146_Z.nextInt(5) == 0) {
                ParticleUtil.spawnParticleSpark(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 0.125f * (this.field_70146_Z.nextFloat() - 0.5f), 0.0625f * this.field_70146_Z.nextFloat(), 0.125f * (this.field_70146_Z.nextFloat() - 0.5f), 100.0f, 255.0f, 100.0f, 1.0f * alpha, 1.0f + this.field_70146_Z.nextFloat(), 160);
            }
            for (float i = 0.0f; i < 360.0f; i += 72.0f) {
                double ang = this.field_70173_aa % 360;
                float tx = (float)this.field_70165_t + 1.0f * (float)Math.sin(Math.toRadians((double)i + ang));
                float ty = (float)this.field_70163_u;
                float tz = (float)this.field_70161_v + 1.0f * (float)Math.cos(Math.toRadians((double)i + ang));
                ParticleUtil.spawnParticleGlow(this.field_70170_p, tx, ty, tz, 0.0f, 0.0f, 0.0f, 100.0f, 255.0f, 100.0f, 0.5f * alpha, 8.0f, 40);
            }
        }
        if (this.field_70173_aa % this.ritual.interval == 0) {
            List<BlockPos> positions = Growth.collect(this.field_70170_p, this.func_180425_c(), this.ritual.radius_x, this.ritual.radius_y, this.ritual.radius_z);
            if (positions.isEmpty()) {
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                for (int i = 0; i < this.ritual.count; ++i) {
                    BlockPos pos = positions.get(this.field_70170_p.field_73012_v.nextInt(positions.size()));
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    int x = this.ritual.bonus_ticks;
                    if (state.func_177230_c() == Blocks.field_150436_aH || state.func_177230_c() == Blocks.field_150434_aF) {
                        x += this.ritual.crop_ticks;
                    }
                    for (int j = 0; j < this.ritual.ticks + x; ++j) {
                        state.func_177230_c().func_180645_a(this.field_70170_p, pos, state, this.field_70170_p.field_73012_v);
                    }
                    PacketHandler.sendToAllTracking((IMessage)new MessageRampantLifeInfusionFX(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), (Entity)this);
                }
            }
        }
    }
}

