/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.config;

import epicsquid.roots.Roots;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Config.LangKey(value="config.roots.category.tools")
@Config(modid="roots", name="roots/tools", category="tools")
public class ToolConfig {
    @Config.Comment(value={"Terrastone Pickaxe speed modifier for soft materials (set to 1 to disable)"})
    @Config.RangeDouble(min=0.0)
    public static double PickaxeSoftModifier = 0.8;
    @Config.Comment(value={"Terrastone Pickaxe speed modifier for hard materials (set to 1 to disable)"})
    @Config.RangeDouble(min=0.0)
    public static double PickaxeHardModifier = 2.8;
    @Config.Comment(value={"Terrastone Axe instantly breaks leaves"})
    public static boolean AxeLeaves = true;
    @Config.Comment(value={"Terrastone Shovel has silk touch on grass, mycelium and podzol by default"})
    public static boolean ShovelSilkTouch = true;
    @Config.Comment(value={"Terrastone Sword instantly breaks cobwebs"})
    public static boolean SwordCobwebBreak = true;
    @Config.Comment(value={"Terrastone Sword silk-touches cobwebs"})
    public static boolean SwordSilkTouch = true;
    @Config.Comment(value={"Terrastone Hoe automatically moisturises created farmland"})
    public static boolean HoeMoisturises = true;
    @Config.Comment(value={"Terrastone Hoe acts like Shears when used on Leaves, etc"})
    public static boolean HoeSilkTouch = true;
    @Config.Comment(value={"List of blocks in the format of modid:blockid that won't be harvested by runic tools"})
    public static String[] RunicBlockBlacklist = new String[]{"minecraft:bedrock"};
    @Config.Ignore
    private static Set<Block> runicBlockBlacklist = null;

    public static Set<Block> getRunicBlockBlacklist() {
        if (runicBlockBlacklist == null) {
            runicBlockBlacklist = new HashSet<Block>();
            for (String s : RunicBlockBlacklist) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
                if (block != null) {
                    runicBlockBlacklist.add(block);
                    continue;
                }
                Roots.logger.error("Invalid block specified in Runic Block Blacklist configuration: " + s + " does not exist.");
            }
        }
        return runicBlockBlacklist;
    }
}

