/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.command;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.RayCastUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.Roots;
import epicsquid.roots.block.groves.BlockGroveStone;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.modifiers.IModifier;
import epicsquid.roots.network.MessageClearToasts;
import epicsquid.roots.properties.Property;
import epicsquid.roots.properties.PropertyTable;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.RitualRegistry;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellRegistry;
import epicsquid.roots.spell.info.LibrarySpellInfo;
import epicsquid.roots.util.SlaveUtil;
import epicsquid.roots.world.data.SpellLibraryData;
import epicsquid.roots.world.data.SpellLibraryRegistry;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommandRoots
extends CommandBase {
    public String func_71517_b() {
        return "roots";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/roots book | /roots activate | /roots rituals | /roots growables | /roots spells | /roots library | /roots modifiers | /roots slave";
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("roots");
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (sender instanceof EntityPlayerMP) {
            if (args.length == 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
            } else {
                EntityPlayerMP player = (EntityPlayerMP)sender;
                WorldServer world = player.func_71121_q();
                if (args[0].equalsIgnoreCase("slave")) {
                    Entity target = RayCastUtil.mouseOverEntity((EntityLivingBase)player);
                    if (SlaveUtil.canBecomeSlave(target) || SlaveUtil.isSlave(target)) {
                        EntityLivingBase parent = (EntityLivingBase)target;
                        EntityLivingBase slave = SlaveUtil.canBecomeSlave(target) ? SlaveUtil.enslave(parent) : SlaveUtil.revert(parent);
                        world.func_72838_d((Entity)slave);
                        parent.func_184174_b(false);
                        parent.func_70106_y();
                        slave.func_70634_a(slave.field_70165_t, slave.field_70163_u, slave.field_70161_v);
                    }
                } else if (args[0].equalsIgnoreCase("modifiers")) {
                    ArrayList<String> modifierList = new ArrayList<String>();
                    for (SpellBase spell : SpellRegistry.spellRegistry.values()) {
                        for (IModifier iModifier : spell.getModifiers()) {
                            modifierList.add(iModifier.getTranslationKey());
                            modifierList.add(iModifier.getTranslationKey() + ".desc");
                        }
                    }
                    Path path = Paths.get("roots.log", new String[0]);
                    try {
                        Files.write(path, modifierList, StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
                    }
                    catch (IOException e) {
                        player.func_145747_a((ITextComponent)new TextComponentString("Unable to write roots.log"));
                        return;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString("Modifiers written to roots.log"));
                } else if (args[0].equalsIgnoreCase("library")) {
                    if (args.length == 2 && args[1].equals("fill") || args[1].equals("all")) {
                        SpellLibraryData library = SpellLibraryRegistry.getData((EntityPlayer)player);
                        for (SpellBase spell : SpellRegistry.getSpells()) {
                            library.addSpell(spell);
                        }
                    } else if (args.length == 2 && (args[1].equals("kill") || args[1].equals("clear"))) {
                        SpellLibraryRegistry.clearData((EntityPlayer)player);
                    } else {
                        SpellLibraryData data = SpellLibraryRegistry.getData((EntityPlayer)player);
                        for (LibrarySpellInfo info : data) {
                            if (!info.isObtained()) continue;
                            player.func_145747_a((ITextComponent)new TextComponentString("Obtained: " + info.getNonNullSpell().getRegistryName()));
                        }
                        for (LibrarySpellInfo info : data) {
                            if (info.isObtained()) continue;
                            player.func_145747_a((ITextComponent)new TextComponentString("Unobtained: " + info.getNonNullSpell().getRegistryName()));
                        }
                    }
                } else if (args[0].equalsIgnoreCase("activate")) {
                    List positions = Util.getBlocksWithinRadius((World)world, (BlockPos)sender.func_180425_c(), (float)50.0f, (float)50.0f, (float)50.0f, (Block)ModBlocks.grove_stone);
                    for (BlockPos pos : positions) {
                        IBlockState state = world.func_180495_p(pos);
                        if (state.func_177230_c() != ModBlocks.grove_stone || ((Boolean)state.func_177229_b((IProperty)BlockGroveStone.VALID)).booleanValue()) continue;
                        world.func_175656_a(pos, state.func_177226_a((IProperty)BlockGroveStone.VALID, (Comparable)Boolean.valueOf(true)));
                    }
                } else if (args[0].equalsIgnoreCase("book")) {
                    AdvancementManager manager = world.func_191952_z();
                    PlayerAdvancements advancements = player.func_192039_O();
                    for (Advancement adv : manager.func_192780_b()) {
                        ResourceLocation resourceLocation = adv.func_192067_g();
                        if (!resourceLocation.func_110624_b().equals("roots")) continue;
                        AdvancementProgress progress = advancements.func_192747_a(adv);
                        for (String criterion : progress.func_192107_d()) {
                            progress.func_192109_a(criterion);
                        }
                        adv.func_192072_d().func_192113_a(player);
                    }
                    advancements.func_192749_b();
                    advancements.func_192741_b(player);
                    MessageClearToasts message = new MessageClearToasts();
                    PacketHandler.INSTANCE.sendTo((IMessage)message, player);
                    Item guide = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("patchouli", "guide_book"));
                    ItemStack itemStack = new ItemStack(guide);
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74778_a("patchouli:book", "roots:roots_guide");
                    itemStack.func_77982_d(tag);
                    if (!player.func_191521_c(itemStack)) {
                        ItemUtil.spawnItem((World)world, (BlockPos)player.func_180425_c(), (ItemStack)itemStack);
                    }
                } else if (args[0].equalsIgnoreCase("growables")) {
                    ArrayList<String> growablesList = new ArrayList<String>();
                    for (Block block : Block.field_149771_c) {
                        if (!(block instanceof IGrowable)) continue;
                        growablesList.add(block.getRegistryName().toString());
                    }
                    Path path = Paths.get("roots.log", new String[0]);
                    try {
                        Files.write(path, growablesList, StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
                    }
                    catch (IOException e) {
                        player.func_145747_a((ITextComponent)new TextComponentString("Unable to write roots.log"));
                        return;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString("Growables written to roots.log"));
                } else if (args[0].equalsIgnoreCase("rituals")) {
                    ArrayList<String> rituals = new ArrayList<String>();
                    for (RitualBase ritual : RitualRegistry.getRituals()) {
                        PropertyTable table = ritual.getProperties();
                        rituals.add("Ritual: " + ritual.getName() + (ritual.isDisabled() ? " (disabled)" : ""));
                        for (Property<?> prop : table.getProperties()) {
                            rituals.add("    Property: " + prop.getName());
                            if (prop.hasDefaultValue()) {
                                rituals.add("        Default: " + prop.getDefaultValue());
                            }
                            rituals.add("        Description: " + prop.getDescription());
                            rituals.add("        Type: " + prop.getType().getSimpleName());
                            rituals.add("        Value: " + table.get(prop));
                            rituals.add("");
                        }
                    }
                    Path path = Paths.get("roots.log", new String[0]);
                    try {
                        Files.write(path, rituals, StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
                    }
                    catch (IOException e) {
                        player.func_145747_a((ITextComponent)new TextComponentString("Unable to write roots.log"));
                        Roots.logger.error("Unable to write to roots.log: ", (Throwable)e);
                        return;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString("Rituals written to roots.log"));
                } else if (args[0].equalsIgnoreCase("spells")) {
                    ArrayList<String> spells = new ArrayList<String>();
                    for (SpellBase spell : SpellRegistry.getSpells()) {
                        PropertyTable table = spell.getProperties();
                        spells.add("Spell: " + spell.getName() + (spell.isDisabled() ? " (disabled)" : ""));
                        for (Property<?> prop : table.getProperties()) {
                            if (prop.getType().equals(SpellBase.EnumCastType.class)) continue;
                            spells.add("    Property: " + prop.getName());
                            if (prop.hasDefaultValue()) {
                                spells.add("        Default: " + prop.getDefaultValue());
                            }
                            spells.add("        Description: " + prop.getDescription());
                            spells.add("        Type: " + prop.getType().getSimpleName());
                            spells.add("        Value: " + table.get(prop));
                            spells.add("");
                        }
                    }
                    Path path = Paths.get("roots.log", new String[0]);
                    try {
                        Files.write(path, spells, StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
                    }
                    catch (IOException e) {
                        player.func_145747_a((ITextComponent)new TextComponentString("Unable to write roots.log"));
                        return;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString("Spells written to roots.log"));
                }
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Command must be run by a player."));
        }
    }

    private static boolean isModApplicable(String qualifiedClassName, String name) {
        return Loader.isModLoaded((String)name.toLowerCase()) && qualifiedClassName.toLowerCase().contains(name.toLowerCase());
    }
}

