/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.block;

import com.google.common.collect.Lists;
import epicsquid.mysticallib.LibRegistry;
import epicsquid.mysticallib.block.BlockBase;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.api.CustomPlantType;
import epicsquid.roots.config.GeneralConfig;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.item.itemblock.ItemBlockElementalSoil;
import epicsquid.roots.mechanics.Harvest;
import epicsquid.roots.util.EnumElementalSoilType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockElementalSoil
extends BlockBase {
    public static final PropertyInteger WATER_SPEED = PropertyInteger.func_177719_a((String)"water", (int)0, (int)4);
    public static final PropertyInteger AIR_SPEED = PropertyInteger.func_177719_a((String)"air", (int)0, (int)4);
    public static final PropertyInteger EARTH_FERTILITY = PropertyInteger.func_177719_a((String)"earth", (int)0, (int)4);
    public static final PropertyInteger FIRE_MULTIPLIER = PropertyInteger.func_177719_a((String)"fire", (int)0, (int)4);
    @Nonnull
    private final Item itemBlock;
    private EnumElementalSoilType soilType;
    public static EnumElementalSoilType SOIL_INIT = EnumElementalSoilType.BASE;

    public BlockElementalSoil(@Nonnull Material mat, @Nonnull SoundType type, @Nonnull String name, @Nonnull EnumElementalSoilType soilType) {
        super(mat, type, 0.8f, name);
        this.soilType = soilType;
        this.itemBlock = (Item)new ItemBlockElementalSoil((Block)this).setRegistryName(LibRegistry.getActiveModid(), name);
        this.setHarvestReqs("shovel", 0);
        this.func_149675_a(true);
        if (this.soilType != EnumElementalSoilType.BASE) {
            PropertyInteger property = this.soilType == EnumElementalSoilType.WATER ? WATER_SPEED : (this.soilType == EnumElementalSoilType.EARTH ? EARTH_FERTILITY : (this.soilType == EnumElementalSoilType.AIR ? AIR_SPEED : FIRE_MULTIPLIER));
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)property, (Comparable)Integer.valueOf(1)));
        }
    }

    public void doHarvest(BlockEvent.CropGrowEvent.Post cropGrowEvent) {
        BlockPos pos = cropGrowEvent.getPos();
        IBlockState soil = cropGrowEvent.getWorld().func_180495_p(pos.func_177977_b());
        IBlockState plant = cropGrowEvent.getWorld().func_180495_p(pos);
        World world = cropGrowEvent.getWorld();
        this.doHarvest(world, pos, soil, plant);
        world.func_175684_a(pos, (Block)this, 30);
    }

    private boolean shouldHarvest(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b().func_177977_b()).func_177230_c() != Blocks.field_150351_n;
    }

    private void doHarvest(World world, BlockPos pos, IBlockState soil, IBlockState plant) {
        int speed;
        if (soil.func_177230_c() != ModBlocks.elemental_soil_water) {
            return;
        }
        if (this.shouldHarvest(world, pos) && plant.func_177230_c() instanceof IPlantable && Harvest.isGrown(plant) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)plant.func_177230_c()) && soil.func_177230_c() == ModBlocks.elemental_soil_water && (speed = ((Integer)soil.func_177229_b((IProperty)WATER_SPEED)).intValue()) > 0) {
            List<ItemStack> drops = Harvest.harvestReturnDrops(plant, pos, world, null);
            this.handleDrops(world, pos, drops);
        }
    }

    private void handleDrops(World world, BlockPos pos, List<ItemStack> drops) {
        IItemHandler cap;
        ArrayList dropsList = Lists.newArrayList(drops);
        BlockPos under = pos.func_177977_b().func_177977_b();
        TileEntity te = world.func_175625_s(under);
        if (te != null && (cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            ArrayList<ItemStack> remainder = new ArrayList<ItemStack>();
            for (ItemStack next : dropsList) {
                ItemStack remains;
                if (next.func_190926_b() || (remains = ItemHandlerHelper.insertItemStacked((IItemHandler)cap, (ItemStack)next, (boolean)false)).func_190926_b()) continue;
                remainder.add(remains);
            }
            dropsList.clear();
            if (!remainder.isEmpty()) {
                dropsList.addAll(remainder);
            }
        }
        if (!dropsList.isEmpty()) {
            for (ItemStack stack : dropsList) {
                ItemUtil.spawnItem((World)world, (BlockPos)pos, (ItemStack)stack);
            }
        }
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (this.soilType == null) {
            this.soilType = SOIL_INIT;
        }
        switch (this.soilType) {
            case AIR: {
                return this.func_176223_P().func_177226_a((IProperty)AIR_SPEED, (Comparable)Integer.valueOf(meta + 1));
            }
            case FIRE: {
                return this.func_176223_P().func_177226_a((IProperty)FIRE_MULTIPLIER, (Comparable)Integer.valueOf(meta + 1));
            }
            case EARTH: {
                return this.func_176223_P().func_177226_a((IProperty)EARTH_FERTILITY, (Comparable)Integer.valueOf(meta + 1));
            }
            case WATER: {
                return this.func_176223_P().func_177226_a((IProperty)WATER_SPEED, (Comparable)Integer.valueOf(meta + 1));
            }
        }
        return this.func_176223_P();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        if (this.soilType == null) {
            this.soilType = SOIL_INIT;
        }
        switch (this.soilType) {
            case AIR: {
                return new BlockStateContainer((Block)this, new IProperty[]{AIR_SPEED});
            }
            case FIRE: {
                return new BlockStateContainer((Block)this, new IProperty[]{FIRE_MULTIPLIER});
            }
            case EARTH: {
                return new BlockStateContainer((Block)this, new IProperty[]{EARTH_FERTILITY});
            }
            case WATER: {
                return new BlockStateContainer((Block)this, new IProperty[]{WATER_SPEED});
            }
        }
        return new BlockStateContainer((Block)this, new IProperty[0]);
    }

    public int func_176201_c(IBlockState state) {
        PropertyInteger property;
        Object object = this.soilType == EnumElementalSoilType.WATER ? WATER_SPEED : (this.soilType == EnumElementalSoilType.EARTH ? EARTH_FERTILITY : (this.soilType == EnumElementalSoilType.AIR ? AIR_SPEED : (property = this.soilType == EnumElementalSoilType.BASE ? null : FIRE_MULTIPLIER)));
        if (property == null) {
            return 0;
        }
        return Math.max((Integer)state.func_177229_b((IProperty)property) - 1, 0);
    }

    public boolean canSustainPlant(@Nonnull IBlockState state, @Nonnull IBlockAccess world, BlockPos pos, @Nonnull EnumFacing direction, IPlantable plantable) {
        if (this.soilType == EnumElementalSoilType.WATER && plantable == Blocks.field_150436_aH) {
            return true;
        }
        if (plantable == Blocks.field_150434_aF) {
            return this.soilType == EnumElementalSoilType.EARTH;
        }
        EnumPlantType plant = plantable.getPlantType(world, pos.func_177972_a(direction));
        switch (plant) {
            case Nether: 
            case Cave: 
            case Crop: 
            case Desert: 
            case Plains: {
                return true;
            }
        }
        return plant == CustomPlantType.ELEMENT_FIRE || plant == CustomPlantType.ELEMENT_AIR || plant == CustomPlantType.ELEMENT_EARTH || plant == CustomPlantType.ELEMENT_WATER;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (world.func_175623_d(pos.func_177984_a())) {
            return;
        }
        IBlockState upState = world.func_180495_p(pos.func_177984_a());
        Block upBlock = upState.func_177230_c();
        this.doHarvest(world, pos.func_177984_a(), world.func_180495_p(pos), upState);
        if (!(upBlock instanceof IGrowable)) {
            return;
        }
        if (rand.nextInt(5) == 0) {
            upBlock.func_180645_a(world, pos.func_177984_a(), upState, rand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d2;
        double d1;
        double d0;
        double y_offset;
        double x_offset;
        if (GeneralConfig.DisableParticles) {
            return;
        }
        if (this.soilType == EnumElementalSoilType.FIRE && rand.nextInt(5) == 0) {
            double d8 = (double)pos.func_177958_n() + (double)rand.nextFloat();
            double d4 = (double)pos.func_177956_o() + stateIn.func_185900_c((IBlockAccess)worldIn, (BlockPos)pos).field_72337_e - (double)0.2f;
            double d6 = (double)pos.func_177952_p() + (double)rand.nextFloat();
            worldIn.func_175688_a(EnumParticleTypes.LAVA, d8, d4, d6, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.soilType == EnumElementalSoilType.WATER) {
            for (int i = 0; i < 2; ++i) {
                x_offset = Math.min(Math.max(0.05, rand.nextDouble()), 0.95);
                y_offset = Math.min(Math.max(0.05, rand.nextDouble()), 0.95);
                d0 = (double)pos.func_177958_n() + x_offset;
                d1 = (double)pos.func_177956_o() + 1.0;
                d2 = (double)pos.func_177952_p() + y_offset;
                worldIn.func_175688_a(EnumParticleTypes.WATER_SPLASH, d0, d1, d2, 0.0, 1.5, 0.0, new int[0]);
            }
        }
        if (this.soilType == EnumElementalSoilType.AIR && rand.nextInt(13) == 0) {
            for (int i = 0; i < 2; ++i) {
                x_offset = Math.min(Math.max(0.05, rand.nextDouble()), 0.95);
                y_offset = Math.min(Math.max(0.05, rand.nextDouble()), 0.95);
                d0 = (double)pos.func_177958_n() + x_offset;
                d1 = (double)pos.func_177956_o() + 0.5;
                d2 = (double)pos.func_177952_p() + y_offset;
                worldIn.func_175688_a(EnumParticleTypes.CLOUD, d0, d1, d2, 0.0, 0.05, 0.0, new int[0]);
            }
        }
        if (this.soilType == EnumElementalSoilType.EARTH && rand.nextInt(6) == 0) {
            for (int i = 0; i < 2 + rand.nextInt(3); ++i) {
                x_offset = Math.min(Math.max(0.05, rand.nextDouble()), 0.95);
                y_offset = Math.min(Math.max(0.05, rand.nextDouble()), 0.95);
                d0 = (double)pos.func_177958_n() + x_offset;
                d1 = (double)pos.func_177956_o() + 1.0;
                d2 = (double)pos.func_177952_p() + y_offset;
                worldIn.func_175688_a(EnumParticleTypes.BLOCK_CRACK, d0, d1, d2, 0.0, 1.0, 0.0, new int[]{Block.func_176210_f((IBlockState)stateIn)});
            }
        }
    }

    public Item getItemBlock() {
        return this.itemBlock;
    }

    public boolean isFertile(@Nonnull World world, @Nonnull BlockPos pos) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            Block type = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            if (type == ModBlocks.elemental_soil_fire) {
                tooltip.add("");
                tooltip.add(TextFormatting.RED + "" + TextFormatting.BOLD + I18n.func_135052_a((String)"tile.magmatic_soil.effect", (Object[])new Object[0]));
            } else if (type == ModBlocks.elemental_soil_air) {
                tooltip.add("");
                tooltip.add(TextFormatting.AQUA + "" + TextFormatting.BOLD + I18n.func_135052_a((String)"tile.caelic_soil.effect", (Object[])new Object[0]));
            } else if (type == ModBlocks.elemental_soil_earth) {
                tooltip.add("");
                tooltip.add(TextFormatting.YELLOW + "" + TextFormatting.BOLD + I18n.func_135052_a((String)"tile.terran_soil.effect", (Object[])new Object[0]));
            } else if (type == ModBlocks.elemental_soil_water) {
                tooltip.add("");
                tooltip.add(TextFormatting.BLUE + "" + TextFormatting.BOLD + I18n.func_135052_a((String)"tile.aqueous_soil.effect", (Object[])new Object[0]));
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }
}

