/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots;

import epicsquid.roots.client.gui.GuiFeyCrafter;
import epicsquid.roots.client.gui.GuiImposer;
import epicsquid.roots.client.gui.GuiLibrary;
import epicsquid.roots.client.gui.GuiPouch;
import epicsquid.roots.client.gui.GuiQuiver;
import epicsquid.roots.container.ContainerFeyCrafter;
import epicsquid.roots.container.ContainerImposer;
import epicsquid.roots.container.ContainerLibrary;
import epicsquid.roots.container.ContainerPouch;
import epicsquid.roots.container.ContainerQuiver;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.tileentity.TileEntityFeyCrafter;
import epicsquid.roots.tileentity.TileEntityImposer;
import epicsquid.roots.util.PlayerSyncUtil;
import epicsquid.roots.util.SpellUtil;
import epicsquid.roots.world.data.SpellLibraryRegistry;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class GuiHandler
implements IGuiHandler {
    public static final int POUCH_ID = 16;
    public static final int QUIVER_ID = 17;
    public static final int CRAFTER_ID = 18;
    public static final int IMPOSER_ID = 19;
    public static final int LIBRARY_ID = 20;

    @Nullable
    private static Supplier<ItemStack> getStaff(EntityPlayer player) {
        ItemStack staff = player.func_184614_ca();
        if (!staff.func_190926_b() && staff.func_77973_b().equals(ModItems.staff)) {
            return () -> ((EntityPlayer)player).func_184614_ca();
        }
        staff = player.func_184592_cb();
        if (!staff.func_190926_b() && staff.func_77973_b().equals(ModItems.staff)) {
            return () -> ((EntityPlayer)player).func_184592_cb();
        }
        return null;
    }

    @Nullable
    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        switch (id) {
            case 16: {
                return new ContainerPouch(player, true);
            }
            case 17: {
                return new ContainerQuiver(player);
            }
            case 18: {
                TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                if (te instanceof TileEntityFeyCrafter) {
                    return new ContainerFeyCrafter(player, (TileEntityFeyCrafter)te);
                }
                return null;
            }
            case 19: {
                TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                if (te instanceof TileEntityImposer) {
                    ((TileEntityImposer)te).updateInSlot(player);
                    return new ContainerImposer(player, (TileEntityImposer)te);
                }
                return null;
            }
            case 20: {
                Supplier<ItemStack> staff = GuiHandler.getStaff(player);
                if (staff != null) {
                    SpellUtil.updateModifiers(staff.get(), player);
                    PlayerSyncUtil.syncPlayer(player);
                    return new ContainerLibrary(player, staff, SpellLibraryRegistry.getData(player));
                }
                player.func_146105_b(new TextComponentTranslation("roots.message.hold_staff", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.LIGHT_PURPLE).func_150227_a(Boolean.valueOf(true))), true);
                return null;
            }
        }
        return null;
    }

    @Nullable
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        switch (id) {
            case 16: {
                return new GuiPouch(new ContainerPouch(player, false));
            }
            case 17: {
                return new GuiQuiver(new ContainerQuiver(player));
            }
            case 18: {
                TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                if (!(te instanceof TileEntityFeyCrafter)) break;
                return new GuiFeyCrafter(new ContainerFeyCrafter(player, (TileEntityFeyCrafter)te));
            }
            case 19: {
                TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                if (!(te instanceof TileEntityImposer)) break;
                return new GuiImposer(new ContainerImposer(player, (TileEntityImposer)te));
            }
            case 20: {
                Supplier<ItemStack> staff = GuiHandler.getStaff(player);
                if (staff == null) break;
                return new GuiLibrary(new ContainerLibrary(player, staff, null));
            }
        }
        return null;
    }
}

