/*
 * Decompiled with CFR 0.152.
 */
package com.teamdimensional.integratedderivative.util;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;

public class CombinedIngredientStorage
implements IIngredientComponentStorage<ItemStack, Integer> {
    private final IIngredientComponentStorage<ItemStack, Integer>[] parts;

    @SafeVarargs
    public CombinedIngredientStorage(IIngredientComponentStorage<ItemStack, Integer> ... parts) {
        this.parts = parts;
        assert (parts.length > 0);
    }

    public IngredientComponent<ItemStack, Integer> getComponent() {
        return this.parts[0].getComponent();
    }

    @Nonnull
    public Iterator<ItemStack> iterator() {
        return Iterators.concat(Arrays.stream(this.parts).map(IIngredientComponentStorage::iterator).iterator());
    }

    public Iterator<ItemStack> iterator(@Nonnull ItemStack stack, Integer m) {
        return Iterators.concat(Arrays.stream(this.parts).map(r -> r.iterator((Object)stack, (Object)m)).iterator());
    }

    public long getMaxQuantity() {
        return Arrays.stream(this.parts).mapToLong(IIngredientComponentStorage::getMaxQuantity).sum();
    }

    public ItemStack insert(@Nonnull ItemStack stack, boolean simulate) {
        for (IIngredientComponentStorage<ItemStack, Integer> part : this.parts) {
            stack = (ItemStack)part.insert((Object)stack, simulate);
        }
        return stack;
    }

    public ItemStack extract(long maxQuantity, boolean simulate) {
        for (IIngredientComponentStorage<ItemStack, Integer> part : this.parts) {
            ItemStack extracted = (ItemStack)part.extract(maxQuantity, simulate);
            if (extracted.func_190926_b()) continue;
            return extracted;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack extract(@Nonnull ItemStack stack, Integer matchCondition, boolean simulate) {
        for (IIngredientComponentStorage<ItemStack, Integer> part : this.parts) {
            ItemStack extracted = (ItemStack)part.extract((Object)stack, (Object)matchCondition, simulate);
            if (extracted.func_190926_b()) continue;
            return extracted;
        }
        return ItemStack.field_190927_a;
    }
}

