/*
 * Decompiled with CFR 0.152.
 */
package com.teamdimensional.integratedderivative.recipe;

import com.teamdimensional.integratedderivative.IntegratedDerivative;
import com.teamdimensional.integratedderivative.IntegratedDerivativeConfig;
import com.teamdimensional.integratedderivative.recipe.CopyODCChannelRecipe;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryModifiable;

@Mod.EventBusSubscriber
public class DerivativeRecipeManager {
    @SubscribeEvent
    public static void register(RegistryEvent.Register<IRecipe> event) {
        if (IntegratedDerivativeConfig.dynamicsFixes.fixODCCrafting) {
            IForgeRegistryModifiable r = (IForgeRegistryModifiable)event.getRegistry();
            ArrayList badRecipes = new ArrayList();
            ArrayList<IRecipe> newRecipes = new ArrayList<IRecipe>();
            for (Map.Entry ent : r.getEntries()) {
                IRecipe rec = (IRecipe)ent.getValue();
                if (rec.func_77571_b().func_77973_b() != CopyODCChannelRecipe.connector() || rec.func_77571_b().func_190916_E() <= 1) continue;
                boolean foundInput = false;
                for (Ingredient ing : rec.func_192400_c()) {
                    if (!ing.test((Object)new ItemStack(CopyODCChannelRecipe.connector()))) continue;
                    foundInput = true;
                    break;
                }
                if (!foundInput) continue;
                newRecipes.add(rec);
                badRecipes.add(ent.getKey());
            }
            IntegratedDerivative.LOGGER.info("Replacing {} recipes that output an Omni-Directional Connector...", (Object)badRecipes.size());
            for (ResourceLocation key : badRecipes) {
                r.remove(key);
            }
            for (IRecipe base : newRecipes) {
                String registryName = Objects.requireNonNull(base.getRegistryName()).toString();
                r.register(new CopyODCChannelRecipe(base).setRegistryName("integratedderivative", registryName.replace(':', '_')));
            }
        }
    }
}

