/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.label.labels.LItemStack;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Wrapper;
import mezz.jei.api.gui.IRecipeLayout;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LOreDict
extends ILabel.Impl {
    public static final String IDENTIFIER = "oreDict";
    public static final String KEY_NAME = "name";
    public static final boolean MODE_FORCE = false;
    protected String name;

    public LOreDict(String name) {
        this(name, 1L);
    }

    public LOreDict(String name, long amount) {
        super(amount, false);
        this.name = name;
    }

    public LOreDict(LOreDict lod) {
        super(lod);
        this.name = lod.name;
    }

    public LOreDict(NBTTagCompound nbt) {
        super(nbt);
        this.name = nbt.func_74779_i(KEY_NAME);
    }

    public static boolean mergeSame(ILabel a, ILabel b) {
        if (a instanceof LOreDict && b instanceof LOreDict) {
            LOreDict lodA = (LOreDict)a;
            LOreDict lodB = (LOreDict)b;
            return lodA.getName().equals(lodB.getName());
        }
        return false;
    }

    public static boolean mergeFuzzy(ILabel a, ILabel b) {
        if (a instanceof LOreDict && b instanceof LItemStack) {
            LOreDict lod = (LOreDict)a;
            LItemStack lis = (LItemStack)b;
            return lod.getAmount() * lis.getAmount() < 0L && OreDictionary.getOres((String)lod.name).stream().map(ILabel.Converter::from).anyMatch(i -> LItemStack.merge(i, lis));
        }
        return false;
    }

    public static List<ILabel> suggest(List<ILabel> iss, @Nullable IRecipeLayout rl) {
        return LOreDict.getMatchedList(iss, rl, true);
    }

    public static List<ILabel> fallback(List<ILabel> iss, @Nullable IRecipeLayout rl) {
        return LOreDict.getMatchedList(iss, rl, false);
    }

    public static List<ILabel> getMatchedList(List<ILabel> iss, @Nullable IRecipeLayout rl, boolean biDir) {
        ILabel l = iss.get(0);
        if (!(l instanceof LItemStack)) {
            return new ArrayList<ILabel>();
        }
        LItemStack lis = (LItemStack)l;
        HashSet<Integer> ids = new HashSet<Integer>();
        long amount = lis.getAmount();
        ItemStack rep = lis.getRep();
        if (!rep.func_190926_b()) {
            for (int i2 : OreDictionary.getOreIDs((ItemStack)lis.getRep())) {
                if (!LOreDict.check(i2, iss, biDir)) continue;
                ids.add(i2);
            }
        }
        return ids.stream().map(i -> new LOreDict(OreDictionary.getOreName((int)i), amount)).collect(Collectors.toList());
    }

    private static boolean check(int id, List<ILabel> labels, boolean biDir) {
        NonNullList ores = OreDictionary.getOres((String)OreDictionary.getOreName((int)id));
        if (labels.size() == 1 && ores.size() == 1 && biDir) {
            return false;
        }
        Wrapper<Boolean> acceptable = new Wrapper<Boolean>(true);
        BiPredicate<ILabel, ItemStack> match = (l, o) -> l instanceof LItemStack && OreDictionary.itemMatches((ItemStack)o, (ItemStack)((LItemStack)l).getRep(), (boolean)false);
        if (biDir) {
            ores.stream().filter(ore -> labels.stream().noneMatch(label -> match.test((ILabel)label, (ItemStack)ore))).findAny().ifPresent(i -> {
                acceptable.value = false;
                Object cfr_ignored_0 = acceptable.value;
            });
        }
        labels.stream().filter(label -> ores.stream().noneMatch(ore -> match.test((ILabel)label, (ItemStack)ore))).findAny().ifPresent(i -> {
            acceptable.value = false;
            Object cfr_ignored_0 = acceptable.value;
        });
        return (Boolean)acceptable.value;
    }

    @Nonnull
    public ItemStack getRepresentation() {
        NonNullList list = NonNullList.func_191196_a();
        OreDictionary.getOres((String)this.name).forEach(is -> {
            if (is.func_77952_i() == Short.MAX_VALUE) {
                is.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, list);
            } else {
                list.add(is);
            }
        });
        if (list.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        long index = System.currentTimeMillis() / 1500L;
        return (ItemStack)list.get((int)(index % (long)list.size()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        return Utilities.I18n.get("label.ore_dict.name", this.name);
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean matches(Object l) {
        return l instanceof LOreDict && this.name.equals(((LOreDict)l).name) && super.matches(l);
    }

    @Override
    public LOreDict copy() {
        return new LOreDict(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawLabel(JecaGui gui) {
        gui.drawItemStack(0, 0, this.getRepresentation(), false);
        gui.drawResource(Resource.LBL_FRAME, 0, 0);
    }

    @Override
    public NBTTagCompound toNbt() {
        NBTTagCompound ret = super.toNbt();
        ret.func_74778_a(KEY_NAME, this.name);
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getToolTip(List<String> existing, boolean detailed) {
        super.getToolTip(existing, detailed);
        existing.add("\u00a79\u00a7oJust Enough Calculation");
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() ^ super.hashCode();
    }

    public String getName() {
        return this.name;
    }
}

