/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.effects;

import java.util.Collection;
import java.util.WeakHashMap;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.PotionColorCalculationEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.base.network.message.MessageSyncColors;
import vazkii.quark.base.potion.PotionMod;
import vazkii.quark.base.util.MutableVectorHolder;

public class PotionColorizer
extends PotionMod {
    public final int color;
    public final float r;
    public final float g;
    public final float b;
    private static final WeakHashMap<EntityLivingBase, MutableVectorHolder> colors = new WeakHashMap();

    public PotionColorizer(String name, int color, int iconIndex) {
        super(name, true, color, iconIndex);
        this.color = color;
        this.r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        this.g = (float)((color & 0xFF00) >> 8) / 255.0f;
        this.b = (float)(color & 0xFF) / 255.0f;
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP && event.getTarget() instanceof EntityLivingBase) {
            NetworkHandler.INSTANCE.sendTo((IMessage)PotionColorizer.prepareMessage((EntityLivingBase)event.getTarget()), (EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public static void onCalculateColor(PotionColorCalculationEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (world instanceof WorldServer) {
            for (EntityPlayer tracker : ((WorldServer)world).func_73039_n().getTrackingPlayers((Entity)entity)) {
                if (!(tracker instanceof EntityPlayerMP)) continue;
                NetworkHandler.INSTANCE.sendTo((IMessage)PotionColorizer.prepareMessage(entity.func_145782_y(), event.getEffects()), (EntityPlayerMP)tracker);
            }
        }
        if (entity instanceof EntityPlayerMP) {
            NetworkHandler.INSTANCE.sendTo((IMessage)PotionColorizer.prepareMessage(entity.func_145782_y(), event.getEffects()), (EntityPlayerMP)entity);
        }
    }

    private static MessageSyncColors prepareMessage(EntityLivingBase entity) {
        return PotionColorizer.prepareMessage(entity.func_145782_y(), entity.func_70651_bq());
    }

    private static MessageSyncColors prepareMessage(int id, Collection<PotionEffect> effects) {
        float rMix = 0.0f;
        float gMix = 0.0f;
        float bMix = 0.0f;
        int total = 0;
        for (PotionEffect effect : effects) {
            if (!(effect.func_188419_a() instanceof PotionColorizer)) continue;
            rMix += ((PotionColorizer)effect.func_188419_a()).r;
            gMix += ((PotionColorizer)effect.func_188419_a()).g;
            bMix += ((PotionColorizer)effect.func_188419_a()).b;
            ++total;
        }
        if (total > 0) {
            return new MessageSyncColors(id, rMix /= (float)total, gMix /= (float)total, bMix /= (float)total);
        }
        return new MessageSyncColors(id, -1.0, -1.0, -1.0);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void colorize(RenderLivingEvent.Pre<?> event) {
        EntityLivingBase entity = event.getEntity();
        if ((Integer)entity.func_184212_Q().func_187225_a(EntityLivingBase.field_184633_f) == 0) {
            return;
        }
        MutableVectorHolder holder = colors.get(event.getEntity());
        if (holder != null) {
            GlStateManager.func_179124_c((float)((float)holder.x), (float)((float)holder.y), (float)((float)holder.z));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void colorize(RenderLivingEvent.Post<?> event) {
        if (colors.containsKey(event.getEntity())) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void receiveColors(EntityLivingBase entity, double r, double g, double b) {
        if (r < 0.0 || g < 0.0 || b < 0.0) {
            colors.remove(entity);
        } else {
            MutableVectorHolder holder = colors.computeIfAbsent(entity, e -> new MutableVectorHolder());
            holder.x = r;
            holder.y = g;
            holder.z = b;
        }
    }
}

