/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.base;

import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import vazkii.quark.world.feature.Basalt;
import vazkii.quark.world.feature.RevampStoneGen;

public enum EnumStonelingVariant implements IEntityLivingData
{
    STONE("stoneling", "stone", EnumStonelingVariant.stoneState(BlockStone.EnumType.STONE), EnumStonelingVariant.isBlock(Blocks.field_150348_b).and(EnumStonelingVariant.hasProp((IProperty)BlockStone.field_176247_a, (Comparable[])new BlockStone.EnumType[]{BlockStone.EnumType.STONE})).or(EnumStonelingVariant.isBlock(Blocks.field_150347_e))),
    ANDESITE("stoneling_andesite", "stoneAndesite", EnumStonelingVariant.stoneState(BlockStone.EnumType.ANDESITE), EnumStonelingVariant.isBlock(Blocks.field_150348_b).and(EnumStonelingVariant.hasProp((IProperty)BlockStone.field_176247_a, (Comparable[])new BlockStone.EnumType[]{BlockStone.EnumType.ANDESITE, BlockStone.EnumType.ANDESITE_SMOOTH}))),
    DIORITE("stoneling_diorite", "stoneDiorite", EnumStonelingVariant.stoneState(BlockStone.EnumType.DIORITE), EnumStonelingVariant.isBlock(Blocks.field_150348_b).and(EnumStonelingVariant.hasProp((IProperty)BlockStone.field_176247_a, (Comparable[])new BlockStone.EnumType[]{BlockStone.EnumType.DIORITE, BlockStone.EnumType.DIORITE_SMOOTH}))),
    GRANITE("stoneling_granite", "stoneGranite", EnumStonelingVariant.stoneState(BlockStone.EnumType.GRANITE), EnumStonelingVariant.isBlock(Blocks.field_150348_b).and(EnumStonelingVariant.hasProp((IProperty)BlockStone.field_176247_a, (Comparable[])new BlockStone.EnumType[]{BlockStone.EnumType.GRANITE, BlockStone.EnumType.GRANITE_SMOOTH}))),
    LIMESTONE("stoneling_limestone", "stoneLimestone", EnumStonelingVariant.fromNullableBlock(() -> RevampStoneGen.limestone), EnumStonelingVariant.isBlock(() -> RevampStoneGen.limestone)),
    BASALT("stoneling_basalt", "stoneBasalt", EnumStonelingVariant.fromNullableBlock(() -> Basalt.basalt), EnumStonelingVariant.isBlock(() -> Basalt.basalt)),
    MARBLE("stoneling_marble", "stoneMarble", EnumStonelingVariant.fromNullableBlock(() -> RevampStoneGen.marble), EnumStonelingVariant.isBlock(() -> RevampStoneGen.marble));

    private final ResourceLocation texture;
    private final String oreKey;
    private final Supplier<IBlockState> stateSupplier;
    private IBlockState state;
    private final Predicate<IBlockState> allowedStates;

    private static Supplier<IBlockState> fromNullableBlock(Supplier<Block> block) {
        return () -> {
            Block inst = (Block)block.get();
            if (inst == null) {
                return null;
            }
            return inst.func_176223_P();
        };
    }

    private static Supplier<IBlockState> stoneState(BlockStone.EnumType type) {
        return () -> Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)type);
    }

    private static Predicate<IBlockState> isBlock(Block type) {
        return state -> state.func_177230_c() == type;
    }

    private static Predicate<IBlockState> isBlock(Supplier<Block> type) {
        return state -> state.func_177230_c() == type.get();
    }

    @SafeVarargs
    private static <T extends Comparable<T>> Predicate<IBlockState> hasProp(IProperty<T> prop, T ... valuesAllowed) {
        return state -> {
            Comparable value = state.func_177229_b(prop);
            for (Comparable test : valuesAllowed) {
                if (value != test) continue;
                return true;
            }
            return false;
        };
    }

    private EnumStonelingVariant(String variantPath, String oreKey, Supplier<IBlockState> displayState, Predicate<IBlockState> accepts) {
        this.texture = new ResourceLocation("quark", "textures/entity/" + variantPath + ".png");
        this.oreKey = oreKey;
        this.stateSupplier = displayState;
        this.allowedStates = accepts;
    }

    public static EnumStonelingVariant byIndex(byte index) {
        EnumStonelingVariant[] values = EnumStonelingVariant.values();
        return values[MathHelper.func_76125_a((int)index, (int)0, (int)(values.length - 1))];
    }

    public byte getIndex() {
        return (byte)this.ordinal();
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public String getOreKey() {
        return this.oreKey;
    }

    @Nullable
    public IBlockState getDisplayState() {
        if (this.state == null) {
            this.state = this.stateSupplier.get();
        }
        return this.state;
    }

    public boolean acceptsState(IBlockState state) {
        return this.allowedStates.test(state);
    }
}

