/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.inventory;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import vazkii.quark.oddities.feature.MatrixEnchanting;

public class EnchantmentMatrix {
    public static final int MATRIX_WIDTH = 5;
    public static final int MATRIX_HEIGHT = 5;
    private static final int PIECE_VARIANTS = 8;
    private static final String TAG_PIECES = "pieces";
    private static final String TAG_PIECE_ID = "id";
    private static final String TAG_BENCHED_PIECES = "benchedPieces";
    private static final String TAG_PLACED_PIECES = "placedPieces";
    private static final String TAG_COUNT = "count";
    private static final String TAG_TYPE_COUNT = "typeCount";
    public final Map<Enchantment, Integer> totalValue = new HashMap<Enchantment, Integer>();
    public final Map<Integer, Piece> pieces = new HashMap<Integer, Piece>();
    public List<Integer> benchedPieces = new ArrayList<Integer>();
    public List<Integer> placedPieces = new ArrayList<Integer>();
    public int[][] matrix;
    public int count;
    public int typeCount;
    public final boolean book;
    public final ItemStack target;
    public final Random rng;

    public EnchantmentMatrix(ItemStack target, Random rng) {
        this.target = target;
        this.rng = rng;
        this.book = target.func_77973_b() == Items.field_151122_aG;
        this.computeMatrix();
    }

    public boolean canGeneratePiece(int bookshelfPower, int enchantability) {
        int enchantabilityCount;
        if (enchantability == 0) {
            return false;
        }
        if (this.book) {
            if (!MatrixEnchanting.allowBooks) {
                return false;
            }
            int bookshelfCount = Math.max(0, Math.min(bookshelfPower - 1, MatrixEnchanting.maxBookshelves)) / 7;
            int maxCount = MatrixEnchanting.baseMaxPieceCountBook + bookshelfCount;
            return this.count < maxCount;
        }
        int bookshelfCount = (Math.min(bookshelfPower, MatrixEnchanting.maxBookshelves) + 1) / 2;
        int maxCount = MatrixEnchanting.baseMaxPieceCount + bookshelfCount + (enchantabilityCount = Math.min(bookshelfPower, enchantability) / 2);
        return this.count < maxCount;
    }

    public boolean validateXp(EntityPlayer player, int bookshelfPower) {
        return player.func_184812_l_() || player.field_71068_ca >= this.getMinXpLevel(bookshelfPower) && player.field_71068_ca >= this.getNewPiecePrice();
    }

    public int getMinXpLevel(int bookshelfPower) {
        float scale = MatrixEnchanting.minLevelScaleFactor;
        int cutoff = MatrixEnchanting.minLevelCutoff;
        if (this.book) {
            return (int)((float)Math.min(bookshelfPower, MatrixEnchanting.maxBookshelves) * MatrixEnchanting.minLevelScaleFactorBook);
        }
        return this.count > cutoff ? (int)((float)cutoff * scale) - cutoff + this.count : (int)((float)this.count * scale);
    }

    public int getNewPiecePrice() {
        return 1 + (MatrixEnchanting.piecePriceScale == 0 ? 0 : this.count / MatrixEnchanting.piecePriceScale);
    }

    public boolean generatePiece(Map<Enchantment, Integer> influences, int bookshelfPower) {
        EnchantmentDataWrapper data = this.generateRandomEnchantment(influences, bookshelfPower);
        if (data == null) {
            return false;
        }
        int type = -1;
        for (Piece p : this.pieces.values()) {
            if (p.enchant != data.field_76302_b) continue;
            type = p.type;
        }
        if (type == -1) {
            type = this.typeCount % 8;
            ++this.typeCount;
        }
        Piece piece = new Piece(data, type);
        piece.generateBlocks();
        this.pieces.put(this.count, piece);
        this.totalValue.put(piece.enchant, this.totalValue.getOrDefault(piece.enchant, 0) + piece.getValue());
        this.benchedPieces.add(this.count);
        ++this.count;
        if (this.book && this.count == 1) {
            for (int i = 0; i < 2; ++i) {
                if (!this.rng.nextBoolean()) continue;
                ++this.count;
            }
        }
        return true;
    }

    private EnchantmentDataWrapper generateRandomEnchantment(Map<Enchantment, Integer> influences, int bookshelfPower) {
        int level = this.book ? MatrixEnchanting.bookEnchantability + this.rng.nextInt(Math.max(1, bookshelfPower) * 2) : 0;
        List<Piece> marked = this.pieces.values().stream().filter(p -> p.marked).collect(Collectors.toList());
        ArrayList<EnchantmentDataWrapper> validEnchants = new ArrayList<EnchantmentDataWrapper>();
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            int currentValue;
            int valueAdded;
            if (enchantment.func_185261_e() && !MatrixEnchanting.allowTreasures || MatrixEnchanting.disallowedEnchantments.contains(Objects.toString(enchantment.getRegistryName())) || !enchantment.canApplyAtEnchantingTable(this.target) && (!this.book || !enchantment.isAllowedOnBooks())) continue;
            int enchantLevel = 1;
            if (this.book) {
                for (int i = enchantment.func_77325_b(); i > enchantment.func_77319_d() - 1; --i) {
                    if (level < enchantment.func_77321_a(i) || level > enchantment.func_77317_b(i)) continue;
                    enchantLevel = i;
                    break;
                }
            }
            if ((valueAdded = EnchantmentMatrix.getValue(enchantment, enchantLevel)) + (currentValue = this.totalValue.getOrDefault(enchantment, 0).intValue()) > EnchantmentMatrix.getValue(enchantment, enchantment.func_77325_b()) + EnchantmentMatrix.getMaxXP(enchantment, enchantment.func_77325_b())) continue;
            EnchantmentDataWrapper wrapper = new EnchantmentDataWrapper(enchantment, enchantLevel);
            wrapper.normalizeRarity(influences, marked);
            validEnchants.add(wrapper);
        }
        if (validEnchants.isEmpty()) {
            return null;
        }
        int total = 0;
        for (EnchantmentDataWrapper wrapper : validEnchants) {
            total += wrapper.field_76292_a;
        }
        if (total == 0) {
            for (EnchantmentDataWrapper wrapper : validEnchants) {
                ++wrapper.field_76292_a;
            }
        }
        return (EnchantmentDataWrapper)WeightedRandom.func_76271_a((Random)this.rng, validEnchants);
    }

    public boolean place(int id, int x, int y) {
        Piece p = this.pieces.get(id);
        if (p != null && this.benchedPieces.contains(id) && this.canPlace(p, x, y)) {
            p.x = x;
            p.y = y;
            this.benchedPieces.remove((Object)id);
            this.placedPieces.add(id);
            this.computeMatrix();
            return true;
        }
        return false;
    }

    public boolean remove(int id) {
        Piece p = this.pieces.get(id);
        if (p != null && this.placedPieces.contains(id)) {
            this.placedPieces.remove((Object)id);
            this.benchedPieces.add(id);
            this.computeMatrix();
            return true;
        }
        return false;
    }

    public boolean rotate(int id) {
        Piece p = this.pieces.get(id);
        if (p != null && this.benchedPieces.contains(id)) {
            p.rotate();
            return true;
        }
        return false;
    }

    public boolean merge(int placed, int hover) {
        Enchantment enchant;
        Piece placedPiece = this.pieces.get(placed);
        Piece hoveredPiece = this.pieces.get(hover);
        if (placedPiece != null && hoveredPiece != null && this.placedPieces.contains(placed) && this.benchedPieces.contains(hover) && hoveredPiece.enchant == (enchant = placedPiece.enchant) && placedPiece.level < enchant.func_77325_b()) {
            placedPiece.xp += hoveredPiece.getValue();
            int max = placedPiece.getMaxXP();
            while (placedPiece.xp >= max && placedPiece.level < enchant.func_77325_b()) {
                ++placedPiece.level;
                placedPiece.xp -= max;
                max = placedPiece.getMaxXP();
            }
            if (hoveredPiece.marked) {
                placedPiece.marked = true;
            }
            this.benchedPieces.remove((Object)hover);
            this.pieces.remove(hover);
            return true;
        }
        return false;
    }

    public void writeToNBT(NBTTagCompound cmp) {
        NBTTagList list = new NBTTagList();
        for (Integer i : this.pieces.keySet()) {
            NBTTagCompound pieceTag = new NBTTagCompound();
            pieceTag.func_74768_a(TAG_PIECE_ID, i.intValue());
            if (this.pieces.get((Object)i).enchant == null) continue;
            this.pieces.get(i).writeToNBT(pieceTag);
            list.func_74742_a((NBTBase)pieceTag);
        }
        cmp.func_74782_a(TAG_PIECES, (NBTBase)list);
        cmp.func_74783_a(TAG_BENCHED_PIECES, this.packList(this.benchedPieces));
        cmp.func_74783_a(TAG_PLACED_PIECES, this.packList(this.placedPieces));
        cmp.func_74768_a(TAG_COUNT, this.count);
        cmp.func_74768_a(TAG_TYPE_COUNT, this.typeCount);
    }

    public void readFromNBT(NBTTagCompound cmp) {
        this.pieces.clear();
        this.totalValue.clear();
        NBTTagList plist = cmp.func_150295_c(TAG_PIECES, (int)cmp.func_74732_a());
        for (int i = 0; i < plist.func_74745_c(); ++i) {
            NBTTagCompound pieceTag = plist.func_150305_b(i);
            int id = pieceTag.func_74762_e(TAG_PIECE_ID);
            Piece piece = new Piece();
            piece.readFromNBT(pieceTag);
            this.pieces.put(id, piece);
            this.totalValue.put(piece.enchant, this.totalValue.getOrDefault(piece.enchant, 0) + piece.getValue());
        }
        this.benchedPieces = this.unpackList(cmp.func_74759_k(TAG_BENCHED_PIECES));
        this.placedPieces = this.unpackList(cmp.func_74759_k(TAG_PLACED_PIECES));
        this.count = cmp.func_74762_e(TAG_COUNT);
        this.typeCount = cmp.func_74762_e(TAG_TYPE_COUNT);
        this.computeMatrix();
    }

    private void computeMatrix() {
        this.matrix = new int[5][5];
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.matrix[i][j] = -1;
            }
        }
        for (Integer i : this.placedPieces) {
            Piece p = this.pieces.get(i);
            for (int[] b : p.blocks) {
                this.matrix[p.x + b[0]][p.y + b[1]] = i;
            }
        }
    }

    public boolean canPlace(Piece p, int x, int y) {
        for (int[] b : p.blocks) {
            int bx = b[0] + x;
            int by = b[1] + y;
            if (bx < 0 || by < 0 || bx >= 5 || by >= 5) {
                return false;
            }
            if (this.matrix[bx][by] == -1) continue;
            return false;
        }
        return true;
    }

    private int[] packList(List<Integer> list) {
        int[] arr = new int[list.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    private List<Integer> unpackList(int[] arr) {
        ArrayList<Integer> list = new ArrayList<Integer>(arr.length);
        for (int anArr : arr) {
            list.add(anArr);
        }
        return list;
    }

    public static int getMaxXP(Enchantment enchantment, int level) {
        if (level >= enchantment.func_77325_b()) {
            return 0;
        }
        switch (enchantment.func_77324_c()) {
            case COMMON: {
                return level;
            }
            case UNCOMMON: {
                return level / 2 + 1;
            }
        }
        return 1;
    }

    public static int getValue(Enchantment enchantment, int level) {
        int total = 1;
        for (int i = 1; i < level; ++i) {
            total += EnchantmentMatrix.getMaxXP(enchantment, i);
        }
        return total;
    }

    private static class EnchantmentDataWrapper
    extends EnchantmentData {
        private boolean marked;
        private int influence;

        public EnchantmentDataWrapper(Enchantment enchantmentObj, int enchLevel) {
            super(enchantmentObj, enchLevel);
        }

        public void normalizeRarity(Map<Enchantment, Integer> influences, List<Piece> markedEnchants) {
            if (MatrixEnchanting.normalizeRarity) {
                this.field_76292_a *= 10000;
                switch (this.field_76302_b.func_77324_c()) {
                    case COMMON: {
                        this.field_76292_a = 80000;
                        break;
                    }
                    case UNCOMMON: {
                        this.field_76292_a = 40000;
                        break;
                    }
                    case RARE: {
                        this.field_76292_a = 25000;
                        break;
                    }
                    case VERY_RARE: {
                        this.field_76292_a = 5000;
                    }
                }
                this.influence = influences.getOrDefault(this.field_76302_b, 0);
                float multiplier = 1.0f + (float)this.influence * MatrixEnchanting.influencePower;
                this.field_76292_a = (int)((float)this.field_76292_a * multiplier);
                boolean mark = true;
                for (Piece other : markedEnchants) {
                    if (other.enchant == this.field_76302_b) {
                        this.field_76292_a = (int)((float)this.field_76292_a * MatrixEnchanting.dupeMultiplier);
                        mark = false;
                        break;
                    }
                    if (other.enchant.func_191560_c(this.field_76302_b) && this.field_76302_b.func_191560_c(other.enchant)) continue;
                    this.field_76292_a = (int)((float)this.field_76292_a * MatrixEnchanting.incompatibleMultiplier);
                    mark = false;
                    break;
                }
                if (mark) {
                    this.marked = true;
                }
            }
        }
    }

    public static class Piece {
        private static final int[][][] PIECE_TYPES = new int[][][]{new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {0, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {-1, -1}, {0, -1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {-1, 1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {-1, -1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {1, -1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {0, -1}, {-1, -1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {0, 1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {0, -1}, {-1, -1}, {-1, 1}, {1, -1}}, new int[][]{{0, 0}, {-1, 0}, {0, -1}, {-1, -1}, {-1, 1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {-1, -1}, {1, -1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {-1, -1}, {1, 1}}};
        private static final String TAG_COLOR = "color";
        private static final String TAG_TYPE = "type";
        private static final String TAG_ENCHANTMENT = "enchant";
        private static final String TAG_LEVEL = "level";
        private static final String TAG_BLOCK_COUNT = "blockCount";
        private static final String TAG_BLOCK = "block";
        private static final String TAG_X = "x";
        private static final String TAG_Y = "y";
        private static final String TAG_XP = "xp";
        private static final String TAG_MARKED = "marked";
        private static final String TAG_INFLUENCE = "influence";
        public Enchantment enchant;
        public int level;
        public int color;
        public int type;
        public int x;
        public int y;
        public int xp;
        public int[][] blocks;
        public boolean marked;
        public int influence;

        public Piece() {
        }

        public Piece(EnchantmentDataWrapper wrapper, int type) {
            this.enchant = wrapper.field_76302_b;
            this.level = wrapper.field_76303_c;
            this.marked = wrapper.marked;
            this.influence = wrapper.influence;
            this.type = type;
            Random rng = new Random(Objects.toString(this.enchant.getRegistryName()).hashCode());
            float h = rng.nextFloat();
            float s = rng.nextFloat() * 0.2f + 0.8f;
            float b = rng.nextFloat() * 0.25f + 0.75f;
            this.color = Color.HSBtoRGB(h, s, b);
        }

        public void generateBlocks() {
            int type = (int)(Math.random() * (double)PIECE_TYPES.length);
            int[][] copyPieces = PIECE_TYPES[type];
            this.blocks = new int[copyPieces.length][2];
            for (int i = 0; i < this.blocks.length; ++i) {
                this.blocks[i][0] = copyPieces[i][0];
                this.blocks[i][1] = copyPieces[i][1];
            }
            int rotations = (int)(Math.random() * 4.0);
            for (int i = 0; i < rotations; ++i) {
                this.rotate();
            }
        }

        public void rotate() {
            for (int[] b : this.blocks) {
                int y;
                int x = b[0];
                b[0] = y = b[1];
                b[1] = -x;
            }
        }

        public int getMaxXP() {
            return EnchantmentMatrix.getMaxXP(this.enchant, this.level);
        }

        public int getValue() {
            return EnchantmentMatrix.getValue(this.enchant, this.level) + this.xp;
        }

        public void writeToNBT(NBTTagCompound cmp) {
            cmp.func_74768_a(TAG_COLOR, this.color);
            cmp.func_74768_a(TAG_TYPE, this.type);
            if (this.enchant != null) {
                cmp.func_74778_a(TAG_ENCHANTMENT, Objects.toString(this.enchant.getRegistryName()));
            }
            cmp.func_74768_a(TAG_LEVEL, this.level);
            cmp.func_74768_a(TAG_X, this.x);
            cmp.func_74768_a(TAG_Y, this.y);
            cmp.func_74768_a(TAG_XP, this.xp);
            cmp.func_74757_a(TAG_MARKED, this.marked);
            cmp.func_74768_a(TAG_INFLUENCE, this.influence);
            cmp.func_74768_a(TAG_BLOCK_COUNT, this.blocks.length);
            for (int i = 0; i < this.blocks.length; ++i) {
                cmp.func_74783_a(TAG_BLOCK + i, this.blocks[i]);
            }
        }

        public void readFromNBT(NBTTagCompound cmp) {
            this.color = cmp.func_74762_e(TAG_COLOR);
            this.type = cmp.func_74762_e(TAG_TYPE);
            this.enchant = Enchantment.func_180305_b((String)cmp.func_74779_i(TAG_ENCHANTMENT));
            this.level = cmp.func_74762_e(TAG_LEVEL);
            this.x = cmp.func_74762_e(TAG_X);
            this.y = cmp.func_74762_e(TAG_Y);
            this.xp = cmp.func_74762_e(TAG_XP);
            this.marked = cmp.func_74767_n(TAG_MARKED);
            this.influence = cmp.func_74762_e(TAG_INFLUENCE);
            this.blocks = new int[cmp.func_74762_e(TAG_BLOCK_COUNT)][2];
            for (int i = 0; i < this.blocks.length; ++i) {
                this.blocks[i] = cmp.func_74759_k(TAG_BLOCK + i);
            }
        }
    }
}

