/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.arl.client.AtlasSpriteHelper;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.util.ItemMetaHelper;
import vazkii.quark.oddities.client.render.RenderTotemOfHolding;
import vazkii.quark.oddities.entity.EntityTotemOfHolding;
import vazkii.quark.oddities.item.ItemSoulCompass;
import vazkii.quark.oddities.item.ItemTotemOfHolding;
import vazkii.quark.world.feature.Wraiths;

public class TotemOfHolding
extends Feature {
    private static final String TAG_LAST_TOTEM = "quark:lastTotemOfHolding";
    private static final String TAG_DEATH_X = "quark:deathX";
    private static final String TAG_DEATH_Z = "quark:deathZ";
    private static final String TAG_DEATH_DIM = "quark:deathDim";
    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite totemSprite;
    public static Item soul_compass;
    public static Item totem_item;
    public static boolean darkSoulsMode;
    public static boolean enableOnPK;
    public static boolean destroyItems;
    public static boolean anyoneCollect;
    public static boolean enableSoulCompass;
    public static boolean shouldBlacklistBeWhitelist;
    public static boolean enableTotemItem;
    public static float entityScale;
    public static double glowRange;
    public static int deathTime;
    public static int baseDropAmount;
    public static int randomBonusDrops;
    private static String[] tempBlacklist;
    public static Set<Pair<Item, Integer>> holdingBlacklist;
    private static String tempSavingItem;
    public static Pair<Item, Integer> savingItem;

    @Override
    public void setupConfig() {
        darkSoulsMode = this.loadPropBool("Dark Souls Mode", "Set this to false to remove the behaviour where totems destroy themselves if the player dies again.", true);
        enableOnPK = this.loadPropBool("Spawn Totem on PVP Kill", "", false);
        destroyItems = this.loadPropBool("Destroy Lost Items", "Set this to true to make it so that if a totem is destroyed, the items it holds are destroyed alongside it rather than dropped", false);
        anyoneCollect = this.loadPropBool("Allow Anyone to Collect", "Set this to false to only allow the owner of a totem to collect its items rather than any player", true);
        enableSoulCompass = this.loadPropBool("Enable Soul Compass", "", true);
        shouldBlacklistBeWhitelist = this.loadPropBool("Should Holding Blacklist Be Whitelist", "", false);
        tempBlacklist = this.loadPropStringList("Holding Blacklist", "Items that should be prevented from being saved by the totem\nFormat is modid:item[:meta]", new String[0]);
        tempSavingItem = this.loadPropString("Saving Item", "An item that must be in the player inventory for the totem to work. Set to 'none' to disable", "quark:totem_of_holding");
        enableTotemItem = this.loadPropBool("Enable Totem of Holding Item", "", true);
        entityScale = (float)this.loadPropDouble("Totem of Holding Entity Scale", "Displayed scale of the totem of holding entity", 1.0);
        deathTime = this.loadPropInt("Totem of Holding Vanish Time", "How long it takes for the totem to vanish once depleted, in ticks", 40);
        glowRange = this.loadPropDouble("Totem Glow Range", "Maximum range at which totems visibly glow. Default is 32; set to 0 to disable", 32.0);
        baseDropAmount = this.loadPropInt("Totem Drop Amount Base", "The minimum number of items the totem always drops per hit", 3);
        randomBonusDrops = this.loadPropInt("Totem Drop Amount Bonus", "The extra random drops per hit. Ranges from 0 to this number", 4);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (enableSoulCompass) {
            soul_compass = new ItemSoulCompass();
        }
        String totemName = "quark:totem_of_holding";
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(totemName), EntityTotemOfHolding.class, (String)totemName, (int)15, (Object)Quark.instance, (int)64, (int)128, (boolean)false);
        if (enableTotemItem) {
            totem_item = new ItemTotemOfHolding("holding_totem");
        }
    }

    @Override
    public void postPreInit() {
        if (enableSoulCompass) {
            RecipeHandler.addShapelessOreDictRecipe((ItemStack)new ItemStack(soul_compass), (Object[])new Object[]{Wraiths.soul_bead == null ? new ItemStack(Blocks.field_150425_aM) : new ItemStack(Wraiths.soul_bead), new ItemStack(Items.field_151111_aL)});
        }
        if (enableTotemItem) {
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Item)totem_item), (Object[])new Object[]{" P ", "SCS", " A ", Character.valueOf('P'), "enderpearl", Character.valueOf('C'), "chestWood", Character.valueOf('S'), "stone", Character.valueOf('A'), Items.field_179565_cj});
        }
        holdingBlacklist = ItemMetaHelper.getFromStringArray("totem holding blacklist item", tempBlacklist).stream().filter(i -> !i.func_190926_b()).map(s -> Pair.of((Object)s.func_77973_b(), (Object)s.func_77960_j())).collect(Collectors.toSet());
        ItemStack item = tempSavingItem.equals("none") ? ItemStack.field_190927_a : new ArrayList<ItemStack>(ItemMetaHelper.getFromString("totem holding saving item", tempSavingItem, false)).get(0);
        savingItem = !item.func_190926_b() ? Pair.of((Object)item.func_77973_b(), (Object)item.func_77960_j()) : Pair.of((Object)Items.field_190931_a, (Object)0);
    }

    @Override
    public void preInitClient() {
        RenderingRegistry.registerEntityRenderingHandler(EntityTotemOfHolding.class, RenderTotemOfHolding.factory());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitch(TextureStitchEvent event) {
        totemSprite = AtlasSpriteHelper.forName((TextureMap)event.getMap(), (ResourceLocation)new ResourceLocation("quark", "items/holding_totem"));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDrops(PlayerDropsEvent event) {
        List drops = event.getDrops();
        if (!(event.isCanceled() || !enableOnPK && event.getSource().func_76346_g() instanceof EntityPlayer)) {
            EntityPlayer player = event.getEntityPlayer();
            NBTTagCompound data = player.getEntityData();
            NBTTagCompound persistent = data.func_74775_l("PlayerPersisted");
            if (!drops.isEmpty()) {
                EntityTotemOfHolding totem = new EntityTotemOfHolding(player.field_70170_p);
                totem.func_70107_b(player.field_70165_t, Math.max(3.0, player.field_70163_u + 1.0), player.field_70161_v);
                totem.setOwner(player);
                totem.func_96094_a(player.getDisplayNameString());
                List saving = drops.stream().filter(Objects::nonNull).map(e -> Pair.of((Object)e.func_92059_d(), (Object)e)).filter(p -> !((ItemStack)p.getLeft()).func_190926_b() && !holdingBlacklist.contains(Pair.of((Object)((ItemStack)p.getLeft()).func_77973_b(), (Object)((ItemStack)p.getLeft()).func_77960_j()))).map(p -> (EntityItem)p.getRight()).collect(Collectors.toList());
                if (savingItem.getLeft() != Items.field_190931_a) {
                    boolean saved = false;
                    for (EntityItem e2 : saving) {
                        if (e2.func_92059_d().func_190926_b() || !ItemMetaHelper.itemEqualsPair(e2.func_92059_d(), savingItem)) continue;
                        ItemStack copy = e2.func_92059_d().func_77946_l();
                        copy.func_190918_g(1);
                        e2.func_92058_a(copy);
                        saved = true;
                        break;
                    }
                    if (!saved) {
                        return;
                    }
                    saving.removeIf(e -> e.func_92059_d().func_190926_b());
                }
                saving.stream().map(EntityItem::func_92059_d).forEach(totem::addItem);
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_72838_d((Entity)totem);
                }
                persistent.func_74778_a(TAG_LAST_TOTEM, totem.func_110124_au().toString());
                drops.removeAll(saving);
            } else {
                persistent.func_74778_a(TAG_LAST_TOTEM, "");
            }
            BlockPos pos = player.func_180425_c();
            persistent.func_74768_a(TAG_DEATH_X, pos.func_177958_n());
            persistent.func_74768_a(TAG_DEATH_Z, pos.func_177952_p());
            persistent.func_74768_a(TAG_DEATH_DIM, player.field_70170_p.field_73011_w.getDimension());
            if (!data.func_74764_b("PlayerPersisted")) {
                data.func_74782_a("PlayerPersisted", (NBTBase)persistent);
            }
        }
    }

    public static String getTotemUUID(EntityPlayer player) {
        NBTTagCompound cmp = player.getEntityData().func_74775_l("PlayerPersisted");
        if (cmp.func_74764_b(TAG_LAST_TOTEM)) {
            return cmp.func_74779_i(TAG_LAST_TOTEM);
        }
        return "";
    }

    public static BlockPos getPlayerDeathPosition(Entity e) {
        NBTTagCompound cmp;
        if (e instanceof EntityPlayer && (cmp = e.getEntityData().func_74775_l("PlayerPersisted")).func_74764_b(TAG_LAST_TOTEM)) {
            int x = cmp.func_74762_e(TAG_DEATH_X);
            int z = cmp.func_74762_e(TAG_DEATH_Z);
            int dim = cmp.func_74762_e(TAG_DEATH_DIM);
            return new BlockPos(x, dim, z);
        }
        return new BlockPos(0, -1, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isOutlineActive(Entity entity, Entity viewer) {
        return glowRange > 0.0 && entity instanceof EntityTotemOfHolding && viewer.func_70068_e(entity) <= glowRange * glowRange;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

