/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.feature;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.network.message.MessageRotateArrows;
import vazkii.quark.base.util.InventoryPositionHolder;

public class RotateArrowTypes
extends Feature {
    private static boolean isBow(ItemStack bow) {
        return !bow.func_190926_b() && bow.func_77973_b() instanceof ItemBow;
    }

    private static void rotateSlot(InventoryPositionHolder holder, ItemBow bowItem, EntityPlayer player, int direction, int slot) {
        ItemStack stack = InventoryPositionHolder.getStack(player, slot);
        if (bowItem.func_185058_h_(stack)) {
            if (direction < 1) {
                if (holder.slot == -1) {
                    holder.slot = slot;
                }
                InventoryPositionHolder.setStack(player, slot, holder.stack);
                holder.stack = stack;
            } else {
                InventoryPositionHolder.setStack(player, holder.slot, stack);
                if (holder.slot == -1) {
                    holder.stack = stack;
                }
                holder.slot = slot;
            }
        }
    }

    public static ItemBow getHeldBow(EntityPlayer player) {
        ItemStack bow = player.func_184614_ca();
        if (!RotateArrowTypes.isBow(bow)) {
            bow = player.func_184592_cb();
        }
        if (!RotateArrowTypes.isBow(bow)) {
            return null;
        }
        return (ItemBow)bow.func_77973_b();
    }

    public static void rotateArrows(ItemBow bowItem, EntityPlayer player, int direction) {
        int slot;
        InventoryPositionHolder holder = new InventoryPositionHolder();
        boolean foundSecondArrow = false;
        boolean foundArrow = false;
        ItemStack checkAgainst = ItemStack.field_190927_a;
        for (slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            ItemStack stack = player.field_71071_by.func_70301_a(slot);
            if (!bowItem.func_185058_h_(stack)) continue;
            if (!(!foundArrow || ItemStack.func_179545_c((ItemStack)checkAgainst, (ItemStack)stack) && ItemStack.func_77970_a((ItemStack)checkAgainst, (ItemStack)stack))) {
                foundSecondArrow = true;
                break;
            }
            if (foundArrow) continue;
            foundArrow = true;
            checkAgainst = stack;
        }
        if (!foundSecondArrow) {
            return;
        }
        RotateArrowTypes.rotateSlot(holder, bowItem, player, direction, -2);
        RotateArrowTypes.rotateSlot(holder, bowItem, player, direction, -3);
        for (slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            if (slot == player.field_71071_by.field_70461_c || slot == player.field_71071_by.field_70462_a.size() + EntityEquipmentSlot.OFFHAND.func_188452_c() - 1) continue;
            RotateArrowTypes.rotateSlot(holder, bowItem, player, direction, slot);
        }
        InventoryPositionHolder.setStack(player, holder.slot, holder.stack);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onMouseInput(MouseEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player != null && player.func_70093_af() && !player.func_175149_v() && mc.field_71462_r == null) {
            int wheelChange;
            ItemBow bowItem = RotateArrowTypes.getHeldBow((EntityPlayer)player);
            if (bowItem == null) {
                return;
            }
            long timeSinceUpdate = Minecraft.func_71386_F() - mc.field_71423_H;
            if (timeSinceUpdate <= 200L && (wheelChange = event.getDwheel()) != 0) {
                event.setCanceled(true);
                RotateArrowTypes.rotateArrows(bowItem, (EntityPlayer)player, wheelChange);
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageRotateArrows(wheelChange));
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }
}

