/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.client.gui;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.TextFormatting;
import vazkii.arl.util.RenderHelper;
import vazkii.quark.base.client.IParentedGui;
import vazkii.quark.base.client.ModKeybinds;
import vazkii.quark.base.lib.LibMisc;
import vazkii.quark.management.feature.FavoriteItems;
import vazkii.quark.management.feature.StoreToChests;

public class GuiButtonChest
extends GuiButton
implements IParentedGui {
    public final Action action;
    public final GuiScreen parent;
    public final int shiftX;
    public final int shiftY;
    private Predicate<GuiScreen> enabledPredicate = null;
    private boolean ender = false;

    public GuiButtonChest(GuiScreen parent, Action action, int id, int par2, int par3, int left, int top) {
        super(id, par2 + left, par3 + top, 16, 16, "");
        this.action = action;
        this.parent = parent;
        this.shiftX = par2;
        this.shiftY = par3;
    }

    public GuiButtonChest(GuiScreen parent, Action action, int id, int par2, int par3, int left, int top, Predicate<GuiScreen> enabledPredicate) {
        this(parent, action, id, par2, par3, left, top);
        this.enabledPredicate = enabledPredicate;
    }

    public void func_191745_a(@Nonnull Minecraft par1Minecraft, int par2, int par3, float partial) {
        if (par1Minecraft.field_71439_g.func_175149_v()) {
            this.field_146124_l = false;
        }
        if (this.enabledPredicate != null) {
            this.field_146124_l = this.enabledPredicate.test(this.parent);
        }
        if (this.field_146124_l) {
            this.field_146123_n = par2 >= this.field_146128_h && par3 >= this.field_146129_i && par2 < this.field_146128_h + this.field_146120_f && par3 < this.field_146129_i + this.field_146121_g;
            int k = this.func_146114_a(this.field_146123_n);
            int u = this.action.u;
            int v = this.action.v;
            if (this.action == Action.DROPOFF && GuiScreen.func_146272_n() != StoreToChests.invert) {
                u = 32;
            }
            if (k == 2) {
                u += 16;
            }
            par1Minecraft.field_71446_o.func_110577_a(LibMisc.GENERAL_ICONS_RESOURCE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.draw(u, v);
            if (k == 2) {
                KeyBinding key;
                BiMap map;
                if (this.action != Action.RESTOCK && !this.action.isSortAction()) {
                    FavoriteItems.hovering = true;
                }
                GlStateManager.func_179094_E();
                String hint = null;
                String tooltip = this.action == Action.DROPOFF && GuiScreen.func_146272_n() != StoreToChests.invert ? I18n.func_135052_a((String)("quarkmisc.chestButton." + this.action.name().toLowerCase() + ".shift"), (Object[])new Object[0]) : I18n.func_135052_a((String)("quarkmisc.chestButton." + this.action.name().toLowerCase()), (Object[])new Object[0]);
                if (this.action == Action.DROPOFF && !GuiScreen.func_146272_n()) {
                    hint = I18n.func_135052_a((String)("quarkmisc.chestButton." + this.action.name().toLowerCase() + (StoreToChests.invert ? ".shiftDepositHint" : ".shiftMergeHint")), (Object[])new Object[0]);
                }
                FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                int len = Math.max(fontRenderer.func_78256_a(tooltip), hint == null ? 0 : fontRenderer.func_78256_a(hint));
                int tooltipShift = this.action == Action.DROPOFF ? 0 : -len - 24;
                ArrayList<String> tooltipList = new ArrayList<String>();
                tooltipList.add(tooltip);
                if (hint != null) {
                    tooltipList.add(hint);
                }
                if ((map = ModKeybinds.keyboundButtons.inverse()).containsKey((Object)this) && (key = (KeyBinding)map.get((Object)this)).func_151463_i() != 0) {
                    int len2;
                    String press = I18n.func_135052_a((String)"quarkmisc.keyboundButton", (Object[])new Object[]{TextFormatting.GRAY, GameSettings.func_74298_c((int)key.func_151463_i())});
                    tooltipList.add(press);
                    if (this.action != Action.DROPOFF && (len2 = par1Minecraft.field_71466_p.func_78256_a(press)) > len) {
                        tooltipShift = -len2 - 24;
                    }
                }
                GlStateManager.func_179126_j();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(par1Minecraft.func_175599_af().field_77023_b + 300.0f));
                RenderHelper.renderTooltip((int)(par2 + tooltipShift), (int)(par3 + 8), tooltipList);
                GlStateManager.func_179121_F();
                GlStateManager.func_179097_i();
            }
        }
    }

    private void draw(int u, int v) {
        this.drawChest();
        this.drawIcon(u, v);
    }

    protected void drawChest() {
        this.drawIcon(this.ender ? 32 : 0, 128);
    }

    protected void drawIcon(int u, int v) {
        this.func_73729_b(this.field_146128_h, this.field_146129_i, u, v, 16, 16);
    }

    public void setEnder(boolean ender) {
        this.ender = ender;
    }

    @Override
    public GuiScreen getParent() {
        return this.parent;
    }

    public static enum Action {
        DROPOFF(0, 0),
        DEPOSIT(0, 0),
        SMART_DEPOSIT(32, 0),
        RESTOCK(64, 0),
        EXTRACT(64, 16),
        SORT(0, 16),
        SORT_PLAYER(0, 16);

        public final int u;
        public final int v;

        private Action(int u, int v) {
            this.u = u;
            this.v = v;
        }

        public boolean isSortAction() {
            return this == SORT || this == SORT_PLAYER;
        }
    }
}

