/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.capability;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShulkerBox;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.arl.util.AbstractDropIn;
import vazkii.arl.util.ItemNBTHelper;

public class ShulkerBoxDropIn
extends AbstractDropIn
implements ICapabilityProvider {
    public boolean canDropItemIn(EntityPlayer player, ItemStack stack, ItemStack incoming) {
        return this.tryAddToShulkerBox(stack, incoming, true);
    }

    public ItemStack dropItemIn(EntityPlayer player, ItemStack stack, ItemStack incoming) {
        this.tryAddToShulkerBox(stack, incoming, false);
        return stack;
    }

    private boolean tryAddToShulkerBox(ItemStack shulkerBox, ItemStack stack, boolean simulate) {
        if (stack.func_77973_b() instanceof ItemShulkerBox || shulkerBox.func_190916_E() > 1) {
            return false;
        }
        NBTTagCompound stackTag = shulkerBox.func_77978_p();
        NBTTagCompound blockEntityTag = stackTag != null && stackTag.func_74764_b("BlockEntityTag") ? stackTag.func_74775_l("BlockEntityTag") : new NBTTagCompound();
        ItemStackHandler handler = new ItemStackHandler(128);
        handler.deserializeNBT(blockEntityTag);
        ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
        boolean did = result.func_190926_b();
        if (!simulate && did) {
            NBTTagCompound newTag = handler.serializeNBT();
            ItemNBTHelper.setCompound((ItemStack)shulkerBox, (String)"BlockEntityTag", (NBTTagCompound)newTag);
        }
        return did;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == AbstractDropIn.DROP_IN_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)((Object)(capability == AbstractDropIn.DROP_IN_CAPABILITY ? this : null));
    }
}

