/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.decoration.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.interf.IRecipeGrouped;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.decoration.block.BlockCustomFlowerPot;
import vazkii.quark.decoration.client.state.ColoredFlowerPotStateMapper;

public class BlockColoredFlowerPot
extends BlockCustomFlowerPot
implements IQuarkBlock,
IRecipeGrouped {
    private final String[] variants;
    private final String bareName;

    public BlockColoredFlowerPot(EnumDyeColor color) {
        String name = "colored_flowerpot_" + color.func_176610_l();
        this.variants = new String[]{name};
        this.bareName = name;
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149663_c(name);
    }

    @Nonnull
    public Block func_149663_c(@Nonnull String name) {
        super.func_149663_c(name);
        this.register(name);
        return this;
    }

    @Nonnull
    public ItemStack func_185473_a(World worldIn, @Nonnull BlockPos pos, IBlockState state) {
        ItemStack stack = super.func_185473_a(worldIn, pos, state);
        if (stack.func_77973_b() == Items.field_151162_bE) {
            stack = new ItemStack(Item.func_150898_a((Block)this));
        }
        return stack;
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    @Nonnull
    public String func_149732_F() {
        return LanguageMap.func_74808_a().func_74805_b(this.func_149739_a() + ".name");
    }

    public String getBareName() {
        return this.bareName;
    }

    public String[] getVariants() {
        return this.variants;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getCustomMeshDefinition() {
        return null;
    }

    public EnumRarity getBlockRarity(ItemStack stack) {
        return EnumRarity.COMMON;
    }

    @SideOnly(value=Side.CLIENT)
    public IProperty<?>[] getIgnoredProperties() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IStateMapper getStateMapper() {
        return new ColoredFlowerPotStateMapper();
    }

    public IProperty<?> getVariantProp() {
        return null;
    }

    public Class<?> getVariantEnum() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return (stack, i) -> 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return (state, world, pos, i) -> Minecraft.func_71410_x().func_184125_al().func_186724_a(Blocks.field_150457_bL.func_176223_P(), world, pos, i);
    }

    public String getRecipeGroup() {
        return "colored_flower_pot";
    }
}

