/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;

public class RenderItemsInChat
extends Feature {
    private static int chatX;
    private static int chatY;
    public static final int RGB_MASK = 0xFFFFFF;
    private static int ALPHA_VALUE;

    public static ITextComponent createStackComponent(ITextComponent component) {
        if (!ModuleLoader.isFeatureEnabled(RenderItemsInChat.class)) {
            return component;
        }
        TextComponentString out = new TextComponentString("   ");
        out.func_150255_a(component.func_150256_b().func_150206_m());
        return out.func_150257_a(component);
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void getChatPos(RenderGameOverlayEvent.Chat event) {
        chatX = event.getPosX();
        chatY = event.getPosY();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderSymbols(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiIngame gameGui = mc.field_71456_v;
        GuiNewChat chatGui = gameGui.func_146158_b();
        if (event.getType() == RenderGameOverlayEvent.ElementType.CHAT) {
            int shift;
            int updateCounter = gameGui.func_73834_c();
            List lines = chatGui.field_146253_i;
            for (int idx = shift = chatGui.field_146250_j; idx < lines.size() && idx - shift < chatGui.func_146232_i(); ++idx) {
                ITextComponent component;
                ChatLine line = (ChatLine)lines.get(idx);
                String before = "";
                if (line == null || (component = line.func_151461_a()) == null) continue;
                String currentText = TextFormatting.func_110646_a((String)component.func_150261_e());
                if (currentText != null && currentText.startsWith("   ")) {
                    RenderItemsInChat.render(mc, chatGui, updateCounter, before, line, idx - shift, component);
                }
                before = before + currentText;
                for (ITextComponent sibling : component.func_150253_a()) {
                    currentText = TextFormatting.func_110646_a((String)sibling.func_150261_e());
                    if (currentText != null && currentText.startsWith("   ")) {
                        RenderItemsInChat.render(mc, chatGui, updateCounter, before, line, idx - shift, sibling);
                    }
                    before = before + currentText;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void render(Minecraft mc, GuiNewChat chatGui, int updateCounter, String before, ChatLine line, int lineHeight, ITextComponent component) {
        Style style = component.func_150256_b();
        HoverEvent hoverEvent = style.func_150210_i();
        if (hoverEvent != null && hoverEvent.func_150701_a() == HoverEvent.Action.SHOW_ITEM) {
            ItemStack stack = ItemStack.field_190927_a;
            try {
                NBTTagCompound textValue = JsonToNBT.func_180713_a((String)hoverEvent.func_150702_b().func_150260_c());
                stack = new ItemStack(textValue);
            }
            catch (NBTException textValue) {
                // empty catch block
            }
            if (stack.func_190926_b()) {
                stack = new ItemStack(Blocks.field_180401_cv);
            }
            int timeSinceCreation = updateCounter - line.func_74540_b();
            if (chatGui.func_146241_e()) {
                timeSinceCreation = 0;
            }
            if (timeSinceCreation < 200) {
                float chatOpacity = mc.field_71474_y.field_74357_r * 0.9f + 0.1f;
                float fadeOut = MathHelper.func_76131_a((float)((1.0f - (float)timeSinceCreation / 200.0f) * 10.0f), (float)0.0f, (float)1.0f);
                float alpha = fadeOut * fadeOut * chatOpacity;
                int x = chatX + 3 + mc.field_71466_p.func_78256_a(before);
                int y = chatY - mc.field_71466_p.field_78288_b * lineHeight;
                if (alpha > 0.0f) {
                    RenderHelper.func_74520_c();
                    ALPHA_VALUE = (int)(alpha * 255.0f) << 24;
                    RenderItemsInChat.renderItemIntoGUI(mc, mc.func_175599_af(), stack, x, y);
                    ALPHA_VALUE = -1;
                    RenderHelper.func_74518_a();
                }
            }
        }
    }

    public static int transformColor(int src) {
        if (ALPHA_VALUE == -1) {
            return src;
        }
        return src & 0xFFFFFF | ALPHA_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderItemIntoGUI(Minecraft mc, RenderItem render, ItemStack stack, int x, int y) {
        RenderItemsInChat.renderItemModelIntoGUI(mc, render, stack, x, y, render.func_184393_a(stack, null, null));
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderItemModelIntoGUI(Minecraft mc, RenderItem render, ItemStack stack, int x, int y, IBakedModel model) {
        TextureManager textureManager = mc.func_110434_K();
        GlStateManager.func_179094_E();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)-4.0f, (float)-4.0f, (float)-4.0f);
        render.func_180452_a(x, y, model.func_177556_c());
        GlStateManager.func_179139_a((double)0.65, (double)0.65, (double)0.65);
        model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        render.func_180454_a(stack, model);
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    static {
        ALPHA_VALUE = -1;
    }
}

