/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.util;

import net.minecraft.entity.player.EntityPlayer;

public class ExperienceHelper {
    public static int getPlayerXP(EntityPlayer player) {
        return (int)((float)ExperienceHelper.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = ExperienceHelper.getPlayerXP(player) + amount;
        player.field_71068_ca = ExperienceHelper.getLevelForExperience(experience);
        int expForLevel = ExperienceHelper.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return ExperienceHelper.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + ExperienceHelper.sum(level - 15, 37, 5);
        }
        return 1395 + ExperienceHelper.sum(level - 30, 112, 9);
    }

    public static int getXpToNextLevel(int level) {
        int levelXP = ExperienceHelper.getLevelForExperience(level);
        int nextXP = ExperienceHelper.getExperienceForLevel(level + 1);
        return nextXP - levelXP;
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = ExperienceHelper.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }
}

