/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.arl.util.ItemNBTHelper;

public class ProxiedItemStackHandler
implements IItemHandlerModifiable,
ICapabilityProvider {
    protected final ItemStack stack;
    protected final String key;
    protected final int size;

    public ProxiedItemStackHandler(ItemStack stack) {
        this(stack, "Inventory", 1);
    }

    public ProxiedItemStackHandler(ItemStack stack, String key) {
        this(stack, key, 1);
    }

    public ProxiedItemStackHandler(ItemStack stack, int size) {
        this(stack, "Inventory", size);
    }

    public ProxiedItemStackHandler(ItemStack stack, String key, int size) {
        this.stack = stack;
        this.key = key;
        this.size = size;
    }

    private NBTTagList getStackList() {
        NBTTagList list = ItemNBTHelper.getList((ItemStack)this.stack, (String)this.key, (int)10, (boolean)true);
        if (list == null) {
            list = new NBTTagList();
            ItemNBTHelper.setList((ItemStack)this.stack, (String)this.key, (NBTTagList)list);
        }
        while (list.func_74745_c() < this.size) {
            list.func_74742_a((NBTBase)new NBTTagCompound());
        }
        return list;
    }

    private void writeStack(int index, @Nonnull ItemStack stack) {
        this.getStackList().func_150304_a(index, (NBTBase)stack.serializeNBT());
        this.onContentsChanged(index);
    }

    private ItemStack readStack(int index) {
        return new ItemStack(this.getStackList().func_150305_b(index));
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.writeStack(slot, stack);
    }

    public int getSlots() {
        return this.size;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.readStack(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        this.validateSlotIndex(slot);
        if (stack.func_190926_b()) {
            return stack;
        }
        ItemStack existing = this.readStack(slot);
        if (!existing.func_190926_b() && !ItemHandlerHelper.canItemStacksStack((ItemStack)existing, (ItemStack)stack)) {
            return stack;
        }
        int toTransfer = Math.min(stack.func_190916_E(), this.getStackLimit(slot, existing) - existing.func_190916_E());
        if (toTransfer <= 0) {
            return stack;
        }
        int remainingCount = stack.func_190916_E() - toTransfer;
        if (simulate) {
            if (remainingCount <= 0) {
                return ItemStack.field_190927_a;
            }
            stack = stack.func_77946_l();
        } else {
            stack = stack.func_77946_l();
            stack.func_190920_e(existing.func_190916_E() + toTransfer);
            this.writeStack(slot, stack);
            if (remainingCount <= 0) {
                return ItemStack.field_190927_a;
            }
        }
        stack.func_190920_e(remainingCount);
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.validateSlotIndex(slot);
        if (amount <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = this.readStack(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (amount >= existing.func_190916_E()) {
            if (!simulate) {
                this.writeStack(slot, ItemStack.field_190927_a);
            }
        } else {
            if (!simulate) {
                existing.func_190920_e(existing.func_190916_E() - amount);
                this.writeStack(slot, existing);
            }
            existing.func_190920_e(amount);
        }
        return existing;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.size) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.size + ")");
        }
    }

    protected void onContentsChanged(int slot) {
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this) : null);
    }
}

