/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.command;

import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.command.help.IBetterHelpCommand;
import codechicken.lib.util.ArrayUtils;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ClearCommand
extends CommandBase
implements IBetterHelpCommand {
    public String func_71517_b() {
        return "clear";
    }

    public String getDesc() {
        return "Provides ability to clear a users EnderStorage.";
    }

    public List<String> getHelp() {
        LinkedList<String> lines = new LinkedList<String>();
        lines.add("[] Defines required choice parameters.");
        lines.add("<> Defines optional parameters.");
        lines.add("Syntax: \"/EnderStorage clear [item|liquid|*] [freq|*] <player>\"");
        lines.add("If you don't provide a player it will clear all global Storage's.");
        lines.add("To clear all player Storage's provide \"*\" as the player.");
        lines.add("For frequency syntax use \"/EnderStorage help frequency\"");
        return lines;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Not Enough Arguments!"));
            this.displayHelpText(sender);
            return;
        }
        String identifier = args[0];
        String frequency = args[1];
        String owner = null;
        if (args.length == 3) {
            owner = args[2];
        }
        Set<String> identifiers = EnderStorageManager.getPlugins().keySet();
        if ("*".equals(identifier)) {
            for (String ident : identifiers) {
                ClearCommand.nukeStorage(ident, frequency, owner, sender);
            }
        } else if (identifiers.contains(identifier)) {
            ClearCommand.nukeStorage(identifier, frequency, owner, sender);
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid Storage Identifier [" + identifier + "]"));
            sender.func_145747_a((ITextComponent)new TextComponentString("For valid Identifiers run, " + TextFormatting.YELLOW + "\"/EnderStorage help validStorage\""));
        }
    }

    private static void nukeStorage(String identifier, String frequency, String owner, ICommandSender sender) throws CommandException {
        Predicate<String> frequencyPredicate;
        EnderStorageManager manager = EnderStorageManager.instance(false);
        List<String> validKeys = manager.getValidKeys(identifier);
        if ("*".equals(frequency)) {
            frequencyPredicate = input -> true;
        } else {
            String[] split = frequency.split(",");
            if (split != null && split.length == 3) {
                for (String c : split) {
                    boolean valid = false;
                    for (EnumColour colour : EnumColour.values()) {
                        if (!colour.func_176610_l().equalsIgnoreCase(c)) continue;
                        valid = true;
                    }
                    if (valid) continue;
                    throw new CommandException(c + " is an invalid colour! \"/EnderStorage help colour\"", new Object[0]);
                }
                frequencyPredicate = input -> {
                    if (Strings.isNullOrEmpty((String)input)) {
                        return false;
                    }
                    Map kvArray = ArrayUtils.convertKeyValueArrayToMap((String[])input.split(","));
                    return ((String)kvArray.get("left")).equalsIgnoreCase(split[0]) && ((String)kvArray.get("middle")).equalsIgnoreCase(split[1]) && ((String)kvArray.get("right")).equalsIgnoreCase(split[2]);
                };
            } else {
                throw new CommandException("Invalid frequency format! \"<colour>,<colour>,<colour>\"", new Object[0]);
            }
        }
        Predicate<String> ownerPredicate = owner == null ? Objects::isNull : ("*".equals(owner) ? input -> !Strings.isNullOrEmpty((String)input) : owner::equals);
        boolean noStorage = true;
        ArrayList<String> cleared = new ArrayList<String>();
        for (String key : validKeys) {
            Map kvArray = ArrayUtils.convertKeyValueArrayToMap((String[])key.split(","));
            if (!frequencyPredicate.test(key) || !ownerPredicate.test((String)kvArray.get("owner"))) continue;
            noStorage = false;
            Frequency freq = Frequency.fromString((String)kvArray.get("left"), (String)kvArray.get("middle"), (String)kvArray.get("right"), (String)kvArray.get("owner"));
            AbstractEnderStorage storage = manager.getStorage(freq, identifier);
            storage.clearStorage();
            cleared.add(freq.toString());
        }
        if (noStorage) {
            throw new CommandException("No storage's exist for that colour and owner..", new Object[0]);
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Successfully cleared " + cleared.size() + " Storage's!"));
        for (String entry : cleared) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BLUE + entry));
        }
    }
}

