/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JEIPlugin;
import mezz.jei.util.Log;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public final class AnnotatedInstanceUtil {
    private AnnotatedInstanceUtil() {
    }

    public static List<IModPlugin> getModPlugins(ASMDataTable asmDataTable) {
        return AnnotatedInstanceUtil.getInstances(asmDataTable, JEIPlugin.class, IModPlugin.class);
    }

    private static <T> List<T> getInstances(ASMDataTable asmDataTable, Class annotationClass, Class<T> instanceClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<T> instances = new ArrayList<T>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                T instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError e) {
                Log.get().error("Failed to load: {}", (Object)asmData.getClassName(), (Object)e);
            }
        }
        return instances;
    }
}

