/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.trees.overworld;

import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.IPlantable;

public class OverworldTreeGenerator
extends BaseTreeGenerator {
    public final int minTreeHeight;
    public final int treeHeightRange;
    public final IBlockState log;
    public final IBlockState leaves;
    public final boolean seekHeight;
    public final boolean isSapling;

    public OverworldTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves, boolean seekHeight, boolean isSapling) {
        this.minTreeHeight = treeHeight;
        this.treeHeightRange = treeRange;
        this.log = log;
        this.leaves = leaves;
        this.seekHeight = seekHeight;
        this.isSapling = isSapling;
    }

    public OverworldTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves) {
        this(treeHeight, treeRange, log, leaves, true, false);
    }

    @Override
    public void generateTree(Random rand, World worldIn, BlockPos position) {
        IBlockState state;
        Block soil;
        boolean isSoil;
        int heightRange = rand.nextInt(this.treeHeightRange) + this.minTreeHeight;
        if (this.seekHeight && (position = this.findGround(worldIn, position)).func_177956_o() < 0) {
            return;
        }
        if (position.func_177956_o() >= 1 && position.func_177956_o() + heightRange + 1 <= 256 && (isSoil = (soil = (state = worldIn.func_180495_p(position.func_177977_b())).func_177230_c()).canSustainPlant(state, (IBlockAccess)worldIn, position.func_177977_b(), EnumFacing.UP, (IPlantable)NaturaOverworld.overworldSapling))) {
            if (!this.checkIfCanGrow(position, heightRange, worldIn)) {
                return;
            }
            soil.onPlantGrow(state, worldIn, position.func_177977_b(), position);
            this.placeCanopy(worldIn, rand, position, heightRange);
            this.placeTrunk(worldIn, position, heightRange);
        }
    }

    protected void placeCanopy(World world, Random random, BlockPos pos, int height) {
        for (int y = pos.func_177956_o() - 3 + height; y <= pos.func_177956_o() + height; ++y) {
            int subtract = y - (pos.func_177956_o() + height);
            int subtract2 = 1 - subtract / 2;
            for (int x = pos.func_177958_n() - subtract2; x <= pos.func_177958_n() + subtract2; ++x) {
                int mathX = x - pos.func_177958_n();
                for (int z = pos.func_177952_p() - subtract2; z <= pos.func_177952_p() + subtract2; ++z) {
                    BlockPos blockpos;
                    IBlockState state;
                    int mathZ = z - pos.func_177952_p();
                    if (Math.abs(mathX) == subtract2 && Math.abs(mathZ) == subtract2 && (random.nextInt(2) == 0 || subtract == 0) || !(state = world.func_180495_p(blockpos = new BlockPos(x, y, z))).func_177230_c().isAir(state, (IBlockAccess)world, blockpos) && !state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, blockpos)) continue;
                    world.func_180501_a(blockpos, this.leaves, 2);
                }
            }
        }
    }

    protected void placeTrunk(World world, BlockPos pos, int height) {
        for (int localHeight = 0; localHeight < height; ++localHeight) {
            BlockPos blockpos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + localHeight, pos.func_177952_p());
            IBlockState state = world.func_180495_p(blockpos);
            Block block = state.func_177230_c();
            if (!block.isAir(state, (IBlockAccess)world, blockpos)) continue;
            world.func_180501_a(blockpos, this.log, 2);
        }
    }

    protected BlockPos findGround(World world, BlockPos pos) {
        int minHeight;
        int height = pos.func_177956_o();
        int n = minHeight = world.func_175624_G() == WorldType.field_77138_c ? Config.flatSeaLevel : Config.seaLevel;
        do {
            BlockPos position;
            IBlockState state;
            Block block;
            boolean isSoil;
            if (!(isSoil = (block = (state = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), height, pos.func_177952_p()))).func_177230_c()).canSustainPlant(state, (IBlockAccess)world, position, EnumFacing.UP, (IPlantable)NaturaOverworld.overworldSapling)) || world.func_180495_p(position.func_177984_a()).func_185913_b()) continue;
            return new BlockPos(pos.func_177958_n(), height + 1, pos.func_177952_p());
        } while (--height >= minHeight);
        BlockPos originalPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        IBlockState originalState = world.func_180495_p(originalPos);
        if (originalState.func_177230_c().canSustainPlant(originalState, (IBlockAccess)world, originalPos, EnumFacing.UP, (IPlantable)NaturaOverworld.overworldSapling) && !world.func_180495_p(originalPos.func_177984_a()).func_185913_b()) {
            return originalPos.func_177984_a();
        }
        return new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
    }

    protected boolean checkIfCanGrow(BlockPos position, int heightRange, World world) {
        boolean canGrowTree = true;
        for (int y = position.func_177956_o(); y <= position.func_177956_o() + 1 + heightRange; ++y) {
            int range = 1;
            if (y == position.func_177956_o()) {
                range = 0;
            }
            if (y >= position.func_177956_o() + 1 + heightRange - 2) {
                range = 2;
            }
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            for (int x = position.func_177958_n() - range; x <= position.func_177958_n() + range && canGrowTree; ++x) {
                for (int z = position.func_177952_p() - range; z <= position.func_177952_p() + range && canGrowTree; ++z) {
                    blockPos.func_181079_c(x, y, z);
                    IBlockState state = world.func_180495_p((BlockPos)blockPos);
                    canGrowTree = state.func_177230_c().isAir(state, (IBlockAccess)world, (BlockPos)blockPos) || state.func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)blockPos);
                }
            }
        }
        return canGrowTree;
    }
}

