/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.trees.overworld;

import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class HopseedTreeGenerator
extends BaseTreeGenerator {
    public final int minTreeHeight;
    public final int treeHeightRange;
    public final IBlockState log;
    public final IBlockState leaves;
    public final boolean seekHeight;
    public final boolean isSapling;

    public HopseedTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves, boolean seekHeight, boolean isSapling) {
        this.minTreeHeight = treeHeight;
        this.treeHeightRange = treeRange;
        this.log = log;
        this.leaves = leaves;
        this.seekHeight = seekHeight;
        this.isSapling = isSapling;
    }

    public HopseedTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves) {
        this(treeHeight, treeRange, log, leaves, true, false);
    }

    @Override
    public void generateTree(Random random, World worldIn, BlockPos position) {
        int height = random.nextInt(this.treeHeightRange) + this.minTreeHeight;
        if (this.seekHeight) {
            while (position.func_177956_o() > 1 && worldIn.func_175623_d(position)) {
                position = position.func_177977_b();
            }
            if (position.func_177956_o() < 0) {
                return;
            }
        }
        if (!this.blocksMatch(worldIn, position)) {
            return;
        }
        position = position.func_177984_a();
        boolean hasSpace = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            for (int y = position.func_177956_o(); y <= position.func_177956_o() + 1 + height; ++y) {
                int radius = 1;
                if (y == position.func_177956_o()) {
                    radius = 0;
                }
                if (y >= position.func_177956_o() + 1 + height - 2) {
                    radius = 2;
                }
                BlockPos.MutableBlockPos mutableblockpos = new BlockPos.MutableBlockPos();
                for (int x = position.func_177958_n() - radius; x <= position.func_177958_n() + radius && hasSpace; ++x) {
                    for (int z = position.func_177952_p() - radius; z <= position.func_177952_p() + radius && hasSpace; ++z) {
                        if (y >= 0 && y < 256) {
                            if (this.isReplaceable(worldIn, (BlockPos)mutableblockpos.func_181079_c(x, y, z))) continue;
                            hasSpace = false;
                            continue;
                        }
                        hasSpace = false;
                    }
                }
            }
            if (hasSpace) {
                BlockPos downPosition = position.func_177977_b();
                IBlockState state = worldIn.func_180495_p(downPosition);
                state.func_177230_c();
                boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, downPosition, EnumFacing.UP, (IPlantable)NaturaOverworld.overworldSapling2);
                if (isSoil && position.func_177956_o() < 256 - height - 1) {
                    this.onPlantGrow(worldIn, downPosition, position);
                    this.onPlantGrow(worldIn, downPosition.func_177974_f(), position);
                    this.onPlantGrow(worldIn, downPosition.func_177968_d(), position);
                    this.onPlantGrow(worldIn, downPosition.func_177968_d().func_177974_f(), position);
                    this.growLogs(worldIn, position);
                    this.growLeaves(worldIn, random, position, height);
                    for (int l = 0; l < height; ++l) {
                        BlockPos blockpos = position.func_177981_b(l);
                        IBlockState newState = worldIn.func_180495_p(blockpos);
                        if (newState.func_177230_c() == Blocks.field_150350_a) {
                            worldIn.func_180501_a(blockpos, this.log, 0);
                        }
                        if (l >= height - 1) continue;
                        blockpos = position.func_177982_a(1, l, 0);
                        newState = worldIn.func_180495_p(blockpos);
                        if (newState.func_177230_c() == Blocks.field_150350_a) {
                            worldIn.func_180501_a(blockpos, this.log, 0);
                        }
                        if ((newState = worldIn.func_180495_p(blockpos = position.func_177982_a(1, l, 1))).func_177230_c() == Blocks.field_150350_a) {
                            worldIn.func_180501_a(blockpos, this.log, 0);
                        }
                        if ((newState = worldIn.func_180495_p(blockpos = position.func_177982_a(0, l, 1))).func_177230_c() != Blocks.field_150350_a) continue;
                        worldIn.func_180501_a(blockpos, this.log, 0);
                    }
                }
            }
        }
    }

    public boolean isReplaceable(World worldIn, BlockPos positionIn) {
        IBlockState state = worldIn.func_180495_p(positionIn);
        return state.func_177230_c().isAir(state, (IBlockAccess)worldIn, positionIn);
    }

    protected void growLeaves(World worldIn, Random random, BlockPos positionIn, int height) {
        for (int y = positionIn.func_177956_o() - 2 + height; y <= positionIn.func_177956_o() + height; ++y) {
            int subtract = y - (positionIn.func_177956_o() + height);
            int subtract2 = 3 - subtract;
            for (int x = positionIn.func_177958_n() - subtract2; x <= positionIn.func_177958_n() + subtract2; ++x) {
                int mathX = x - positionIn.func_177958_n();
                for (int z = positionIn.func_177952_p() - subtract2; z <= positionIn.func_177952_p() + subtract2; ++z) {
                    int mathZ = z - positionIn.func_177952_p();
                    BlockPos blockpos = new BlockPos(x, y, z);
                    IBlockState state = worldIn.func_180495_p(blockpos);
                    if (mathX < 0 && mathZ < 0 && mathX * mathX + mathZ * mathZ > subtract2 * subtract2 || (mathX > 0 || mathZ > 0) && mathX * mathX + mathZ * mathZ > (subtract2 + 1) * (subtract2 + 1) || random.nextInt(4) == 0 && mathX * mathX + mathZ * mathZ > (subtract2 - 1) * (subtract2 - 1) || !state.func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos) && !state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)worldIn, blockpos)) continue;
                    this.setBlockAndMetadata(worldIn, blockpos, this.leaves);
                }
            }
        }
    }

    protected void setBlockAndMetadata(World worldIn, BlockPos positionIn, IBlockState stateNew) {
        IBlockState state = worldIn.func_180495_p(positionIn);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)worldIn, positionIn) || block.func_176196_c(worldIn, positionIn) || worldIn.func_180495_p(positionIn) == this.leaves) {
            worldIn.func_180501_a(positionIn, stateNew, 2);
        }
    }

    private boolean blocksMatch(World world, BlockPos pos) {
        IBlockState underState = world.func_180495_p(pos);
        Block underBlock = underState.func_177230_c();
        return underBlock.canSustainPlant(underState, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)NaturaOverworld.overworldSapling);
    }

    private void growLogs(World worldIn, BlockPos positionIn) {
        this.setBlockAndMetadata(worldIn, positionIn, this.log);
        this.setBlockAndMetadata(worldIn, positionIn.func_177982_a(1, 0, 0), this.log);
        this.setBlockAndMetadata(worldIn, positionIn.func_177982_a(0, 0, 1), this.log);
        this.setBlockAndMetadata(worldIn, positionIn.func_177982_a(1, 0, 1), this.log);
        this.setBlockAndMetadata(worldIn, positionIn.func_177982_a(0, 1, 0), this.log);
        this.setBlockAndMetadata(worldIn, positionIn.func_177982_a(1, 1, 0), this.log);
        this.setBlockAndMetadata(worldIn, positionIn.func_177982_a(0, 1, 1), this.log);
        this.setBlockAndMetadata(worldIn, positionIn.func_177982_a(1, 1, 1), this.log);
    }

    private void onPlantGrow(World worldIn, BlockPos positionIn, BlockPos source) {
        IBlockState state = worldIn.func_180495_p(positionIn);
        state.func_177230_c().onPlantGrow(state, worldIn, positionIn, source);
    }
}

