/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.trees.overworld;

import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class EucalyptusTreeGenerator
extends BaseTreeGenerator {
    public final int minTreeHeight;
    public final int treeHeightRange;
    public final IBlockState log;
    public final IBlockState leaves;
    public final boolean seekHeight;

    public EucalyptusTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves, boolean seekHeight) {
        this.minTreeHeight = treeHeight;
        this.treeHeightRange = treeRange;
        this.log = log;
        this.leaves = leaves;
        this.seekHeight = seekHeight;
    }

    public EucalyptusTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves) {
        this(treeHeight, treeRange, log, leaves, true);
    }

    @Override
    public void generateTree(Random random, World world, BlockPos pos) {
        int height = random.nextInt(this.treeHeightRange) + this.minTreeHeight;
        if (this.seekHeight && (pos = this.findGround(world, pos)).func_177956_o() < 0) {
            return;
        }
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= 256) {
            IBlockState state;
            Block soil;
            boolean isSoil;
            for (int j = pos.func_177956_o(); j <= pos.func_177956_o() + 1 + height; ++j) {
                int k = 1;
                if (j == pos.func_177956_o()) {
                    k = 0;
                }
                if (j >= pos.func_177956_o() + 1 + height - 2) {
                    k = 3;
                }
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int l = pos.func_177958_n() - k; l <= pos.func_177958_n() + k && flag; ++l) {
                    for (int i1 = pos.func_177952_p() - k; i1 <= pos.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < 256) {
                            IBlockState iblockstate = world.func_180495_p((BlockPos)mutableBlockPos.func_181079_c(l, j, i1));
                            if (iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)world, (BlockPos)mutableBlockPos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (flag && (isSoil = (soil = (state = world.func_180495_p(pos.func_177977_b())).func_177230_c()).canSustainPlant(state, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)NaturaOverworld.overworldSapling))) {
                soil.onPlantGrow(state, world, pos.func_177977_b(), pos);
                this.placeTrunk(world, pos, height);
                this.genBranch(world, random, pos, height, 1);
                this.genBranch(world, random, pos, height, 2);
                this.genBranch(world, random, pos, height, 3);
                this.genBranch(world, random, pos, height, 4);
                this.genStraightBranch(world, random, pos, height, 1);
                this.genStraightBranch(world, random, pos, height, 2);
                this.genStraightBranch(world, random, pos, height, 3);
                this.genStraightBranch(world, random, pos, height, 4);
                this.generateNode(world, pos.func_177981_b(height));
            }
        }
    }

    public void generateNode(World world, BlockPos pos) {
        Block block;
        IBlockState state;
        BlockPos newPos;
        int zIter;
        int xIter;
        this.setBlockAndMetadata(world, pos, this.log);
        for (xIter = pos.func_177958_n() - 2; xIter <= pos.func_177958_n() + 2; ++xIter) {
            for (zIter = pos.func_177952_p() - 1; zIter <= pos.func_177952_p() + 1; ++zIter) {
                newPos = new BlockPos(xIter, pos.func_177956_o(), zIter);
                state = world.func_180495_p(newPos);
                block = state.func_177230_c();
                if (block == NaturaOverworld.overworldLeaves2 || block.func_149730_j(state)) continue;
                this.setBlockAndMetadata(world, newPos, this.leaves);
            }
        }
        for (xIter = pos.func_177958_n() - 1; xIter <= pos.func_177958_n() + 1; ++xIter) {
            for (zIter = pos.func_177952_p() - 2; zIter <= pos.func_177952_p() + 2; ++zIter) {
                newPos = new BlockPos(xIter, pos.func_177956_o(), zIter);
                state = world.func_180495_p(newPos);
                block = state.func_177230_c();
                if (block == NaturaOverworld.overworldLeaves2 || block.func_149730_j(state)) continue;
                this.setBlockAndMetadata(world, newPos, this.leaves);
            }
        }
        for (xIter = pos.func_177958_n() - 1; xIter <= pos.func_177958_n() + 1; ++xIter) {
            for (zIter = pos.func_177952_p() - 1; zIter <= pos.func_177952_p() + 1; ++zIter) {
                newPos = new BlockPos(xIter, pos.func_177956_o() + 1, zIter);
                state = world.func_180495_p(newPos);
                block = state.func_177230_c();
                if (block == NaturaOverworld.overworldLeaves2 || block.func_149730_j(state)) continue;
                this.setBlockAndMetadata(world, newPos, this.leaves);
            }
        }
    }

    protected void placeTrunk(World world, BlockPos pos, int height) {
        while (height >= 0) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block.isAir(state, (IBlockAccess)world, pos)) {
                this.setBlockAndMetadata(world, pos, this.log);
            }
            pos = pos.func_177984_a();
            --height;
        }
    }

    protected void setBlockAndMetadata(World world, BlockPos pos, IBlockState stateNew) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos) || block.func_176196_c(world, pos) || world.func_180495_p(pos) == this.leaves) {
            world.func_180501_a(pos, stateNew, 2);
        }
    }

    protected BlockPos findGround(World world, BlockPos pos) {
        int returnHeight = 0;
        BlockPos posDown = pos.func_177977_b();
        IBlockState stateDown = world.func_180495_p(posDown);
        Block blockDown = stateDown.func_177230_c();
        boolean isSoilDown = blockDown.canSustainPlant(stateDown, (IBlockAccess)world, posDown, EnumFacing.UP, (IPlantable)NaturaOverworld.overworldSapling);
        if (!world.func_180495_p(pos).func_185913_b() && isSoilDown) {
            return pos;
        }
        int y = 96;
        do {
            BlockPos position;
            IBlockState state;
            Block block;
            boolean isSoil;
            if (!(isSoil = (block = (state = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p()))).func_177230_c()).canSustainPlant(state, (IBlockAccess)world, position, EnumFacing.UP, (IPlantable)NaturaOverworld.overworldSapling)) || world.func_180495_p(position.func_177984_a()).func_185913_b()) continue;
            returnHeight = y + 1;
            break;
        } while (--y >= 32);
        return new BlockPos(pos.func_177958_n(), returnHeight, pos.func_177952_p());
    }

    private void genBranch(World world, Random random, BlockPos pos, int height, int direction) {
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o() + height - 3;
        int posZ = pos.func_177952_p();
        int byte0 = 0;
        int byte1 = 0;
        switch (direction) {
            case 1: {
                byte0 = 1;
                byte1 = 1;
                break;
            }
            case 2: {
                byte0 = -1;
                byte1 = 1;
                break;
            }
            case 3: {
                byte0 = 1;
                byte1 = -1;
                break;
            }
            case 4: {
                byte0 = -1;
                byte1 = -1;
            }
        }
        int heightShift = random.nextInt(6);
        for (int bIter = 4; bIter > 0; --bIter) {
            if (heightShift % 3 != 0) {
                posX += byte0;
            }
            if (heightShift % 3 != 1) {
                posZ += byte1;
            }
            int branch = heightShift % 3;
            BlockPos blockpos = new BlockPos(posX, posY += branch, posZ);
            if (branch == 2) {
                this.setBlockAndMetadata(world, blockpos.func_177977_b(), this.log);
            }
            this.setBlockAndMetadata(world, blockpos, this.log);
            if (bIter == 1) {
                this.generateNode(world, blockpos);
            }
            heightShift = random.nextInt(6);
        }
    }

    private void genStraightBranch(World world, Random random, BlockPos pos, int height, int direction) {
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o() + height - 3;
        int posZ = pos.func_177952_p();
        int xShift = 0;
        int zShift = 0;
        switch (direction) {
            case 1: {
                xShift = 1;
                break;
            }
            case 2: {
                zShift = 1;
                break;
            }
            case 3: {
                xShift = -1;
                break;
            }
            case 4: {
                zShift = -1;
            }
        }
        int heightShift = random.nextInt(6);
        for (int j2 = 4; j2 > 0; --j2) {
            if (xShift == 0) {
                posX = posX + random.nextInt(3) - 1;
                posZ += zShift;
            }
            if (zShift == 0) {
                posX += xShift;
                posZ = posZ + random.nextInt(3) - 1;
            }
            int branch = heightShift % 3;
            BlockPos blockpos = new BlockPos(posX, posY += branch, posZ);
            if (branch == 2) {
                this.setBlockAndMetadata(world, blockpos.func_177977_b(), this.log);
            }
            this.setBlockAndMetadata(world, blockpos, this.log);
            if (j2 == 1) {
                this.generateNode(world, blockpos);
            }
            heightShift = random.nextInt(6);
        }
    }
}

