/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.trees.overworld;

import com.progwml6.natura.world.worldgen.trees.overworld.OverworldTreeGenerator;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class AppleTreeGenerator
extends OverworldTreeGenerator {
    public final int minTreeHeight;
    public final int treeHeightRange;
    public final IBlockState log;
    public final IBlockState leaves;
    public final IBlockState flowering;
    public final IBlockState fruiting;
    public final IBlockState fruitingGolden;
    public final boolean seekHeight;
    public final boolean isSapling;

    public AppleTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves, IBlockState flowering, IBlockState fruiting, IBlockState fruitingGolden, boolean seekHeight, boolean isSapling) {
        super(treeHeight, treeRange, log, leaves, seekHeight, isSapling);
        this.minTreeHeight = treeHeight;
        this.treeHeightRange = treeRange;
        this.log = log;
        this.leaves = leaves;
        this.flowering = flowering;
        this.fruiting = fruiting;
        this.fruitingGolden = fruitingGolden;
        this.seekHeight = seekHeight;
        this.isSapling = isSapling;
    }

    public AppleTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves, IBlockState flowering, IBlockState fruiting, IBlockState fruitingGolden) {
        this(treeHeight, treeRange, log, leaves, flowering, fruiting, fruitingGolden, true, false);
    }

    @Override
    protected void placeCanopy(World world, Random random, BlockPos pos, int height) {
        for (int y = pos.func_177956_o() - 3 + height; y <= pos.func_177956_o() + height; ++y) {
            int subtract = y - (pos.func_177956_o() + height);
            int subtract2 = 1 - subtract / 2;
            for (int x = pos.func_177958_n() - subtract2; x <= pos.func_177958_n() + subtract2; ++x) {
                int mathX = x - pos.func_177958_n();
                for (int z = pos.func_177952_p() - subtract2; z <= pos.func_177952_p() + subtract2; ++z) {
                    BlockPos blockpos;
                    IBlockState state;
                    int mathZ = z - pos.func_177952_p();
                    if (Math.abs(mathX) == subtract2 && Math.abs(mathZ) == subtract2 && (random.nextInt(2) == 0 || subtract == 0) || !(state = world.func_180495_p(blockpos = new BlockPos(x, y, z))).func_177230_c().isAir(state, (IBlockAccess)world, blockpos) && !state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, blockpos)) continue;
                    world.func_180501_a(blockpos, this.getRandomizedLeaves(random), 2);
                }
            }
        }
    }

    protected IBlockState getRandomizedLeaves(Random random) {
        int chance = random.nextInt(200);
        if (chance == 0) {
            return this.fruitingGolden;
        }
        if (chance < 25) {
            return this.fruiting;
        }
        if (chance < 40) {
            return this.flowering;
        }
        return this.leaves;
    }
}

